/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.enricher;

import java.util.Optional;
import javax.xml.namespace.QName;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.model.declaration.fluent.ExecutableComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.extension.api.declaration.type.StreamingStrategyTypeBuilder;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.IdempotentDeclarationEnricherWalkDelegate;
import org.mule.runtime.extension.api.loader.WalkingDeclarationEnricher;
import org.mule.runtime.extension.api.util.XmlModelUtils;
import org.mule.runtime.extension.internal.loader.util.InfrastructureParameterBuilder;
import org.mule.runtime.extension.internal.property.NoStreamingConfigurationModelProperty;
import org.mule.runtime.extension.internal.property.PagedOperationModelProperty;

public class StreamingDeclarationEnricher
implements WalkingDeclarationEnricher {
    @Override
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.STRUCTURE;
    }

    @Override
    public Optional<WalkingDeclarationEnricher.DeclarationEnricherWalkDelegate> getWalkDelegate(ExtensionLoadingContext extensionLoadingContext) {
        return Optional.of(new IdempotentDeclarationEnricherWalkDelegate(){

            @Override
            protected void onOperation(OperationDeclaration declaration) {
                StreamingDeclarationEnricher.this.enrich(declaration);
            }

            @Override
            protected void onSource(SourceDeclaration declaration) {
                StreamingDeclarationEnricher.this.enrich(declaration);
            }
        });
    }

    private void enrich(ExecutableComponentDeclaration declaration) {
        QName qName;
        MetadataType type;
        if (!declaration.isSupportsStreaming() || declaration.getModelProperty(NoStreamingConfigurationModelProperty.class).isPresent()) {
            return;
        }
        if (declaration.getModelProperty(PagedOperationModelProperty.class).isPresent()) {
            type = new StreamingStrategyTypeBuilder().getObjectStreamingStrategyType();
            qName = XmlModelUtils.MULE_ABSTRACT_OBJECT_STREAMING_STRATEGY_QNAME;
        } else {
            type = new StreamingStrategyTypeBuilder().getByteStreamingStrategyType();
            qName = XmlModelUtils.MULE_ABSTRACT_BYTE_STREAMING_STRATEGY_QNAME;
        }
        InfrastructureParameterBuilder.addStreamingParameter(declaration, type, qName);
    }
}

