/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.xml.model;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ArtifactType;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ImportedResource;
import org.mule.runtime.ast.api.util.BaseArtifactAst;
import org.mule.runtime.ast.internal.error.CompositeErrorTypeRepository;

public final class AggregatedMultiConfigsArtifactAst
extends BaseArtifactAst {
    private final ArtifactAst parentArtifact;
    private final List<ArtifactAst> parsedAstsList;
    private final LazyValue<Set<ExtensionModel>> dependencies;
    private final LazyValue<ErrorTypeRepository> errorTypeRepo;
    private final LazyValue<List<ComponentAst>> topLevelComponents;
    private final LazyValue<List<ImportedResource>> importedResources;

    public AggregatedMultiConfigsArtifactAst(ArtifactAst parentArtifact, List<ArtifactAst> parsedAstsList) {
        this.parentArtifact = parentArtifact;
        this.parsedAstsList = parsedAstsList;
        this.dependencies = new LazyValue<Supplier<Set>>(() -> parsedAstsList.stream().flatMap(ast -> ast.dependencies().stream()).collect(Collectors.toSet()));
        this.errorTypeRepo = new LazyValue<Supplier<ErrorTypeRepository>>(() -> new CompositeErrorTypeRepository(parsedAstsList.stream().map(ArtifactAst::getErrorTypeRepository).collect(Collectors.toList())));
        this.topLevelComponents = new LazyValue<Supplier<List>>(() -> parsedAstsList.stream().flatMap(ArtifactAst::topLevelComponentsStream).collect(Collectors.toList()));
        this.importedResources = new LazyValue<Supplier<List>>(() -> parsedAstsList.stream().flatMap(ast -> ast.getImportedResources().stream()).collect(Collectors.toList()));
    }

    @Override
    public String getArtifactName() {
        return this.parsedAstsList.get(0).getArtifactName();
    }

    @Override
    public ArtifactType getArtifactType() {
        return this.parsedAstsList.get(0).getArtifactType();
    }

    @Override
    public Set<ExtensionModel> dependencies() {
        return this.dependencies.get();
    }

    @Override
    public Optional<ArtifactAst> getParent() {
        return Optional.ofNullable(this.parentArtifact);
    }

    @Override
    public List<ComponentAst> topLevelComponents() {
        return this.topLevelComponents.get();
    }

    @Override
    public void updatePropertiesResolver(UnaryOperator<String> newPropertiesResolver) {
        this.parsedAstsList.forEach(ast -> ast.updatePropertiesResolver(newPropertiesResolver));
    }

    @Override
    public ErrorTypeRepository getErrorTypeRepository() {
        return this.errorTypeRepo.get();
    }

    @Override
    public Collection<ImportedResource> getImportedResources() {
        return this.importedResources.get();
    }
}

