/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.mediatype;

import java.util.Collection;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.core.internal.util.mediatype.MediaTypeDecoratedResultIterator;
import org.mule.runtime.core.internal.util.mediatype.PayloadMediaTypeResolver;
import org.mule.sdk.api.runtime.operation.Result;

public class MediaTypeDecoratedResultCollection
implements Collection<Result> {
    private final Collection<Result> delegate;
    protected final PayloadMediaTypeResolver payloadMediaTypeResolver;

    public MediaTypeDecoratedResultCollection(Collection<Result> delegate, PayloadMediaTypeResolver payloadMediaTypeResolver) {
        this.delegate = delegate;
        this.payloadMediaTypeResolver = payloadMediaTypeResolver;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Result) {
            return this.delegate.contains(this.payloadMediaTypeResolver.resolve((Result)o));
        }
        return this.delegate.contains(o);
    }

    @Override
    public Iterator<Result> iterator() {
        return new MediaTypeDecoratedResultIterator(this.delegate.iterator(), this.payloadMediaTypeResolver);
    }

    @Override
    public Object[] toArray() {
        return this.transformArray(this.delegate.toArray());
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.transformArray(this.delegate.toArray(a));
    }

    private <T> T[] transformArray(T[] array) {
        return Stream.of(array).map(o -> o instanceof Result ? this.payloadMediaTypeResolver.resolve((Result)o) : o).toArray(Object[]::new);
    }

    @Override
    public boolean add(Result result) {
        return this.delegate.add(result);
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof Result) {
            return this.delegate.remove(this.payloadMediaTypeResolver.resolve((Result)o));
        }
        return this.delegate.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return c.stream().allMatch(this.delegate::contains);
    }

    @Override
    public boolean addAll(Collection<? extends Result> c) {
        return this.delegate.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return c.stream().map(this.delegate::remove).anyMatch(deleted -> deleted);
    }

    @Override
    public boolean removeIf(Predicate<? super Result> filter) {
        return this.delegate.removeIf((? super E result) -> filter.test(this.payloadMediaTypeResolver.resolve((Result)result)));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.delegate.retainAll(c.stream().map(item -> item instanceof Result ? this.payloadMediaTypeResolver.resolve((Result)item) : item).collect(Collectors.toSet()));
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public Spliterator<Result> spliterator() {
        return this.delegate.stream().map(this.payloadMediaTypeResolver::resolve).collect(Collectors.toList()).spliterator();
    }

    @Override
    public Stream<Result> stream() {
        return this.delegate.stream().map(this.payloadMediaTypeResolver::resolve);
    }

    @Override
    public Stream<Result> parallelStream() {
        return this.delegate.parallelStream().map(this.payloadMediaTypeResolver::resolve);
    }
}

