/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.domain;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Objects;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.util.CaseInsensitiveMapWrapper;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.AbstractCaseInsensitiveMultiMap;
import org.mule.runtime.http.api.domain.OptimizedCaseInsensitiveMapWrapper;

@NoExtend
public class CaseInsensitiveMultiMap
extends AbstractCaseInsensitiveMultiMap {
    private static final long serialVersionUID = -3754163327838153655L;
    private static final CaseInsensitiveMultiMap EMPTY_MAP = new CaseInsensitiveMultiMap().toImmutableMultiMap();
    protected final boolean optimized;

    public static CaseInsensitiveMultiMap emptyCaseInsensitiveMultiMap() {
        return EMPTY_MAP;
    }

    public static AbstractCaseInsensitiveMultiMap unmodifiableCaseInsensitiveMultiMap(AbstractCaseInsensitiveMultiMap m) {
        Objects.requireNonNull(m);
        if (m instanceof AbstractCaseInsensitiveMultiMap.UnmodifiableCaseInsensitiveMultiMap || m instanceof ImmutableCaseInsensitiveMultiMap) {
            return m;
        }
        return new AbstractCaseInsensitiveMultiMap.UnmodifiableCaseInsensitiveMultiMap(m);
    }

    public CaseInsensitiveMultiMap() {
        this(true);
    }

    public CaseInsensitiveMultiMap(boolean optimized) {
        this.optimized = optimized;
        this.paramsMap = optimized ? new OptimizedCaseInsensitiveMapWrapper(new LinkedHashMap()) : new CaseInsensitiveMapWrapper(new LinkedHashMap());
    }

    public CaseInsensitiveMultiMap(MultiMap<String, String> paramsMap) {
        this(paramsMap, true);
    }

    public CaseInsensitiveMultiMap(MultiMap<String, String> paramsMap, boolean optimized) {
        this.optimized = optimized;
        this.paramsMap = optimized ? new OptimizedCaseInsensitiveMapWrapper(new LinkedHashMap()) : new CaseInsensitiveMapWrapper(new LinkedHashMap());
        this.putAll(paramsMap);
    }

    @Override
    public CaseInsensitiveMultiMap toImmutableMultiMap() {
        if (this.isEmpty() && CaseInsensitiveMultiMap.emptyCaseInsensitiveMultiMap() != null) {
            return CaseInsensitiveMultiMap.emptyCaseInsensitiveMultiMap();
        }
        return new ImmutableCaseInsensitiveMultiMap(this);
    }

    @Override
    public DataType getDataType() {
        return dataType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CaseInsensitiveMultiMap)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CaseInsensitiveMultiMap that = (CaseInsensitiveMultiMap)o;
        return this.optimized == that.optimized;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.optimized);
    }

    private static class ImmutableCaseInsensitiveMultiMap
    extends CaseInsensitiveMultiMap {
        private static final long serialVersionUID = -1048913048598100657L;

        public ImmutableCaseInsensitiveMultiMap(CaseInsensitiveMultiMap caseInsensitiveMultiMap) {
            super(caseInsensitiveMultiMap.optimized);
            this.paramsMap = Collections.unmodifiableMap(caseInsensitiveMultiMap.paramsMap);
        }

        @Override
        public CaseInsensitiveMultiMap toImmutableMultiMap() {
            return this;
        }
    }
}

