/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.maven;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.util.IOUtils;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.PropertiesUtils;
import org.mule.runtime.core.internal.util.jar.JarLoadingUtils;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorCreateException;
import org.mule.runtime.module.deployment.impl.internal.util.JarUtils;

public class MavenUtils {
    public static URL getPomPropertiesUrlFromJar(File artifactFile) {
        return MavenUtils.lookMavenMetadataFileUrlFromJar(artifactFile, "pom.properties");
    }

    private static URL lookMavenMetadataFileUrlFromJar(File artifactFile, String mavenMetadataFileName) {
        URL uRL;
        block12: {
            String mavenMetadataFilePath = "META-INF/mule-artifact/" + mavenMetadataFileName;
            URL possibleUrl = JarUtils.getUrlWithinJar(artifactFile, mavenMetadataFilePath);
            InputStream ignored = IOUtils.getInputStreamWithCacheControl(possibleUrl);
            try {
                uRL = possibleUrl;
                if (ignored == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        List<URL> jarMavenUrls = JarUtils.getUrlsWithinJar(artifactFile, "META-INF/maven");
                        Optional<URL> mavenMetadataUrl = jarMavenUrls.stream().filter(url -> url.toString().endsWith(mavenMetadataFileName)).findAny();
                        if (!mavenMetadataUrl.isPresent()) {
                            throw new ArtifactDescriptorCreateException(String.format("The identifier '%s' requires the file '%s' within the artifact(error found while reading artifact '%s')", artifactFile.getName(), mavenMetadataFileName, artifactFile.getAbsolutePath()));
                        }
                        return mavenMetadataUrl.get();
                    }
                }
                catch (IOException e) {
                    throw new MuleRuntimeException(e);
                }
            }
            ignored.close();
        }
        return uRL;
    }

    public static Properties getPomPropertiesFolder(File artifactFolder) {
        Properties properties;
        File artifactPomProperties = MavenUtils.lookupPomPropertiesMavenLocation(artifactFolder);
        try (FileInputStream artifactPomPropertiesInputStream = new FileInputStream(artifactPomProperties);){
            properties = PropertiesUtils.loadProperties(artifactPomPropertiesInputStream);
        }
        catch (IOException e) {
            throw new ArtifactDescriptorCreateException(String.format("There was an issue reading '%s' for the artifact '%s'", artifactPomProperties.getName(), artifactFolder.getAbsolutePath()), e);
        }
        return properties;
    }

    public static Properties getPomPropertiesFromJar(File artifactFile) {
        String pomPropertiesFilePath = "META-INF/mule-artifact/pom.properties";
        try {
            return PropertiesUtils.loadProperties(new ByteArrayInputStream(JarLoadingUtils.loadFileContentFrom(MavenUtils.getPomPropertiesUrlFromJar(artifactFile)).get()));
        }
        catch (IOException e) {
            throw new ArtifactDescriptorCreateException(String.format("There was an issue reading '%s' for the artifact '%s'", pomPropertiesFilePath, artifactFile.getAbsolutePath()), e);
        }
    }

    public static File lookupPomFromMavenLocation(File artifactFolder) {
        File artifactPomFile = null;
        File lookupFolder = new File(artifactFolder, "META-INF" + File.separator + "maven");
        while (lookupFolder != null && lookupFolder.exists()) {
            File possiblePomLocation = new File(lookupFolder, "pom.xml");
            if (possiblePomLocation.exists()) {
                artifactPomFile = possiblePomLocation;
                break;
            }
            File[] directories = lookupFolder.listFiles((FileFilter)DirectoryFileFilter.DIRECTORY);
            Preconditions.checkState(directories != null || directories.length == 0, String.format("No directories under %s so pom.xml file for artifact in folder %s could not be found", lookupFolder.getAbsolutePath(), artifactFolder.getAbsolutePath()));
            Preconditions.checkState(directories.length == 1, String.format("More than one directory under %s so pom.xml file for artifact in folder %s could not be found", lookupFolder.getAbsolutePath(), artifactFolder.getAbsolutePath()));
            lookupFolder = directories[0];
        }
        if (artifactPomFile == null || !artifactPomFile.exists()) {
            throw new ArtifactDescriptorCreateException(String.format("The Maven bundle loader requires the file pom.xml (error found while reading artifact '%s')", artifactFolder.getName()));
        }
        return artifactPomFile;
    }

    public static File lookupPomPropertiesMavenLocation(File artifactFolder) {
        File mulePropertiesPom = null;
        File lookupFolder = new File(artifactFolder, "META-INF" + File.separator + "maven");
        while (lookupFolder != null && lookupFolder.exists()) {
            File possiblePomPropertiesLocation = new File(lookupFolder, "pom.properties");
            if (possiblePomPropertiesLocation.exists()) {
                mulePropertiesPom = possiblePomPropertiesLocation;
                break;
            }
            File[] directories = lookupFolder.listFiles((FileFilter)DirectoryFileFilter.DIRECTORY);
            Preconditions.checkState(directories != null || directories.length == 0, String.format("No directories under %s so pom.properties file for artifact in folder %s could not be found", lookupFolder.getAbsolutePath(), artifactFolder.getAbsolutePath()));
            Preconditions.checkState(directories.length == 1, String.format("More than one directory under %s so pom.properties file for artifact in folder %s could not be found", lookupFolder.getAbsolutePath(), artifactFolder.getAbsolutePath()));
            lookupFolder = directories[0];
        }
        if (mulePropertiesPom == null || !mulePropertiesPom.exists()) {
            throw new ArtifactDescriptorCreateException(String.format("The Maven bundle loader requires the file pom.properties (error found while reading artifact '%s')", artifactFolder.getName()));
        }
        return mulePropertiesPom;
    }
}

