/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.util.IdentifierParsingUtils;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.config.internal.validation.AbstractErrorValidation;

public abstract class AbstractErrorTypesValidation
extends AbstractErrorValidation {
    private static final String CORE_ERROR_NAMESPACE = "mule".toUpperCase(Locale.getDefault());
    private final Optional<FeatureFlaggingService> featureFlaggingService;
    private final boolean ignoreParamsWithProperties;

    public AbstractErrorTypesValidation(Optional<FeatureFlaggingService> featureFlaggingService, boolean ignoreParamsWithProperties) {
        this.featureFlaggingService = featureFlaggingService;
        this.ignoreParamsWithProperties = ignoreParamsWithProperties;
    }

    @Override
    public Validation.Level getLevel() {
        return this.featureFlaggingService.map(ffs -> ffs.isEnabled(MuleRuntimeFeature.ENFORCE_ERROR_TYPES_VALIDATION)).orElse(true) != false ? Validation.Level.ERROR : Validation.Level.WARN;
    }

    protected boolean isErrorTypePresent(ComponentAst component) {
        if (this.getErrorTypeParam(component) == null) {
            return false;
        }
        if (this.ignoreParamsWithProperties && (this.getErrorTypeParam(component).getRawValue() == null || this.getErrorTypeParam(component).getRawValue().contains("${"))) {
            return false;
        }
        return !StringUtils.isEmpty((CharSequence)this.getErrorTypeParam(component).getResolvedRawValue());
    }

    protected static Optional<ValidationResultItem> validateErrorTypeId(ComponentAst component, ComponentParameterAst parameter, ArtifactAst artifact, Validation validation, String errorTypeString, ComponentIdentifier errorTypeId) {
        Optional<ErrorType> errorType = artifact.getErrorTypeRepository().lookupErrorType(errorTypeId);
        if (!errorType.isPresent()) {
            if (CORE_ERROR_NAMESPACE.equals(errorTypeId.getNamespace())) {
                return Optional.of(ValidationResultItem.create(component, parameter, validation, String.format("There's no MULE error named '%s'.", errorTypeId.getName())));
            }
            return Optional.of(ValidationResultItem.create(component, parameter, validation, String.format("Could not find error '%s'.", errorTypeId.getName())));
        }
        return Optional.empty();
    }

    protected static Optional<ErrorType> lookup(ComponentAst component, ArtifactAst artifact) {
        return artifact.getErrorTypeRepository().lookupErrorType(AbstractErrorTypesValidation.parseErrorType(component.getParameter("Error Mappings", "type").getResolvedRawValue()));
    }

    protected static ComponentIdentifier parseErrorType(String stringRepresentation) {
        return IdentifierParsingUtils.parseErrorType(stringRepresentation, CORE_ERROR_NAMESPACE);
    }

    protected static boolean isAllowedBorrowedNamespace(String namespace) {
        return CORE_ERROR_NAMESPACE.equals(namespace);
    }

    protected static Set<String> getAlreadyUsedErrorNamespaces(ArtifactAst artifact) {
        return artifact.dependencies().stream().map(dependency -> dependency.getXmlDslModel().getPrefix().toUpperCase(Locale.getDefault())).collect(Collectors.toSet());
    }

    public boolean isIgnoreParamsWithProperties() {
        return this.ignoreParamsWithProperties;
    }
}

