/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.el;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.el.Binding;
import org.mule.runtime.api.el.ExpressionModule;
import org.mule.runtime.api.el.ModuleNamespace;
import org.mule.runtime.api.metadata.TypedValue;

class CompositeExpressionModule
implements ExpressionModule {
    private final List<ExpressionModule> expressionModules;
    private final Collection<Binding> bindings;
    private final Collection<String> identifiers;
    private final ModuleNamespace namespace;
    private final List<MetadataType> types;

    public CompositeExpressionModule(ExpressionModule ... modules) {
        this.expressionModules = Arrays.asList(modules);
        this.bindings = this.expressionModules.stream().flatMap(em -> em.bindings().stream()).collect(Collectors.toList());
        this.identifiers = this.expressionModules.stream().flatMap(em -> em.identifiers().stream()).collect(Collectors.toList());
        this.namespace = this.getAndCheckUniqueNamespace(this.expressionModules);
        this.types = this.expressionModules.stream().flatMap(em -> em.declaredTypes().stream()).collect(Collectors.toList());
    }

    @Override
    public Collection<Binding> bindings() {
        return this.bindings;
    }

    @Override
    public Collection<String> identifiers() {
        return this.identifiers;
    }

    @Override
    public ModuleNamespace namespace() {
        return this.namespace;
    }

    @Override
    public List<MetadataType> declaredTypes() {
        return this.types;
    }

    @Override
    public Optional<TypedValue> lookup(String identifier) {
        for (ExpressionModule expressionModule : this.expressionModules) {
            Optional<TypedValue> found = expressionModule.lookup(identifier);
            if (!found.isPresent()) continue;
            return found;
        }
        return Optional.empty();
    }

    private ModuleNamespace getAndCheckUniqueNamespace(List<ExpressionModule> modules) {
        Set namespacesSet = modules.stream().map(ExpressionModule::namespace).collect(Collectors.toSet());
        if (namespacesSet.size() != 1) {
            throw new IllegalArgumentException(String.format("Expected unique namespace but found multiple %s", namespacesSet));
        }
        return (ModuleNamespace)namespacesSet.iterator().next();
    }
}

