/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.client;

import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.runtime.http.api.tcp.TcpClientSocketProperties;

public class HttpClientConfiguration {
    private final TlsContextFactory tlsContextFactory;
    private final ProxyConfig proxyConfig;
    private final TcpClientSocketProperties clientSocketProperties;
    private final int maxConnections;
    private final boolean usePersistentConnections;
    private final int connectionIdleTimeout;
    private final boolean streaming;
    private final int responseBufferSize;
    private final String name;
    private final Boolean decompress;

    HttpClientConfiguration(TlsContextFactory tlsContextFactory, ProxyConfig proxyConfig, TcpClientSocketProperties clientSocketProperties, int maxConnections, Boolean decompress, boolean usePersistentConnections, int connectionIdleTimeout, boolean streaming, int responseBufferSize, String name) {
        this.tlsContextFactory = tlsContextFactory;
        this.proxyConfig = proxyConfig;
        this.clientSocketProperties = clientSocketProperties;
        this.maxConnections = maxConnections;
        this.usePersistentConnections = usePersistentConnections;
        this.connectionIdleTimeout = connectionIdleTimeout;
        this.streaming = streaming;
        this.responseBufferSize = responseBufferSize;
        this.name = name;
        this.decompress = decompress;
    }

    public TlsContextFactory getTlsContextFactory() {
        return this.tlsContextFactory;
    }

    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    public TcpClientSocketProperties getClientSocketProperties() {
        return this.clientSocketProperties;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public boolean isUsePersistentConnections() {
        return this.usePersistentConnections;
    }

    public int getConnectionIdleTimeout() {
        return this.connectionIdleTimeout;
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public int getResponseBufferSize() {
        return this.responseBufferSize;
    }

    public String getName() {
        return this.name;
    }

    public Boolean isDecompress() {
        return this.decompress;
    }

    public static class Builder {
        private TlsContextFactory tlsContextFactory;
        private ProxyConfig proxyConfig;
        private TcpClientSocketProperties clientSocketProperties;
        private int maxConnections = -1;
        private boolean usePersistentConnections = true;
        private int connectionIdleTimeout = 30000;
        private boolean streaming = false;
        private int responseBufferSize = -1;
        private String name;
        private Boolean decompress;

        public Builder setTlsContextFactory(TlsContextFactory tlsContextFactory) {
            this.tlsContextFactory = tlsContextFactory;
            return this;
        }

        public Builder setProxyConfig(ProxyConfig proxyConfig) {
            this.proxyConfig = proxyConfig;
            return this;
        }

        public Builder setClientSocketProperties(TcpClientSocketProperties clientSocketProperties) {
            this.clientSocketProperties = clientSocketProperties;
            return this;
        }

        public Builder setMaxConnections(int maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public Builder setUsePersistentConnections(boolean usePersistentConnections) {
            this.usePersistentConnections = usePersistentConnections;
            return this;
        }

        public Builder setConnectionIdleTimeout(int connectionIdleTimeout) {
            this.connectionIdleTimeout = connectionIdleTimeout;
            return this;
        }

        public Builder setStreaming(boolean streaming) {
            this.streaming = streaming;
            return this;
        }

        public Builder setResponseBufferSize(int responseBufferSize) {
            this.responseBufferSize = responseBufferSize;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setDecompress(Boolean decompress) {
            this.decompress = decompress;
            return this;
        }

        public HttpClientConfiguration build() {
            Preconditions.checkNotNull(this.name, "Name is mandatory.");
            return new HttpClientConfiguration(this.tlsContextFactory, this.proxyConfig, this.clientSocketProperties, this.maxConnections, this.decompress, this.usePersistentConnections, this.connectionIdleTimeout, this.streaming, this.responseBufferSize, this.name);
        }
    }
}

