/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.model;

import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.HasDisplayModel;
import org.mule.runtime.extension.api.model.AbstractImmutableModel;

public abstract class AbstractNamedImmutableModel
extends AbstractImmutableModel
implements NamedObject,
HasDisplayModel {
    private final String name;
    private final DisplayModel displayModel;

    protected AbstractNamedImmutableModel(String name, String description, DisplayModel displayModel, Set<ModelProperty> modelProperties) {
        super(description, modelProperties);
        AbstractNamedImmutableModel.checkArgument(name != null && name.length() > 0, "Name attribute cannot be null or blank");
        this.name = name;
        this.displayModel = displayModel;
    }

    protected static void checkArgument(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public Optional<DisplayModel> getDisplayModel() {
        return Optional.ofNullable(this.displayModel);
    }

    public boolean equals(Object obj) {
        return this.getClass().isInstance(obj) && this.name.equals(((NamedObject)obj).getName());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public String toString() {
        return "AbstractNamedImmutableModel{name='" + this.name + '\'' + ", displayModel=" + this.displayModel + "} " + super.toString();
    }
}

