/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.object;

import java.io.Closeable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.runtime.api.streaming.HasSize;
import org.mule.runtime.core.internal.streaming.AbstractStreamingBuffer;
import org.mule.runtime.core.internal.streaming.object.Bucket;
import org.mule.runtime.core.internal.streaming.object.ObjectStreamBuffer;
import org.mule.runtime.core.internal.streaming.object.Position;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractObjectStreamBuffer<T>
extends AbstractStreamingBuffer
implements ObjectStreamBuffer<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractObjectStreamBuffer.class);
    private final Iterator<T> stream;
    private final Supplier<Integer> sizeResolver;
    private Bucket<T> currentBucket = new Bucket(0, 100);
    private Position currentPosition;
    private Position maxPosition = null;
    private int instancesCount = 0;

    public AbstractObjectStreamBuffer(Iterator<T> stream) {
        this.stream = stream;
        this.sizeResolver = stream instanceof HasSize ? () -> ((HasSize)((Object)stream)).getSize() : () -> -1;
    }

    @Override
    public final void initialise() {
        this.currentPosition = new Position(0, -1);
        int size = this.getSize();
        if (size > 0) {
            this.setMaxPosition(this.toPosition(size - 1));
        }
        this.initialize(Optional.ofNullable(this.maxPosition), this.currentBucket);
    }

    protected abstract void initialize(Optional<Position> var1, Bucket<T> var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bucket<T> getBucketFor(Position position) {
        this.checkNotClosed();
        if (this.maxPosition != null && this.maxPosition.compareTo(position) < 0) {
            throw new NoSuchElementException();
        }
        this.readLock.lock();
        try {
            Bucket<T> bucket = this.getPresentBucket(position);
            if (bucket != null) {
                Bucket<T> bucket2 = this.forwarding(bucket);
                return bucket2;
            }
            this.readLock.unlock();
            this.writeLock.lock();
            try {
                Bucket<T> bucket3 = this.fetch(position);
                this.readLock.lock();
                this.writeLock.unlock();
                return bucket3;
            }
            catch (Throwable throwable) {
                this.readLock.lock();
                this.writeLock.unlock();
                throw throwable;
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public int getSize() {
        return this.sizeResolver.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean hasNext(long i) {
        if (this.closed.get()) {
            return false;
        }
        Position position = this.toPosition(i);
        this.readLock.lock();
        try {
            boolean bl;
            if (this.maxPosition != null) {
                boolean bl2 = position.compareTo(this.maxPosition) < 1;
                return bl2;
            }
            if (position.compareTo(this.currentPosition) < 1) {
                boolean bl3 = true;
                return bl3;
            }
            this.readLock.unlock();
            this.writeLock.lock();
            try {
                bl = this.fetch(position) != null;
            }
            catch (NoSuchElementException e) {
                try {
                    boolean bl4 = false;
                    this.readLock.lock();
                    this.writeLock.unlock();
                    this.readLock.unlock();
                    return bl4;
                }
                catch (Throwable throwable) {
                    this.readLock.lock();
                    this.writeLock.unlock();
                    throw throwable;
                }
            }
            this.readLock.lock();
            this.writeLock.unlock();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private Bucket<T> fetch(Position position) {
        Bucket<T> presentBucket = this.getPresentBucket(position);
        if (presentBucket != null && presentBucket.contains(position)) {
            return presentBucket;
        }
        while (this.currentPosition.compareTo(position) < 0) {
            if (!this.stream.hasNext()) {
                this.maxPosition = this.currentPosition;
                return null;
            }
            T item = this.stream.next();
            if (this.currentBucket.add(item)) {
                this.currentPosition = this.currentPosition.advanceItem();
            } else {
                this.setCurrentBucket(this.onBucketOverflow(this.currentBucket));
                this.currentBucket.add(item);
                this.currentPosition = this.currentPosition.advanceBucket();
            }
            ++this.instancesCount;
            this.validateMaxBufferSizeNotExceeded(this.instancesCount);
        }
        return this.currentBucket;
    }

    protected abstract void validateMaxBufferSizeNotExceeded(int var1);

    protected abstract Bucket<T> onBucketOverflow(Bucket<T> var1);

    @Override
    public final void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.writeLock.lock();
            try {
                this.doClose();
            }
            finally {
                if (this.stream instanceof Closeable) {
                    try {
                        ((Closeable)((Object)this.stream)).close();
                    }
                    catch (Exception e) {
                        LOGGER.debug("Found exception trying to close Object stream", (Throwable)e);
                    }
                }
                this.setCurrentBucket(null);
                this.writeLock.unlock();
            }
        }
    }

    protected abstract void doClose();

    protected abstract Bucket<T> getPresentBucket(Position var1);

    private Bucket<T> forwarding(Bucket<T> presentBucket) {
        if (presentBucket != null) {
            return new ForwardingBucket<T>(presentBucket);
        }
        return null;
    }

    protected Bucket<T> getCurrentBucket() {
        return this.currentBucket;
    }

    protected void setCurrentBucket(Bucket<T> bucket) {
        this.currentBucket = bucket;
    }

    protected void setMaxPosition(Position maxPosition) {
        this.maxPosition = maxPosition;
    }

    private class ForwardingBucket<T>
    extends Bucket<T> {
        private Bucket<T> delegate;

        private ForwardingBucket(Bucket<T> delegate) {
            super(delegate.getIndex(), 0);
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Optional<T> get(int index) {
            AbstractObjectStreamBuffer.this.readLock.lock();
            try {
                Optional<T> item = this.delegate.get(index);
                if (item.isPresent()) {
                    Optional<T> optional = item;
                    return optional;
                }
                Position position = new Position(this.delegate.getIndex(), index);
                AbstractObjectStreamBuffer.this.readLock.unlock();
                AbstractObjectStreamBuffer.this.writeLock.lock();
                try {
                    this.delegate = AbstractObjectStreamBuffer.this.fetch(position);
                }
                finally {
                    AbstractObjectStreamBuffer.this.readLock.lock();
                    AbstractObjectStreamBuffer.this.writeLock.unlock();
                }
                if (this.delegate == null) {
                    throw new NoSuchElementException();
                }
                Optional<T> optional = this.delegate.get(index);
                return optional;
            }
            finally {
                AbstractObjectStreamBuffer.this.readLock.unlock();
            }
        }

        @Override
        public boolean contains(Position position) {
            return this.delegate.contains(position);
        }

        @Override
        public int getIndex() {
            return this.delegate.getIndex();
        }
    }
}

