/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.property;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.property.ResolverInformation;

public class TypeResolversInformationModelProperty
implements ModelProperty {
    public static final String NAME = "typeResolversInformation";
    private final String category;
    private final ResolverInformation outputResolver;
    private final ResolverInformation attributesResolver;
    private final ResolverInformation keysResolver;
    private final boolean partialTypeKeyResolver;
    private final Map<String, ResolverInformation> inputResolvers;
    private final transient boolean requiresConnection;
    private final transient boolean requiresConfiguration;

    public TypeResolversInformationModelProperty(String category, Map<String, String> parameters, String outputResolver, String attributesResolver, String keysResolver, boolean requiresConnection, boolean requiresConfiguration) {
        this(category, parameters, outputResolver, attributesResolver, keysResolver, requiresConnection, requiresConfiguration, false);
    }

    public TypeResolversInformationModelProperty(String category, Map<String, String> parameters, String outputResolver, String attributesResolver, String keysResolver, boolean requiresConnection, boolean requiresConfiguration, boolean partialTypeKeyResolver) {
        this.requiresConnection = requiresConnection;
        this.requiresConfiguration = requiresConfiguration;
        Preconditions.checkArgument(StringUtils.isNotBlank((CharSequence)category), "A Category name is required for a group of resolvers");
        this.category = category;
        Map<String, String> paramResolvers = parameters != null && parameters.isEmpty() ? null : parameters;
        this.outputResolver = this.getResolverInformation(outputResolver);
        this.attributesResolver = this.getResolverInformation(attributesResolver);
        this.keysResolver = this.getResolverInformation(keysResolver);
        if (paramResolvers != null) {
            this.inputResolvers = new HashMap<String, ResolverInformation>();
            paramResolvers.forEach((paramName, resolverName) -> this.inputResolvers.put((String)paramName, this.getResolverInformation((String)resolverName)));
        } else {
            this.inputResolvers = null;
        }
        this.partialTypeKeyResolver = partialTypeKeyResolver;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isPublic() {
        return true;
    }

    public String getCategoryName() {
        return this.category;
    }

    public Optional<ResolverInformation> getOutputResolver() {
        return Optional.ofNullable(this.outputResolver);
    }

    public Optional<ResolverInformation> getAttributesResolver() {
        return Optional.ofNullable(this.attributesResolver);
    }

    public Optional<ResolverInformation> getKeysResolver() {
        return Optional.ofNullable(this.keysResolver);
    }

    public boolean isPartialTypeKeyResolver() {
        return this.partialTypeKeyResolver;
    }

    public Optional<ResolverInformation> getParameterResolver(String parameterName) {
        return this.inputResolvers != null ? Optional.ofNullable(this.inputResolvers.get(parameterName)) : Optional.empty();
    }

    private String sanitizeResolverName(String resolverName) {
        return StringUtils.isAllBlank((CharSequence[])new CharSequence[]{resolverName}) || "NullResolver".equals(resolverName) ? null : resolverName;
    }

    private ResolverInformation getResolverInformation(String resolverName) {
        ResolverInformation resolverInformation = null;
        String sanatizedName = this.sanitizeResolverName(resolverName);
        if (sanatizedName != null) {
            resolverInformation = new ResolverInformation(sanatizedName, this.requiresConnection, this.requiresConfiguration);
        }
        return resolverInformation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeResolversInformationModelProperty that = (TypeResolversInformationModelProperty)o;
        return Objects.equals(this.category, that.category) && Objects.equals(this.inputResolvers, that.inputResolvers) && Objects.equals(this.outputResolver, that.outputResolver) && Objects.equals(this.keysResolver, that.keysResolver) && Objects.equals(this.attributesResolver, that.attributesResolver) && Objects.equals(this.partialTypeKeyResolver, that.partialTypeKeyResolver);
    }

    public int hashCode() {
        return Objects.hash(this.category, this.inputResolvers, this.outputResolver, this.keysResolver, this.attributesResolver, this.partialTypeKeyResolver);
    }

    public String toString() {
        return "TypeResolversInformation{category='" + this.category + '\'' + ", parameters=" + this.inputResolvers + ", outputResolver='" + this.outputResolver + '\'' + ", keysResolver='" + this.keysResolver + '\'' + ", attributesResolver='" + this.attributesResolver + '\'' + ", partialTypeKeyResolver='" + this.partialTypeKeyResolver + '\'' + '}';
    }
}

