/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.context.notification;

import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.notification.ConnectorMessageNotification;
import org.mule.runtime.api.notification.EnrichedNotificationInfo;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.core.api.context.notification.ServerNotificationHandler;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.context.notification.OptimisedNotificationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NotificationHelper {
    private static final Logger logger = LoggerFactory.getLogger(NotificationHelper.class);
    private final Class<? extends Notification> notificationClass;
    private final boolean dynamicNotifications;
    private final ServerNotificationHandler defaultNotificationHandler;
    private final boolean disableOptimisedNotificationHandlerDynamicResolutionUpdateBasedOnDelegate;

    public NotificationHelper(ServerNotificationHandler defaultNotificationHandler, Class<? extends Notification> notificationClass, boolean dynamicNotifications) {
        this(defaultNotificationHandler, notificationClass, dynamicNotifications, false);
    }

    public NotificationHelper(ServerNotificationHandler defaultNotificationHandler, Class<? extends Notification> notificationClass, boolean dynamicNotifications, boolean disableOptimisedNotificationHandlerDynamicResolutionUpdateBasedOnDelegate) {
        this.notificationClass = notificationClass;
        this.dynamicNotifications = dynamicNotifications;
        this.defaultNotificationHandler = this.adaptNotificationHandler(defaultNotificationHandler);
        this.disableOptimisedNotificationHandlerDynamicResolutionUpdateBasedOnDelegate = disableOptimisedNotificationHandlerDynamicResolutionUpdateBasedOnDelegate;
    }

    public boolean isNotificationEnabled() {
        return this.defaultNotificationHandler.isNotificationEnabled(this.notificationClass);
    }

    public void fireNotification(Component source, CoreEvent event, ComponentLocation location, int action) {
        try {
            if (this.defaultNotificationHandler.isNotificationEnabled(this.notificationClass)) {
                this.defaultNotificationHandler.fireNotification(new ConnectorMessageNotification(EnrichedNotificationInfo.createInfo(event, null, source), location, action));
            }
        }
        catch (Exception e) {
            logger.warn("Could not fire notification. Action: " + action, (Throwable)e);
        }
    }

    public void fireNotification(Notification notification) {
        this.defaultNotificationHandler.fireNotification(notification);
    }

    private ServerNotificationHandler adaptNotificationHandler(ServerNotificationHandler serverNotificationHandler) {
        return this.dynamicNotifications ? serverNotificationHandler : new OptimisedNotificationHandler(serverNotificationHandler, this.notificationClass, this.disableOptimisedNotificationHandlerDynamicResolutionUpdateBasedOnDelegate);
    }
}

