/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.xa;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.mule.runtime.core.api.transaction.xa.ResourceManagerException;
import org.mule.runtime.core.internal.util.journal.queue.XaTxQueueTransactionJournal;
import org.mule.runtime.core.internal.util.queue.PersistentXaTransactionContext;
import org.mule.runtime.core.internal.util.queue.QueueProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XaTransactionRecoverer {
    protected transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final XaTxQueueTransactionJournal xaTxQueueTransactionJournal;
    private final QueueProvider queueProvider;

    public XaTransactionRecoverer(XaTxQueueTransactionJournal xaTxQueueTransactionJournal, QueueProvider queueProvider) {
        this.xaTxQueueTransactionJournal = xaTxQueueTransactionJournal;
        this.queueProvider = queueProvider;
    }

    public XaTxQueueTransactionJournal getXaTxQueueTransactionJournal() {
        return this.xaTxQueueTransactionJournal;
    }

    public synchronized Xid[] recover(int flag) throws XAException {
        if (flag == 0x800000) {
            return new Xid[0];
        }
        Multimap xidXaJournalEntryMultimap = this.xaTxQueueTransactionJournal.getAllLogEntries();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Executing XA recover");
            this.logger.debug("Found " + xidXaJournalEntryMultimap.size() + " in the tx log");
        }
        ArrayList<Xid> txsToRecover = new ArrayList<Xid>();
        for (Xid xid : xidXaJournalEntryMultimap.keySet()) {
            Collection entries = xidXaJournalEntryMultimap.get((Object)xid);
            if (entries.stream().anyMatch(logEntry -> logEntry.isCommit() || logEntry.isRollback())) continue;
            txsToRecover.add(xid);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("found " + txsToRecover.size() + " txs to recover");
        }
        return txsToRecover.toArray(new Xid[txsToRecover.size()]);
    }

    public void rollbackDandlingTransaction(Xid xid) throws XAException {
        try {
            this.logger.info("Rollbacking dangling tx with id " + String.valueOf(xid));
            new PersistentXaTransactionContext(this.xaTxQueueTransactionJournal, this.queueProvider, xid).doRollback();
        }
        catch (ResourceManagerException e) {
            this.logger.warn(e.getMessage());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Error rollbacking dangling transaction", (Throwable)e);
            }
            throw new XAException(-4);
        }
    }

    public void commitDandlingTransaction(Xid xid, boolean onePhase) throws XAException {
        try {
            this.logger.info("Commiting dangling tx with id " + String.valueOf(xid));
            new PersistentXaTransactionContext(this.xaTxQueueTransactionJournal, this.queueProvider, xid).doCommit();
        }
        catch (ResourceManagerException e) {
            this.logger.warn(e.getMessage());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Error committing dangling transaction", (Throwable)e);
            }
            throw new XAException(-4);
        }
    }
}

