/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.config.dsl.config;

import java.util.Optional;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.dsl.api.component.ObjectFactory;
import org.mule.runtime.extension.api.property.ClassLoaderModelProperty;
import org.mule.runtime.extension.api.runtime.ExpirationPolicy;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.module.extension.api.runtime.config.ConfigurationProviderFactory;
import org.mule.runtime.module.extension.api.runtime.resolver.ConnectionProviderValueResolver;
import org.mule.runtime.module.extension.api.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.config.dsl.AbstractExtensionObjectFactory;
import org.mule.runtime.module.extension.internal.runtime.exception.RequiredParameterNotSetException;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConnectionProviderResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ImplicitConnectionProviderValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticConnectionProviderResolver;

public class ConfigurationProviderObjectFactory
extends AbstractExtensionObjectFactory<ConfigurationProvider>
implements ObjectFactory<ConfigurationProvider> {
    private final ExtensionModel extensionModel;
    private final ConfigurationModel configurationModel;
    @Inject
    private ConfigurationProviderFactory configurationProviderFactory;
    private ExpirationPolicy expirationPolicy;
    private Optional<ConnectionProviderValueResolver> connectionProviderResolver = Optional.empty();
    private ConfigurationProvider instance;
    private boolean requiresConnection = false;
    private final LazyValue<String> configName = new LazyValue<Supplier<String>>(this::getName);

    public ConfigurationProviderObjectFactory(ExtensionModel extensionModel, ConfigurationModel configurationModel, MuleContext muleContext) {
        super(muleContext);
        this.extensionModel = extensionModel;
        this.configurationModel = configurationModel;
    }

    @Override
    public ConfigurationProvider doGetObject() throws Exception {
        if (this.instance == null) {
            this.instance = this.createInnerInstance();
        }
        return this.instance;
    }

    private ConfigurationProvider createInnerInstance() throws ConfigurationException {
        if (this.expirationPolicy == null) {
            this.expirationPolicy = this.muleContext.getConfiguration().getDynamicConfigExpiration().getExpirationPolicy();
        }
        return ClassUtils.withContextClassLoader(this.getExtensionClassLoader(), () -> {
            ConfigurationProvider configurationProvider;
            ResolverSet resolverSet = this.getParametersResolver().getParametersAsResolverSet(this.configurationModel, this.muleContext);
            ConnectionProviderValueResolver connectionProviderResolver = this.getConnectionProviderResolver();
            connectionProviderResolver.getResolverSet().ifPresent(resolver -> LifecycleUtils.initialiseIfNeeded(resolver, true, this.muleContext));
            try {
                configurationProvider = resolverSet.isDynamic() || connectionProviderResolver.isDynamic() ? this.configurationProviderFactory.createDynamicConfigurationProvider(this.configName.get(), this.extensionModel, this.configurationModel, resolverSet, connectionProviderResolver, this.expirationPolicy) : this.configurationProviderFactory.createStaticConfigurationProvider(this.configName.get(), this.extensionModel, this.configurationModel, resolverSet, connectionProviderResolver);
            }
            catch (Exception e) {
                throw new ConfigurationException(I18nMessageFactory.createStaticMessage(String.format("Could not create an implicit configuration '%s' for the extension '%s': %s", this.configurationModel.getName(), this.extensionModel.getName(), e.getMessage())), (Throwable)e);
            }
            return configurationProvider;
        });
    }

    private ClassLoader getExtensionClassLoader() {
        return this.extensionModel.getModelProperty(ClassLoaderModelProperty.class).map(ClassLoaderModelProperty::getClassLoader).orElse(Thread.currentThread().getContextClassLoader());
    }

    private ConnectionProviderValueResolver getConnectionProviderResolver() {
        return this.connectionProviderResolver.orElseGet(() -> {
            if (!this.requiresConnection) {
                return new StaticConnectionProviderResolver(null, null);
            }
            return new ImplicitConnectionProviderValueResolver(this.getName(), this.extensionModel, this.configurationModel, this.reflectionCache, this.expressionManager, this.muleContext);
        });
    }

    private String getName() {
        return this.configurationModel.getAllParameterModels().stream().filter(ParameterModel::isComponentId).findAny().map(p -> (ValueResolver)this.parameters.get(p.getName())).map(vr -> {
            try {
                return (String)vr.resolve(null);
            }
            catch (MuleException e) {
                throw new IllegalStateException("Error obtaining configuration name", e);
            }
        }).orElseThrow(() -> new RequiredParameterNotSetException("cannot create a configuration without a name"));
    }

    public void setExpirationPolicy(ExpirationPolicy expirationPolicy) {
        this.expirationPolicy = expirationPolicy;
    }

    public void setConnectionProviderResolver(ConnectionProviderResolver connectionProviderResolver) {
        this.connectionProviderResolver = Optional.ofNullable(connectionProviderResolver);
    }

    public void setRequiresConnection(boolean requiresConnection) {
        this.requiresConnection = requiresConnection;
    }
}

