/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.data.sample;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.function.Supplier;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.module.extension.api.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.internal.loader.java.property.InjectableParameterInfo;
import org.mule.runtime.module.extension.internal.loader.java.property.SampleDataProviderFactoryModelProperty;
import org.mule.runtime.module.extension.internal.util.InjectableParameterResolver;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.sdk.api.data.sample.SampleDataException;
import org.mule.sdk.api.data.sample.SampleDataProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampleDataProviderFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SampleDataProviderFactory.class);
    private final SampleDataProviderFactoryModelProperty factoryModelProperty;
    private final ParameterValueResolver parameterValueResolver;
    private final Supplier<Object> connectionSupplier;
    private final Supplier<Object> configurationSupplier;
    private final Field connectionField;
    private final Field configField;
    private final ReflectionCache reflectionCache;
    private final MuleContext muleContext;
    private final ExpressionManager expressionManager;
    private final ParameterizedModel parameterizedModel;

    public SampleDataProviderFactory(SampleDataProviderFactoryModelProperty factoryModelProperty, ParameterValueResolver parameterValueResolver, Supplier<Object> connectionSupplier, Supplier<Object> configurationSupplier, Field connectionField, Field configField, ReflectionCache reflectionCache, MuleContext muleContext, ParameterizedModel parameterizedModel) {
        this.factoryModelProperty = factoryModelProperty;
        this.parameterValueResolver = parameterValueResolver;
        this.connectionSupplier = connectionSupplier;
        this.configurationSupplier = configurationSupplier;
        this.connectionField = connectionField;
        this.configField = configField;
        this.reflectionCache = reflectionCache;
        this.muleContext = muleContext;
        this.expressionManager = muleContext.getExpressionManager();
        this.parameterizedModel = parameterizedModel;
    }

    <T, A> SampleDataProvider<T, A> createSampleDataProvider() throws SampleDataException {
        Class providerClass = this.factoryModelProperty.getSampleDataProviderClass();
        try {
            SampleDataProvider resolver = ClassUtils.instantiateClass(providerClass, new Object[0]);
            LifecycleUtils.initialiseIfNeeded(resolver, true, this.muleContext);
            InjectableParameterResolver injectableParameterResolver = new InjectableParameterResolver(this.parameterizedModel, this.parameterValueResolver, this.expressionManager, this.factoryModelProperty.getInjectableParameters());
            this.injectProviderFields(resolver, injectableParameterResolver);
            if (this.factoryModelProperty.usesConnection()) {
                Object connection;
                try {
                    connection = this.connectionSupplier.get();
                }
                catch (Exception e) {
                    throw new SampleDataException("Failed to establish connection: " + e.getMessage(), "CONNECTION_FAILURE", (Throwable)e);
                }
                if (connection == null) {
                    throw new SampleDataException("The sample data provider requires a connection and none was provided", "MISSING_REQUIRED_PARAMETERS");
                }
                IntrospectionUtils.setValueIntoField(resolver, this.connectionSupplier.get(), this.connectionField);
            }
            if (this.factoryModelProperty.usesConfig()) {
                Object config = this.configurationSupplier.get();
                if (config == null) {
                    throw new SampleDataException("The sample data provider requires a configuration and none was provided", "MISSING_REQUIRED_PARAMETERS");
                }
                IntrospectionUtils.setValueIntoField(resolver, this.configurationSupplier.get(), this.configField);
            }
            return resolver;
        }
        catch (SampleDataException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SampleDataException("An error occurred trying to create a SampleDataProvider", "UNKNOWN", (Throwable)e);
        }
    }

    private void injectProviderFields(SampleDataProvider resolver, InjectableParameterResolver resolvedParameters) throws SampleDataException {
        ArrayList<String> missingParameters = new ArrayList<String>();
        for (InjectableParameterInfo injectableParam : this.factoryModelProperty.getInjectableParameters()) {
            String parameterName = injectableParam.getParameterName();
            Object parameterValue = resolvedParameters.getInjectableParameterValue(injectableParam.getParameterName());
            if (parameterValue != null) {
                IntrospectionUtils.setValueIntoField(resolver, parameterValue, parameterName, this.reflectionCache);
                continue;
            }
            if (!injectableParam.isRequired()) continue;
            missingParameters.add(parameterName);
        }
        if (!missingParameters.isEmpty()) {
            throw new SampleDataException("Unable to retrieve Sample Data. There are missing required parameters for the resolution: " + String.valueOf(missingParameters), "MISSING_REQUIRED_PARAMETERS");
        }
    }
}

