/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.grammar;

import java.util.List;
import java.util.Stack;
import org.mule.runtime.extension.api.dsql.EntityType;
import org.mule.runtime.extension.api.dsql.Expression;
import org.mule.runtime.extension.api.dsql.Field;
import org.mule.runtime.extension.api.dsql.QueryBuilder;
import org.mule.runtime.extension.api.dsql.Value;
import org.mule.runtime.extension.internal.dsql.DefaultQueryBuilder;
import org.mule.runtime.extension.internal.expression.And;
import org.mule.runtime.extension.internal.expression.FieldComparison;
import org.mule.runtime.extension.internal.expression.Not;
import org.mule.runtime.extension.internal.expression.Or;
import org.mule.runtime.extension.internal.grammar.AndDsqlNode;
import org.mule.runtime.extension.internal.grammar.BaseDsqlNode;
import org.mule.runtime.extension.internal.grammar.DirectionDsqlNode;
import org.mule.runtime.extension.internal.grammar.DsqlGrammarVisitor;
import org.mule.runtime.extension.internal.grammar.DsqlNode;
import org.mule.runtime.extension.internal.grammar.ExpressionDsqlNode;
import org.mule.runtime.extension.internal.grammar.FromDsqlNode;
import org.mule.runtime.extension.internal.grammar.LimitDsqlNode;
import org.mule.runtime.extension.internal.grammar.NotDsqlNode;
import org.mule.runtime.extension.internal.grammar.OffsetDsqlNode;
import org.mule.runtime.extension.internal.grammar.OpeningParenthesesDsqlNode;
import org.mule.runtime.extension.internal.grammar.OperatorDsqlNode;
import org.mule.runtime.extension.internal.grammar.OrDsqlNode;
import org.mule.runtime.extension.internal.grammar.OrderByDsqlNode;
import org.mule.runtime.extension.internal.grammar.QueryModelDirectionFactory;
import org.mule.runtime.extension.internal.grammar.QueryModelOperatorFactory;
import org.mule.runtime.extension.internal.grammar.SelectDsqlNode;
import org.mule.runtime.extension.internal.operator.BinaryOperator;
import org.mule.runtime.extension.internal.value.BooleanValue;
import org.mule.runtime.extension.internal.value.DateTimeValue;
import org.mule.runtime.extension.internal.value.DateValue;
import org.mule.runtime.extension.internal.value.IdentifierValue;
import org.mule.runtime.extension.internal.value.IntegerValue;
import org.mule.runtime.extension.internal.value.MuleExpressionValue;
import org.mule.runtime.extension.internal.value.NullValue;
import org.mule.runtime.extension.internal.value.NumberValue;
import org.mule.runtime.extension.internal.value.StringValue;
import org.mule.runtime.extension.internal.value.UnknownValue;

public class DefaultDsqlGrammarVisitor
implements DsqlGrammarVisitor {
    private final QueryBuilder queryBuilder;
    private final Stack<Expression> expressions = new Stack();
    private int expressionLevel = 0;

    public DefaultDsqlGrammarVisitor() {
        this.queryBuilder = DefaultQueryBuilder.getInstance();
    }

    @Override
    public void visit(BaseDsqlNode baseDsqlNode) {
    }

    @Override
    public void visit(SelectDsqlNode selectDsqlNode) {
        List<DsqlNode> children = selectDsqlNode.getChildren();
        for (DsqlNode dsqlNode : children) {
            if (dsqlNode.getType() != 27 && dsqlNode.getType() != 50 && dsqlNode.getType() != 6) {
                dsqlNode.accept(this);
                continue;
            }
            String nodeText = dsqlNode.getText();
            if (dsqlNode.getType() == 50) {
                nodeText = (String)StringValue.fromLiteral(nodeText).getValue();
            }
            this.queryBuilder.addField(new Field(nodeText, "string"));
        }
    }

    @Override
    public void visit(FromDsqlNode fromDsqlNode) {
        List<DsqlNode> children = fromDsqlNode.getChildren();
        for (DsqlNode dsqlNode : children) {
            String text = this.getTextIfStringLiteral(dsqlNode);
            this.queryBuilder.setType(new EntityType(text));
        }
    }

    private String getTextIfStringLiteral(DsqlNode dsqlNode) {
        String text = dsqlNode.getText();
        if (dsqlNode.getType() == 50) {
            return (String)StringValue.fromLiteral(text).getValue();
        }
        return text;
    }

    @Override
    public void visit(ExpressionDsqlNode expressionDsqlNode) {
        List<DsqlNode> children = expressionDsqlNode.getChildren();
        for (DsqlNode dsqlNode : children) {
            int type = dsqlNode.getType();
            if (type == 4 || type == 43 || type == 37) {
                dsqlNode.accept(this);
                continue;
            }
            if (type == 42 || type == 13) {
                List<DsqlNode> operatorChildren = dsqlNode.getChildren();
                DsqlNode fieldNode = operatorChildren.get(0);
                String fieldName = this.getTextIfStringLiteral(fieldNode);
                Field field = new Field(fieldName);
                DsqlNode valueNode = operatorChildren.get(1);
                Value value = this.buildValue(valueNode);
                FieldComparison expression = new FieldComparison(this.getOperatorFor(dsqlNode.getText()), field, value);
                this.queryBuilder.setFilterExpression(expression);
                continue;
            }
            if (type != 41) continue;
            dsqlNode.accept(this);
        }
    }

    private Value buildValue(DsqlNode node) {
        Value value;
        switch (node.getType()) {
            case 18: {
                value = NumberValue.fromLiteral(node.getText());
                break;
            }
            case 28: {
                value = IntegerValue.fromLiteral(node.getText());
                break;
            }
            case 8: {
                value = BooleanValue.fromLiteral(node.getText());
                break;
            }
            case 15: {
                value = DateValue.fromLiteral(node.getText());
                break;
            }
            case 16: {
                value = DateTimeValue.fromLiteral(node.getText());
                break;
            }
            case 38: {
                value = new NullValue();
                break;
            }
            case 27: {
                value = IdentifierValue.fromLiteral(node.getText());
                break;
            }
            case 34: {
                value = MuleExpressionValue.fromLiteral(node.getText());
                break;
            }
            case 50: {
                value = StringValue.fromLiteral(node.getText());
                break;
            }
            default: {
                value = UnknownValue.fromLiteral(node.getText());
            }
        }
        return value;
    }

    @Override
    public void visit(AndDsqlNode andDsqlNode) {
        List<DsqlNode> children = andDsqlNode.getChildren();
        ++this.expressionLevel;
        for (DsqlNode dsqlNode : children) {
            dsqlNode.accept(this);
        }
        --this.expressionLevel;
        Expression rightExpression = this.expressions.pop();
        Expression leftExpression = this.expressions.pop();
        And andExpression = new And(leftExpression, rightExpression);
        this.putExpression(andExpression);
    }

    private void putExpression(Expression expression) {
        if (this.expressionLevel == 0) {
            this.queryBuilder.setFilterExpression(expression);
        } else {
            this.expressions.push(expression);
        }
    }

    @Override
    public void visit(OrDsqlNode orDsqlNode) {
        List<DsqlNode> children = orDsqlNode.getChildren();
        ++this.expressionLevel;
        for (DsqlNode dsqlNode : children) {
            dsqlNode.accept(this);
        }
        --this.expressionLevel;
        Expression rightExpression = this.expressions.pop();
        Expression leftExpression = this.expressions.pop();
        this.putExpression(new Or(leftExpression, rightExpression));
    }

    @Override
    public void visit(NotDsqlNode notDsqlNode) {
        List<DsqlNode> children = notDsqlNode.getChildren();
        ++this.expressionLevel;
        for (DsqlNode dsqlNode : children) {
            dsqlNode.accept(this);
        }
        --this.expressionLevel;
        Expression expression = this.expressions.pop();
        this.putExpression(new Not(expression));
    }

    @Override
    public void visit(OperatorDsqlNode operatorDsqlNode) {
        List<DsqlNode> children = operatorDsqlNode.getChildren();
        DsqlNode fieldNode = children.get(0);
        Field field = new Field(this.getTextIfStringLiteral(fieldNode));
        DsqlNode dsqlNode = children.get(1);
        Value value = this.buildValue(dsqlNode);
        this.putExpression(new FieldComparison(this.getOperatorFor(operatorDsqlNode.getText()), field, value));
    }

    @Override
    public void visit(OpeningParenthesesDsqlNode openingParenthesesDsqlNode) {
        openingParenthesesDsqlNode.getChildren().forEach(node -> node.accept(this));
    }

    private BinaryOperator getOperatorFor(String symbol) {
        return (BinaryOperator)QueryModelOperatorFactory.getInstance().getOperator(symbol);
    }

    @Override
    public void visit(OrderByDsqlNode orderByDsqlNode) {
        List<DsqlNode> children = orderByDsqlNode.getChildren();
        for (DsqlNode dsqlNode : children) {
            String text = this.getTextIfStringLiteral(dsqlNode);
            if (!(dsqlNode instanceof DirectionDsqlNode)) {
                this.queryBuilder.addOrderByField(new Field(text));
                continue;
            }
            this.queryBuilder.setDirection(QueryModelDirectionFactory.getInstance().getDirection(text.toLowerCase()));
        }
    }

    @Override
    public void visit(LimitDsqlNode limitDsqlNode) {
        limitDsqlNode.getChildren().forEach(node -> this.queryBuilder.setLimit(Integer.parseInt(node.getText())));
    }

    @Override
    public void visit(OffsetDsqlNode offsetDsqlNode) {
        offsetDsqlNode.getChildren().forEach(node -> this.queryBuilder.setOffset(Integer.parseInt(node.getText())));
    }

    public QueryBuilder getQueryBuilder() {
        return this.queryBuilder;
    }
}

