/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.enricher;

import java.lang.reflect.Type;
import java.util.Optional;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.runtime.api.meta.model.ImportedTypeModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.IdempotentDeclarationEnricherWalkDelegate;
import org.mule.runtime.extension.api.loader.WalkingDeclarationEnricher;
import org.mule.runtime.extension.api.property.NoRedeliveryPolicyModelProperty;
import org.mule.runtime.extension.internal.loader.util.InfrastructureParameterBuilder;

public final class RedeliveryPolicyDeclarationEnricher
implements WalkingDeclarationEnricher {
    @Override
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.WIRING;
    }

    @Override
    public Optional<WalkingDeclarationEnricher.DeclarationEnricherWalkDelegate> getWalkDelegate(final ExtensionLoadingContext extensionLoadingContext) {
        return Optional.of(new IdempotentDeclarationEnricherWalkDelegate(){
            ExtensionDeclaration extension;
            boolean hasObjectStoreParams;
            {
                this.extension = (ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration();
                this.hasObjectStoreParams = false;
            }

            @Override
            protected void onSource(SourceDeclaration declaration) {
                if (declaration.getModelProperty(NoRedeliveryPolicyModelProperty.class).isPresent()) {
                    return;
                }
                InfrastructureParameterBuilder.addRedeliveryPolicy(declaration);
                this.hasObjectStoreParams = true;
            }

            @Override
            public void onWalkFinished() {
                if (this.hasObjectStoreParams && !RedeliveryPolicyDeclarationEnricher.this.isObjectStoreAlreadyImported(this.extension)) {
                    this.extension.getImportedTypes().add(new ImportedTypeModel((ObjectType)extensionLoadingContext.getTypeLoader().load((Type)((Object)ObjectStore.class))));
                }
            }
        });
    }

    private boolean isObjectStoreAlreadyImported(ExtensionDeclaration extension) {
        return extension.getImportedTypes().stream().anyMatch(model -> this.isObjectStore(model.getImportedType()));
    }

    private boolean isObjectStore(MetadataType type) {
        return MetadataTypeUtils.getTypeId(type).filter(typeId -> ObjectStore.class.getName().equals(typeId)).isPresent();
    }
}

