/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.extension.provider;

import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ConstructDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OptionalParameterDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclarer;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.display.PathModel;
import org.mule.runtime.core.api.extension.provider.MuleExtensionModelProvider;
import org.mule.runtime.core.internal.extension.CustomBuildingDefinitionProviderModelProperty;
import org.mule.runtime.extension.api.ExtensionConstants;
import org.mule.sdk.api.stereotype.MuleStereotypes;

class TlsExtensionModelDeclarer {
    TlsExtensionModelDeclarer() {
    }

    ExtensionDeclarer createExtensionModel() {
        ExtensionDeclarer declarer = new ExtensionDeclarer().named("tls").describedAs("Mule Runtime and Integration Platform: TLS components").onVersion(MuleExtensionModelProvider.MULE_VERSION).fromVendor("MuleSoft, Inc.").supportingJavaVersions(ExtensionConstants.ALL_SUPPORTED_JAVA_VERSIONS).withCategory(Category.COMMUNITY).withModelProperty(new CustomBuildingDefinitionProviderModelProperty()).withXmlDsl(XmlDslModel.builder().setPrefix("tls").setNamespace(MuleExtensionModelProvider.MULE_TLS_NAMESPACE).setSchemaVersion(MuleExtensionModelProvider.MULE_VERSION).setXsdFileName("mule-tls.xsd").setSchemaLocation("http://www.mulesoft.org/schema/mule/tls/current/mule-tls.xsd").build());
        this.declareExportedTypes(declarer);
        ConstructDeclarer context = (ConstructDeclarer)((ConstructDeclarer)declarer.withConstruct("context").describedAs("Reusable configuration element for TLS. A TLS context optionally defines a key store and a trust store.\nThe key store contains the private and public keys of this server/client. The trust store contains\ncertificates of the trusted servers/clients.")).allowingTopLevelDefinition().withStereotype(MuleStereotypes.CONFIG);
        ParameterGroupDeclarer contextParams = context.onDefaultParameterGroup();
        this.stringParam(contextParams, "name", "Reusable configuration element for TLS. A TLS context optionally defines a key store and a trust store.\nThe key store contains the private and public keys of this server/client.\nThe trust store contains certificates of the trusted servers/clients.").asComponentId();
        this.optionalStringParam(contextParams, "enabledProtocols", "A comma separated list of protocols enabled for this context.");
        this.optionalStringParam(contextParams, "enabledCipherSuites", "A comma separated list of cipher suites enabled for this context.");
        this.declareTrustStore(context);
        this.declareKeyStore(context);
        this.declareRevocationCheck(context);
        return declarer;
    }

    private void declareExportedTypes(ExtensionDeclarer extensionDeclarer) {
        ((ExtensionDeclaration)extensionDeclarer.getDeclaration()).addType((ObjectType)MuleExtensionModelProvider.TLS_CONTEXT_FACTORY_TYPE);
    }

    private void declareRevocationCheck(ConstructDeclarer context) {
        ParameterizedDeclarer rc = context.withOptionalComponent("revocationCheck").describedAs("Enable certificate revocation checking.");
        ParameterGroupDeclarer params = rc.onParameterGroup("standardRevocationCheck").withDslInlineRepresentation(true);
        this.booleanParam(params, "onlyEndEntities", "Only check the revocation status of end-entity certificates.");
        this.booleanParam(params, "preferCrls", "Prefer CRLs to OCSP. The default behavior is to prefer OCSP.");
        this.booleanParam(params, "noFallback", "Disable the fallback mechanism (the alternative algorithm, for instance if CRLs are selected it would be OCSP)");
        this.booleanParam(params, "softFail", "Allow revocation check to succeed if the revocation status cannot be determined because of network or server errors. This is a possible security risk.");
        params = rc.onParameterGroup("crlFile").withDslInlineRepresentation(true);
        this.configurePathParameter(this.optionalStringParam(params, "path", "The path to a CRL (Certificate Revocation List) file to be used for this trust store. A certificate mentioned there will not be accepted for authentication."));
        params = rc.onParameterGroup("customOcspResponder").withDslInlineRepresentation(true);
        this.optionalStringParam(params, "url", "URL that identifies the location of the OCSP responder. This is used instead of the corresponding field in the certificate extension.");
        this.optionalStringParam(params, "certAlias", "Alias of the certificate that signs the OCSP response, instead of the corresponding CA. Must be present in the trust store.");
    }

    private void declareKeyStore(ConstructDeclarer context) {
        ParameterGroupDeclarer keyStore = context.onParameterGroup("keyStore").withDslInlineRepresentation(true);
        this.declarePathParameter(keyStore, "key store");
        this.declareStoreTypeParameter(keyStore);
        this.optionalStringParam(keyStore, "alias", "When the key store contains many private keys, this attribute indicates the alias of the key that should be used. If not defined, the first key in the file will be used by default.");
        this.optionalStringParam(keyStore, "keyPassword", "The password used to protect the private key.").withLayout(LayoutModel.builder().asPassword().build());
        this.optionalStringParam(keyStore, "password", "The password used to protect the key store.").withLayout(LayoutModel.builder().asPassword().build());
        this.optionalStringParam(keyStore, "algorithm", "The algorithm used by the key store.");
    }

    private void declareTrustStore(ConstructDeclarer context) {
        ParameterGroupDeclarer trustStore = context.onParameterGroup("trustStore").withDslInlineRepresentation(true);
        this.declarePathParameter(trustStore, "trust store");
        this.optionalStringParam(trustStore, "password", "The password used to protect the trust store.").withLayout(LayoutModel.builder().asPassword().build());
        this.declareStoreTypeParameter(trustStore);
        this.optionalStringParam(trustStore, "algorithm", "The algorithm used by the trust store.");
        this.booleanParam(trustStore, "insecure", "If true, no certificate validations will be performed.");
    }

    private void declareStoreTypeParameter(ParameterGroupDeclarer trustStore) {
        this.optionalStringParam(trustStore, "type", "The type of store used.").withDisplayModel(DisplayModel.builder().example("jks, jceks, pkcs12 or other store type").build());
    }

    private void declarePathParameter(ParameterGroupDeclarer declarer, String resourceDescription) {
        this.configurePathParameter(this.optionalStringParam(declarer, "path", "The location (which will be resolved relative to the current classpath and file system, if possible) of the " + resourceDescription));
    }

    private void configurePathParameter(ParameterDeclarer declarer) {
        declarer.withDisplayModel(DisplayModel.builder().path(new PathModel(PathModel.Type.FILE, false, PathModel.Location.EMBEDDED, new String[0])).build());
    }

    private ParameterDeclarer stringParam(ParameterGroupDeclarer declarer, String name, String description) {
        return ((ParameterDeclarer)((ParameterDeclarer)declarer.withRequiredParameter(name).describedAs(description)).ofType(MuleExtensionModelProvider.STRING_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
    }

    private OptionalParameterDeclarer booleanParam(ParameterGroupDeclarer declarer, String name, String description) {
        return this.optionalParam(declarer, name, description, MuleExtensionModelProvider.BOOLEAN_TYPE).defaultingTo(false);
    }

    private OptionalParameterDeclarer optionalStringParam(ParameterGroupDeclarer declarer, String name, String description) {
        return this.optionalParam(declarer, name, description, MuleExtensionModelProvider.STRING_TYPE);
    }

    private OptionalParameterDeclarer optionalParam(ParameterGroupDeclarer declarer, String name, String description, MetadataType type) {
        return (OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)declarer.withOptionalParameter(name).describedAs(description)).ofType(type)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
    }
}

