/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.streaming;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.retry.policy.NoRetryPolicyTemplate;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.streaming.iterator.Producer;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.core.api.util.func.CheckedSupplier;
import org.mule.runtime.core.internal.util.FunctionalUtils;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.config.MutableConfigurationStats;
import org.mule.runtime.module.extension.internal.runtime.connectivity.ExtensionConnectionSupplier;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ExtensionsOAuthUtils;
import org.mule.runtime.module.extension.internal.runtime.streaming.PagingProviderWrapper;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.util.ReconnectionUtils;
import org.mule.runtime.tracer.api.component.ComponentTracer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PagingProviderProducer<T>
implements Producer<List<T>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PagingProviderProducer.class);
    public static final String COULD_NOT_OBTAIN_A_CONNECTION = "Could not obtain a connection for the configuration";
    public static final String COULD_NOT_CREATE_A_CONNECTION_SUPPLIER = "Could not obtain a connection supplier for the configuration";
    public static final String COULD_NOT_EXECUTE = "Could not execute operation with connection";
    private final ComponentTracer<CoreEvent> operationConnectionTracer;
    private PagingProvider<Object, T> delegate;
    private final ConfigurationInstance config;
    private final ExtensionConnectionSupplier extensionConnectionSupplier;
    private final ExecutionContextAdapter executionContext;
    private final ConnectionSupplierFactory connectionSupplierFactory;
    private final RetryPolicyTemplate retryPolicy;
    private final boolean supportsOAuth;
    private boolean isFirstPage = true;
    private AtomicBoolean alreadyClosed = new AtomicBoolean(false);
    private final MutableConfigurationStats mutableStats;

    public PagingProviderProducer(PagingProvider<Object, T> delegate, ConfigurationInstance config, ExecutionContextAdapter executionContext, ExtensionConnectionSupplier extensionConnectionSupplier, ComponentTracer<CoreEvent> operationConnectionTracer) {
        this(delegate, config, executionContext, extensionConnectionSupplier, false, operationConnectionTracer);
    }

    public PagingProviderProducer(PagingProvider<Object, T> delegate, ConfigurationInstance config, ExecutionContextAdapter executionContext, ExtensionConnectionSupplier extensionConnectionSupplier, boolean supportsOAuth, ComponentTracer<CoreEvent> operationConnectionTracer) {
        this.delegate = new PagingProviderWrapper<Object, T>(delegate, executionContext.getExtensionModel());
        this.config = config;
        this.executionContext = executionContext;
        this.extensionConnectionSupplier = extensionConnectionSupplier;
        this.supportsOAuth = supportsOAuth;
        this.retryPolicy = (RetryPolicyTemplate)executionContext.getRetryPolicyTemplate().orElseGet(NoRetryPolicyTemplate::new);
        this.connectionSupplierFactory = this.createConnectionSupplierFactory();
        this.mutableStats = MuleExtensionUtils.getMutableConfigurationStats(executionContext);
        this.operationConnectionTracer = operationConnectionTracer;
    }

    @Override
    public List<T> produce() {
        List page = this.performWithConnection(this.delegate::getPage);
        this.isFirstPage = false;
        return page;
    }

    @Override
    public int getSize() {
        return this.performWithConnection(connection -> this.delegate.getTotalResults(connection)).orElse(-1);
    }

    private <R> R performWithConnection(Function<Object, R> function) {
        if (this.retryPolicy.isEnabled()) {
            CompletableFuture future = this.retryPolicy.applyPolicy(() -> CompletableFuture.completedFuture(this.withConnection(function)), e -> !this.isFirstPage && !this.delegate.useStickyConnections() && ReconnectionUtils.shouldRetry(e, this.executionContext), ReconnectionUtils.NULL_THROWABLE_CONSUMER, ReconnectionUtils.NULL_THROWABLE_CONSUMER, Function.identity(), this.executionContext.getCurrentScheduler());
            try {
                return (R)future.get();
            }
            catch (ExecutionException e2) {
                if (e2.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e2.getCause();
                }
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(COULD_NOT_EXECUTE), e2.getCause());
            }
            catch (InterruptedException e3) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(COULD_NOT_EXECUTE), (Throwable)e3);
            }
        }
        return this.withConnection(function);
    }

    private int getMaxOAuthRefreshAttempts() {
        return this.supportsOAuth ? 2 : 0;
    }

    private <R> R withConnection(Function<Object, R> function) {
        return this.withConnection(function, this.getMaxOAuthRefreshAttempts());
    }

    private <R> R withConnection(Function<Object, R> function, int maxOAuthRefreshAttempts) {
        ConnectionSupplier connectionSupplier = this.getConnectionSupplier();
        Object connection = this.getConnection(connectionSupplier);
        try {
            R r = function.apply(connection);
            return r;
        }
        catch (Exception caughtException) {
            if (this.isFirstPage) {
                FunctionalUtils.safely(() -> this.delegate.close(connection), e -> LOGGER.error("Found exception closing paging provider", (Throwable)e));
            } else if (maxOAuthRefreshAttempts > 0) {
                boolean tokenRefreshed;
                try {
                    tokenRefreshed = ExtensionsOAuthUtils.refreshTokenIfNecessary(this.executionContext, (Throwable)caughtException);
                }
                catch (Exception e2) {
                    throw new MuleRuntimeException(e2);
                }
                if (tokenRefreshed) {
                    R r = this.withConnection(function, --maxOAuthRefreshAttempts);
                    return r;
                }
            }
            this.handleException(caughtException, connectionSupplier);
            throw caughtException;
        }
        finally {
            FunctionalUtils.safely(connectionSupplier::close, e -> LOGGER.error("Found exception closing the connection supplier", (Throwable)e));
        }
    }

    private void handleException(Exception exception, ConnectionSupplier connectionSupplier) {
        ConnectionException connectionException = ExceptionUtils.extractConnectionException(exception).orElse(null);
        if (connectionException != null) {
            if (ReconnectionUtils.isPartOfActiveTransaction(this.config)) {
                connectionException.addInfo("MULE_IS_TRANSACTIONAL", true);
            }
            connectionException.addInfo("MULE_COMPONENT_CONFIG_NAME", this.config.getName());
            connectionSupplier.invalidateConnection();
        }
    }

    @Override
    public void close() {
        ConnectionSupplier connectionSupplier = null;
        try {
            connectionSupplier = this.connectionSupplierFactory.getConnectionSupplier();
            this.delegate.close(connectionSupplier.getConnection());
        }
        catch (Exception e2) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(COULD_NOT_OBTAIN_A_CONNECTION), (Throwable)e2);
        }
        finally {
            if (connectionSupplier != null) {
                FunctionalUtils.safely(connectionSupplier::close, e -> LOGGER.debug("Found exception closing the connection supplier", (Throwable)e));
            }
            if (this.mutableStats != null && this.alreadyClosed.compareAndSet(false, true)) {
                this.mutableStats.discountActiveComponent();
            }
            this.connectionSupplierFactory.dispose();
        }
    }

    private ConnectionSupplierFactory createConnectionSupplierFactory() {
        if (this.delegate.useStickyConnections()) {
            return new StickyConnectionSupplierFactory();
        }
        return new DefaultConnectionSupplierFactory();
    }

    private ConnectionSupplier getConnectionSupplier() {
        try {
            return this.connectionSupplierFactory.getConnectionSupplier();
        }
        catch (MuleException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(COULD_NOT_CREATE_A_CONNECTION_SUPPLIER), (Throwable)e);
        }
    }

    private Object getConnection(ConnectionSupplier connectionSupplier) {
        try {
            return connectionSupplier.getConnection();
        }
        catch (MuleException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(COULD_NOT_OBTAIN_A_CONNECTION), (Throwable)e);
        }
    }

    private static interface ConnectionSupplierFactory {
        public ConnectionSupplier getConnectionSupplier() throws MuleException;

        public void dispose();
    }

    private static interface ConnectionSupplier {
        public Object getConnection() throws MuleException;

        public void close();

        public void invalidateConnection();
    }

    private class StickyConnectionSupplierFactory
    implements ConnectionSupplierFactory {
        private ConnectionHandler connectionHandler;
        private final LazyValue<ConnectionSupplier> stickyConnection = new LazyValue<1>(new CheckedSupplier<ConnectionSupplier>(){

            @Override
            public ConnectionSupplier getChecked() throws Throwable {
                StickyConnectionSupplierFactory.this.connectionHandler = PagingProviderProducer.this.extensionConnectionSupplier.getConnection(PagingProviderProducer.this.executionContext, PagingProviderProducer.this.operationConnectionTracer);
                return new StickyConnectionSupplier(StickyConnectionSupplierFactory.this.connectionHandler);
            }
        });

        private StickyConnectionSupplierFactory() {
        }

        @Override
        public ConnectionSupplier getConnectionSupplier() throws MuleException {
            return this.stickyConnection.get();
        }

        @Override
        public void dispose() {
            if (this.connectionHandler != null) {
                this.connectionHandler.release();
            }
        }
    }

    private class DefaultConnectionSupplierFactory
    implements ConnectionSupplierFactory {
        private DefaultConnectionSupplierFactory() {
        }

        @Override
        public ConnectionSupplier getConnectionSupplier() throws MuleException {
            return new DefaultConnectionSupplier(PagingProviderProducer.this.extensionConnectionSupplier.getConnection(PagingProviderProducer.this.executionContext, PagingProviderProducer.this.operationConnectionTracer));
        }

        @Override
        public void dispose() {
        }
    }

    private class StickyConnectionSupplier
    implements ConnectionSupplier {
        private final Object connection;
        private final ConnectionHandler connectionHandler;

        public StickyConnectionSupplier(ConnectionHandler connectionHandler) throws ConnectionException {
            this.connectionHandler = connectionHandler;
            this.connection = connectionHandler.getConnection();
        }

        @Override
        public Object getConnection() throws MuleException {
            return this.connection;
        }

        @Override
        public void close() {
        }

        @Override
        public void invalidateConnection() {
            this.connectionHandler.invalidate();
        }
    }

    private class DefaultConnectionSupplier
    implements ConnectionSupplier {
        private final ConnectionHandler connectionHandler;

        public DefaultConnectionSupplier(ConnectionHandler connectionHandler) {
            this.connectionHandler = connectionHandler;
        }

        @Override
        public Object getConnection() throws MuleException {
            return this.connectionHandler.getConnection();
        }

        @Override
        public void close() {
            this.connectionHandler.release();
        }

        @Override
        public void invalidateConnection() {
            this.connectionHandler.invalidate();
        }
    }
}

