/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.api.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.ast.internal.stream.ComponentAstSpliteratorStrategy;

public enum AstTraversalDirection {
    TOP_DOWN(true){

        @Override
        public Spliterator<ComponentAst> recursiveSpliterator(ComponentAst component) {
            return new ComponentAstSpliteratorStrategy(component, this){

                @Override
                protected boolean tryAdvanceBeforeChildrenConsumed(Consumer<? super ComponentAst> action) {
                    return this.tryAdvanceOverComponentAst(action);
                }

                @Override
                protected boolean tryAdvanceAfterChildrenConsumed(Consumer<? super ComponentAst> action) {
                    return false;
                }
            };
        }
    }
    ,
    BOTTOM_UP(false){

        @Override
        public Spliterator<ComponentAst> recursiveSpliterator(ComponentAst component) {
            return new ComponentAstSpliteratorStrategy(component, this){

                @Override
                protected boolean tryAdvanceBeforeChildrenConsumed(Consumer<? super ComponentAst> action) {
                    return false;
                }

                @Override
                protected boolean tryAdvanceAfterChildrenConsumed(Consumer<? super ComponentAst> action) {
                    return this.tryAdvanceOverComponentAst(action);
                }
            };
        }
    };

    private final boolean shouldEnhanceComponentBeforeChildren;

    private AstTraversalDirection(boolean shouldEnhanceComponentBeforeChildren) {
        this.shouldEnhanceComponentBeforeChildren = shouldEnhanceComponentBeforeChildren;
    }

    public abstract Spliterator<ComponentAst> recursiveSpliterator(ComponentAst var1);

    public Stream<Pair<ComponentAst, List<ComponentAst>>> recursiveStreamWithHierarchy(Stream<ComponentAst> components) {
        return this.recursiveStreamWithHierarchy(components, Collections.emptyList());
    }

    public Stream<Pair<ComponentAst, List<ComponentAst>>> recursiveStreamWithHierarchy(Stream<ComponentAst> components, boolean ignoreParameterComplexValues) {
        return this.recursiveStreamWithHierarchy(components, Collections.emptyList(), ignoreParameterComplexValues);
    }

    public Stream<Pair<ComponentAst, List<ComponentAst>>> recursiveStreamWithHierarchy(Stream<ComponentAst> components, List<ComponentAst> commonAncestors) {
        return this.recursiveStreamWithHierarchy(components, commonAncestors, false);
    }

    public Stream<Pair<ComponentAst, List<ComponentAst>>> recursiveStreamWithHierarchy(Stream<ComponentAst> components, List<ComponentAst> commonAncestors, boolean ignoreParameterComplexValues) {
        ArrayList enhancedComponents = new ArrayList();
        components.forEach(comp -> {
            if (this.shouldEnhanceComponentBeforeChildren) {
                enhancedComponents.add(new Pair((ComponentAst)comp, new ArrayList(commonAncestors)));
            }
            ArrayList<ComponentAst> currentContext = new ArrayList<ComponentAst>(commonAncestors);
            currentContext.add((ComponentAst)comp);
            this.recursiveStreamWithHierarchy(enhancedComponents, (ComponentAst)comp, (List<ComponentAst>)currentContext, ignoreParameterComplexValues);
            if (!this.shouldEnhanceComponentBeforeChildren) {
                enhancedComponents.add(new Pair((ComponentAst)comp, new ArrayList(commonAncestors)));
            }
        });
        return enhancedComponents.stream();
    }

    private void recursiveStreamWithHierarchy(List<Pair<ComponentAst, List<ComponentAst>>> enhancedComponents, ComponentAst component, List<ComponentAst> currentContext, boolean ignoreParameterComplexValues) {
        Consumer<ComponentAst> action = componentInner -> {
            if (this.shouldEnhanceComponentBeforeChildren) {
                enhancedComponents.add(new Pair((ComponentAst)componentInner, new ArrayList(currentContext)));
            }
            ArrayList<ComponentAst> currentContextInner = new ArrayList<ComponentAst>(currentContext);
            currentContextInner.add((ComponentAst)componentInner);
            this.recursiveStreamWithHierarchy(enhancedComponents, (ComponentAst)componentInner, (List<ComponentAst>)currentContextInner, ignoreParameterComplexValues);
            if (!this.shouldEnhanceComponentBeforeChildren) {
                enhancedComponents.add(new Pair((ComponentAst)componentInner, new ArrayList(currentContext)));
            }
        };
        component.directChildrenStream().forEach(action);
        if (!ignoreParameterComplexValues && component.getModel(ParameterizedModel.class).isPresent()) {
            component.getParameters().forEach(param -> MuleAstUtils.doOnParamComponents(param, action));
        }
    }
}

