/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.context;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Optional;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.config.internal.context.service.InjectParamsFromContextServiceMethodInvoker;
import org.mule.runtime.config.internal.context.service.InjectParamsFromContextServiceProxy;
import org.mule.runtime.config.internal.factories.ConstantFactoryBean;
import org.mule.runtime.core.internal.config.CustomService;
import org.mule.runtime.core.internal.config.InternalCustomizationService;
import org.mule.runtime.module.service.internal.manager.LazyServiceProxy;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;

abstract class AbstractSpringMuleContextServiceConfigurator {
    private final InternalCustomizationService customizationService;
    private final BeanDefinitionRegistry beanDefinitionRegistry;
    private final Registry serviceLocator;

    protected AbstractSpringMuleContextServiceConfigurator(InternalCustomizationService customizationService, BeanDefinitionRegistry beanDefinitionRegistry, Registry serviceLocator) {
        this.customizationService = customizationService;
        this.beanDefinitionRegistry = beanDefinitionRegistry;
        this.serviceLocator = serviceLocator;
    }

    protected static BeanDefinition getBeanDefinition(Class<?> beanType) {
        return AbstractSpringMuleContextServiceConfigurator.getBeanDefinitionBuilder(beanType).getBeanDefinition();
    }

    protected void registerConstantBeanDefinition(String serviceId, Object impl) {
        this.registerBeanDefinition(serviceId, AbstractSpringMuleContextServiceConfigurator.getConstantObjectBeanDefinition(impl));
    }

    protected void registerBeanDefinition(String serviceId, BeanDefinition beanDefinition) {
        beanDefinition = this.customizationService.getOverriddenService(serviceId).map(customService -> this.getCustomServiceBeanDefinition((CustomService)customService, serviceId)).orElse(beanDefinition);
        this.beanDefinitionRegistry.registerBeanDefinition(serviceId, beanDefinition);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isServiceRuntimeProvided(CustomService<?> customService) {
        if (customService.getServiceImpl().map(impl -> impl instanceof Service).orElse(false) != false) return true;
        if (customService.getServiceClass().map(Service.class::isAssignableFrom).orElse(false) == false) return false;
        return true;
    }

    protected BeanDefinition getCustomServiceBeanDefinition(CustomService customService, String serviceId) {
        AbstractBeanDefinition beanDefinition;
        Optional customServiceClass = customService.getServiceClass();
        Optional customServiceImpl = customService.getServiceImpl();
        if (customServiceClass.isPresent()) {
            beanDefinition = AbstractSpringMuleContextServiceConfigurator.getBeanDefinitionBuilder(customServiceClass.get()).getBeanDefinition();
        } else if (customServiceImpl.isPresent()) {
            Object servImpl = customServiceImpl.get();
            if (servImpl instanceof Service) {
                if (Proxy.isProxyClass(servImpl.getClass())) {
                    InvocationHandler handler = Proxy.getInvocationHandler(servImpl);
                    if (handler instanceof LazyServiceProxy) {
                        servImpl = ((LazyServiceProxy)handler).forApplication(new InjectParamsFromContextServiceMethodInvoker(this.serviceLocator));
                    }
                    beanDefinition = AbstractSpringMuleContextServiceConfigurator.getConstantObjectBeanDefinition(servImpl);
                } else {
                    beanDefinition = AbstractSpringMuleContextServiceConfigurator.getConstantObjectBeanDefinition(InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)servImpl, this.serviceLocator));
                }
            } else {
                beanDefinition = AbstractSpringMuleContextServiceConfigurator.getConstantObjectBeanDefinition(servImpl);
            }
        } else {
            throw new IllegalStateException("A custom service must define a service class or instance");
        }
        if ("_muleObjectStoreManager".equals(serviceId)) {
            beanDefinition.setPrimary(true);
        }
        return beanDefinition;
    }

    protected static BeanDefinition getConstantObjectBeanDefinition(Object impl) {
        return AbstractSpringMuleContextServiceConfigurator.getBeanDefinitionBuilder(ConstantFactoryBean.class).addConstructorArgValue(impl).getBeanDefinition();
    }

    protected static BeanDefinitionBuilder getBeanDefinitionBuilder(Class<?> beanType) {
        return BeanDefinitionBuilder.genericBeanDefinition(beanType);
    }

    protected boolean containsBeanDefinition(String beanName) {
        return this.beanDefinitionRegistry.containsBeanDefinition(beanName);
    }

    protected InternalCustomizationService getCustomizationService() {
        return this.customizationService;
    }

    protected BeanDefinitionRegistry getBeanDefinitionRegistry() {
        return this.beanDefinitionRegistry;
    }

    protected Registry getServiceLocator() {
        return this.serviceLocator;
    }
}

