/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;

public class ExpressionParametersNotUsingMel
implements Validation {
    @Override
    public String getName() {
        return "Expression has 'mel:' prefix";
    }

    @Override
    public String getDescription() {
        return "Expression has 'mel:' prefix";
    }

    @Override
    public Predicate<List<ComponentAst>> applicable() {
        return ComponentAstPredicatesFactory.currentElemement(c -> c.getModel(ParameterizedModel.class).map(pmzd -> pmzd.getParameterGroupModels().stream().anyMatch(pmg -> pmg.getParameterModels().stream().anyMatch(pm -> {
            ComponentParameterAst param = c.getParameter(pmg.getName(), pm.getName());
            return param != null && param.getValue().isLeft();
        }))).orElse(false));
    }

    @Override
    public List<ValidationResultItem> validateMany(ComponentAst component, ArtifactAst artifact) {
        return component.getModel(ParameterizedModel.class).map(pmz -> ExtensionModelUtils.getGroupAndParametersPairs(pmz).map(gnp -> component.getParameter(((ParameterGroupModel)gnp.getFirst()).getName(), ((ParameterModel)gnp.getSecond()).getName())).filter(param -> param != null && param.getValue().isLeft()).flatMap(param -> this.validateNoMelExpression(component, (ComponentParameterAst)param, param.getValue().getLeft()).map(Stream::of).orElseGet(Stream::empty)).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    protected final Optional<ValidationResultItem> validateNoMelExpression(ComponentAst component, ComponentParameterAst param, String expression) {
        if (expression.startsWith("mel:")) {
            return Optional.of(ValidationResultItem.create(component, param, (Validation)this, "MEL expressions are no longer supported."));
        }
        return Optional.empty();
    }

    @Override
    public Validation.Level getLevel() {
        return Validation.Level.ERROR;
    }
}

