/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.object;

import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.streaming.object.CursorIterator;
import org.mule.runtime.api.streaming.object.CursorIteratorProvider;
import org.mule.runtime.core.internal.streaming.ClosingCursorException;
import org.mule.runtime.core.internal.streaming.CursorProviderAlreadyClosedException;

public abstract class AbstractCursorIteratorProvider
implements CursorIteratorProvider {
    protected final Iterator stream;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final ComponentLocation originatingLocation;
    private Exception closerResponsible;
    private final boolean trackCursorProviderClose;

    public AbstractCursorIteratorProvider(Iterator<?> stream, ComponentLocation originatingLocation, boolean trackCursorProviderClose) {
        this.stream = stream;
        this.originatingLocation = originatingLocation;
        this.trackCursorProviderClose = trackCursorProviderClose;
    }

    @Deprecated
    public AbstractCursorIteratorProvider(Iterator<?> stream) {
        this(stream, null, false);
    }

    @Override
    public final CursorIterator openCursor() {
        if (this.closed.get()) {
            throw new CursorProviderAlreadyClosedException("Cannot open a new cursor on a closed iterator", this.getOriginatingLocation(), Optional.ofNullable(this.closerResponsible));
        }
        return this.doOpenCursor();
    }

    @Override
    public void close() {
        this.closed.set(true);
        if (this.trackCursorProviderClose) {
            this.closerResponsible = new ClosingCursorException("Responsible for closing the stream.");
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    protected abstract CursorIterator doOpenCursor();

    @Override
    public Optional<ComponentLocation> getOriginatingLocation() {
        return Optional.ofNullable(this.originatingLocation);
    }
}

