/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.application;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.connectivity.ConnectivityTestingService;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.memory.management.MemoryManagementService;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.api.metadata.MetadataService;
import org.mule.runtime.api.notification.IntegerAction;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.notification.NotificationListenerRegistry;
import org.mule.runtime.api.service.ServiceRepository;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.api.value.ValueProviderService;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.context.notification.MuleContextListener;
import org.mule.runtime.core.api.context.notification.MuleContextNotification;
import org.mule.runtime.core.api.context.notification.MuleContextNotificationListener;
import org.mule.runtime.core.api.data.sample.SampleDataService;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.util.splash.SplashScreen;
import org.mule.runtime.deployment.model.api.DeploymentInitException;
import org.mule.runtime.deployment.model.api.DeploymentStartException;
import org.mule.runtime.deployment.model.api.InstallException;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.application.ApplicationStatus;
import org.mule.runtime.deployment.model.api.artifact.ArtifactConfigurationProcessor;
import org.mule.runtime.deployment.model.api.artifact.ArtifactContext;
import org.mule.runtime.deployment.model.api.domain.Domain;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPlugin;
import org.mule.runtime.module.artifact.activation.api.extension.discovery.ExtensionModelLoaderRepository;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderRepository;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.RegionClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.DomainDescriptor;
import org.mule.runtime.module.deployment.impl.internal.application.ApplicationPolicyProvider;
import org.mule.runtime.module.deployment.impl.internal.application.ApplicationStartedSplashScreen;
import org.mule.runtime.module.deployment.impl.internal.application.ApplicationStatusMapper;
import org.mule.runtime.module.deployment.impl.internal.artifact.AbstractDeployableArtifact;
import org.mule.runtime.module.deployment.impl.internal.artifact.ArtifactContextBuilder;
import org.mule.runtime.module.deployment.impl.internal.domain.AmbiguousDomainReferenceException;
import org.mule.runtime.module.deployment.impl.internal.domain.DefaultDomainManager;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainNotFoundException;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainRepository;
import org.mule.runtime.module.deployment.impl.internal.domain.IncompatibleDomainException;
import org.mule.runtime.module.deployment.impl.internal.util.DeploymentPropertiesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMuleApplication
extends AbstractDeployableArtifact<ApplicationDescriptor>
implements Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMuleApplication.class);
    private static final Logger SPLASH_LOGGER = LoggerFactory.getLogger((String)"org.mule.runtime.core.internal.logging");
    protected final ApplicationDescriptor descriptor;
    private final DomainRepository domainRepository;
    private final List<ArtifactPlugin> artifactPlugins;
    private final ServiceRepository serviceRepository;
    private final ExtensionModelLoaderRepository extensionModelLoaderRepository;
    private final ClassLoaderRepository classLoaderRepository;
    private final File location;
    private final MemoryManagementService memoryManagementService;
    private final ExpressionLanguageMetadataService expressionLanguageMetadataService;
    private final ArtifactConfigurationProcessor artifactConfigurationProcessor;
    private final Consumer<ClassLoader> actionOnMuleArtifactDeployment;
    private ApplicationStatus status;
    protected MuleContextListener muleContextListener;
    private NotificationListener<MuleContextNotification> statusListener;
    private final ApplicationPolicyProvider policyManager;
    private NotificationListenerRegistry notificationRegistrer;
    private final LockFactory runtimeLockFactory;

    public DefaultMuleApplication(ApplicationDescriptor descriptor, MuleDeployableArtifactClassLoader deploymentClassLoader, List<ArtifactPlugin> artifactPlugins, DomainRepository domainRepository, ServiceRepository serviceRepository, ExtensionModelLoaderRepository extensionModelLoaderRepository, File location, ClassLoaderRepository classLoaderRepository, ApplicationPolicyProvider applicationPolicyProvider, LockFactory runtimeLockFactory, MemoryManagementService memoryManagementService, ArtifactConfigurationProcessor artifactConfigurationProcessor) {
        this(descriptor, deploymentClassLoader, artifactPlugins, domainRepository, serviceRepository, extensionModelLoaderRepository, location, classLoaderRepository, applicationPolicyProvider, runtimeLockFactory, memoryManagementService, artifactConfigurationProcessor, cl -> {});
    }

    public DefaultMuleApplication(ApplicationDescriptor descriptor, MuleDeployableArtifactClassLoader deploymentClassLoader, List<ArtifactPlugin> artifactPlugins, DomainRepository domainRepository, ServiceRepository serviceRepository, ExtensionModelLoaderRepository extensionModelLoaderRepository, File location, ClassLoaderRepository classLoaderRepository, ApplicationPolicyProvider applicationPolicyProvider, LockFactory runtimeLockFactory, MemoryManagementService memoryManagementService, ArtifactConfigurationProcessor artifactConfigurationProcessor, Consumer<ClassLoader> actionOnMuleArtifactDeployment) {
        super("app", "application", deploymentClassLoader);
        this.descriptor = descriptor;
        this.domainRepository = domainRepository;
        this.serviceRepository = serviceRepository;
        this.extensionModelLoaderRepository = extensionModelLoaderRepository;
        this.classLoaderRepository = classLoaderRepository;
        this.artifactPlugins = artifactPlugins;
        this.location = location;
        this.policyManager = applicationPolicyProvider;
        this.runtimeLockFactory = runtimeLockFactory;
        this.memoryManagementService = memoryManagementService;
        this.expressionLanguageMetadataService = DefaultMuleApplication.getExpressionLanguageMetadataService(serviceRepository);
        this.artifactConfigurationProcessor = artifactConfigurationProcessor;
        this.actionOnMuleArtifactDeployment = actionOnMuleArtifactDeployment;
        this.updateStatusFor("not in lifecycle");
        if (this.deploymentClassLoader == null) {
            throw new IllegalArgumentException("Classloader cannot be null");
        }
    }

    private static ExpressionLanguageMetadataService getExpressionLanguageMetadataService(ServiceRepository serviceRepository) {
        if (serviceRepository == null) {
            return null;
        }
        return serviceRepository.getServices().stream().filter(ExpressionLanguageMetadataService.class::isInstance).findFirst().map(ExpressionLanguageMetadataService.class::cast).orElse(null);
    }

    @Override
    public void setMuleContextListener(MuleContextListener muleContextListener) {
        Preconditions.checkArgument(muleContextListener != null, "setMuleContextListener cannot be null");
        this.muleContextListener = muleContextListener;
    }

    @Override
    public void install() {
        ClassUtils.withContextClassLoader(null, () -> SPLASH_LOGGER.info(SplashScreen.miniSplash(String.format("New %s '%s'", this.shortArtifactType, this.descriptor.getName()))));
        this.updateStatusFor("not in lifecycle");
        try {
            for (String configFile : this.descriptor.getConfigResources()) {
                URL configFileUrl = this.getArtifactClassLoader().getClassLoader().getResource(configFile);
                if (configFileUrl != null) continue;
                String message = String.format("Config for %s '%s' not found: %s", this.shortArtifactType, this.getArtifactName(), configFile);
                throw new InstallException(I18nMessageFactory.createStaticMessage(message));
            }
        }
        catch (Exception e) {
            this.setStatusToFailed();
            throw e;
        }
    }

    @Override
    public ApplicationDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public Domain getDomain() {
        try {
            return DefaultMuleApplication.getApplicationDomain(this.domainRepository, this.descriptor);
        }
        catch (AmbiguousDomainReferenceException | DomainNotFoundException | IncompatibleDomainException e) {
            return null;
        }
    }

    @Override
    public void start() {
        ClassUtils.withContextClassLoader(null, () -> SPLASH_LOGGER.info(SplashScreen.miniSplash(String.format("Starting %s '%s'", this.shortArtifactType, this.descriptor.getName()))));
        try {
            this.artifactContext.getMuleContext().start();
            this.persistArtifactState("start");
            ClassUtils.withContextClassLoader(null, () -> {
                ApplicationStartedSplashScreen splashScreen = new ApplicationStartedSplashScreen();
                splashScreen.createMessage(this.descriptor);
                SPLASH_LOGGER.info(splashScreen.toString());
            });
        }
        catch (Exception e) {
            this.setStatusToFailed();
            if (e instanceof MuleException) {
                LOGGER.error(((MuleException)e).getDetailedMessage());
            } else {
                LOGGER.error(null, ExceptionUtils.getRootCause((Throwable)e));
            }
            throw new DeploymentStartException(I18nMessageFactory.createStaticMessage(String.format("Error starting %s '%s'", this.artifactType, this.descriptor.getName())), (Throwable)e);
        }
    }

    @Override
    public void init() {
        this.doInit(false, false, false);
    }

    @Override
    public void initTooling() {
        this.doInit(false, false, true);
    }

    private void doInit(boolean lazy, boolean disableXmlValidations, boolean addToolingObjectsToRegistry) {
        ClassUtils.withContextClassLoader(null, () -> SPLASH_LOGGER.info(SplashScreen.miniSplash(String.format("Initializing %s '%s'", this.shortArtifactType, this.descriptor.getName()))));
        try {
            ArtifactContextBuilder artifactBuilder = ArtifactContextBuilder.newBuilder().setArtifactProperties(this.merge(this.descriptor.getAppProperties(), this.getProperties())).setArtifactType(ArtifactType.APP).setArtifactConfigurationProcessor(null).setDataFolderName(this.descriptor.getDataFolderName()).setArtifactName(this.descriptor.getName()).setArtifactInstallationDirectory(this.descriptor.getArtifactLocation()).setArtifactConfigurationProcessor(this.artifactConfigurationProcessor).setConfigurationFiles(this.descriptor.getConfigResources().toArray(new String[this.descriptor.getConfigResources().size()])).setDefaultEncoding(this.descriptor.getEncoding()).setArtifactPlugins(this.artifactPlugins).setExecutionClassloader(this.deploymentClassLoader.getClassLoader()).setActionOnMuleArtifactDeployment(this.actionOnMuleArtifactDeployment).setEnableLazyInit(lazy).setDisableXmlValidations(disableXmlValidations).setAddToolingObjectsToRegistry(addToolingObjectsToRegistry).setServiceRepository(this.serviceRepository).setExtensionModelLoaderRepository(this.extensionModelLoaderRepository).setClassLoaderRepository(this.classLoaderRepository).setArtifactDeclaration(this.descriptor.getArtifactDeclaration()).setProperties(Optional.ofNullable(DeploymentPropertiesUtils.resolveDeploymentProperties(this.descriptor.getDataFolderName(), this.descriptor.getDeploymentProperties()))).setPolicyProvider(this.policyManager).setRuntimeLockFactory(this.runtimeLockFactory).setMemoryManagementService(this.memoryManagementService).setExpressionLanguageMetadataService(this.expressionLanguageMetadataService).setArtifactCoordinates(this.descriptor.getBundleDescriptor());
            Domain domain = DefaultMuleApplication.getApplicationDomain(this.domainRepository, this.descriptor);
            if (domain.getArtifactContext() != null) {
                artifactBuilder.setParentArtifact(domain);
            }
            if (this.muleContextListener != null) {
                artifactBuilder.setMuleContextListener(this.muleContextListener);
            }
            this.artifactContext = artifactBuilder.build();
            this.setMuleContext(this.artifactContext.getMuleContext(), this.artifactContext.getRegistry());
            LOGGER.debug(this.artifactContext.getMuleContext().getStatistics().getFlowSummaryStatistics().toString());
        }
        catch (Exception e) {
            this.setStatusToFailed();
            LOGGER.error(e.getMessage(), ExceptionUtils.getRootCause((Throwable)e));
            throw new DeploymentInitException(I18nMessageFactory.createStaticMessage(ExceptionUtils.getRootCauseMessage((Throwable)e)), (Throwable)e);
        }
    }

    private Properties getProperties() {
        if (!this.descriptor.getDeploymentProperties().isPresent()) {
            return new Properties();
        }
        return this.descriptor.getDeploymentProperties().get();
    }

    private Map<String, String> merge(Map<String, String> properties, Properties deploymentProperties) {
        if (deploymentProperties == null) {
            return properties;
        }
        HashMap<String, String> mergedProperties = new HashMap<String, String>();
        mergedProperties.putAll(properties);
        for (Map.Entry<Object, Object> entry : deploymentProperties.entrySet()) {
            mergedProperties.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return mergedProperties;
    }

    @Override
    public void lazyInit() {
        this.doInit(true, true, false);
    }

    @Override
    public void lazyInit(boolean disableXmlValidations) {
        this.doInit(true, disableXmlValidations, false);
    }

    @Override
    public void lazyInitTooling(boolean disableXmlValidations) {
        this.doInit(true, disableXmlValidations, true);
    }

    protected void setArtifactContext(ArtifactContext artifactContext) {
        this.artifactContext = artifactContext;
        this.setMuleContext(artifactContext.getMuleContext(), artifactContext.getRegistry());
    }

    private void setMuleContext(final MuleContext muleContext, Registry registry) {
        this.statusListener = new MuleContextNotificationListener<MuleContextNotification>(){

            @Override
            public boolean isBlocking() {
                return false;
            }

            @Override
            public void onNotification(MuleContextNotification notification) {
                IntegerAction action = notification.getAction();
                if (new IntegerAction(102).equals(action) || new IntegerAction(104).equals(action) || new IntegerAction(106).equals(action) || new IntegerAction(108).equals(action)) {
                    DefaultMuleApplication.this.updateStatusFor(muleContext.getLifecycleManager().getCurrentPhase());
                }
            }
        };
        this.notificationRegistrer = registry.lookupByType(NotificationListenerRegistry.class).get();
        this.notificationRegistrer.registerListener(this.statusListener);
    }

    private void updateStatusFor(String phase) {
        this.status = ApplicationStatusMapper.getApplicationStatus(phase);
    }

    private void setStatusToFailed() {
        if (this.artifactContext != null) {
            this.notificationRegistrer.unregisterListener(this.statusListener);
        }
        this.status = ApplicationStatus.DEPLOYMENT_FAILED;
    }

    @Override
    public Registry getRegistry() {
        return this.artifactContext != null ? this.artifactContext.getRegistry() : null;
    }

    @Override
    public File getLocation() {
        return this.location;
    }

    @Override
    public ConnectivityTestingService getConnectivityTestingService() {
        return (ConnectivityTestingService)this.artifactContext.getRegistry().lookupByName("_muleConnectivityTestingService").get();
    }

    @Override
    public MetadataService getMetadataService() {
        return (MetadataService)this.artifactContext.getRegistry().lookupByName("_muleMetadataService").get();
    }

    @Override
    public ValueProviderService getValueProviderService() {
        return (ValueProviderService)this.artifactContext.getRegistry().lookupByName("_muleValueProviderService").get();
    }

    @Override
    public SampleDataService getSampleDataService() {
        return (SampleDataService)this.artifactContext.getRegistry().lookupByName("_muleSampleDataService").get();
    }

    @Override
    public String getArtifactName() {
        return this.descriptor.getName();
    }

    @Override
    public String getArtifactId() {
        return this.deploymentClassLoader.getArtifactId();
    }

    @Override
    public File[] getResourceFiles() {
        return this.descriptor.getConfigResources().stream().map(configFile -> new File(this.getLocation(), (String)configFile)).collect(Collectors.toList()).toArray(new File[this.descriptor.getConfigResources().size()]);
    }

    @Override
    public ArtifactClassLoader getArtifactClassLoader() {
        return this.deploymentClassLoader;
    }

    @Override
    public ApplicationStatus getStatus() {
        return this.status;
    }

    @Override
    public RegionClassLoader getRegionClassLoader() {
        ClassLoader parentClassLoader = this.deploymentClassLoader.getClassLoader().getParent();
        if (parentClassLoader instanceof RegionClassLoader) {
            return (RegionClassLoader)parentClassLoader;
        }
        throw new IllegalStateException("Application is not a region owner");
    }

    @Override
    public ApplicationPolicyProvider getPolicyManager() {
        return this.policyManager;
    }

    @Override
    public List<ArtifactPlugin> getArtifactPlugins() {
        return this.artifactPlugins;
    }

    protected ArtifactClassLoader getDeploymentClassLoader() {
        return this.deploymentClassLoader;
    }

    public String toString() {
        return String.format("%s[%s]@%s", this.getClass().getName(), this.descriptor.getName(), Integer.toHexString(System.identityHashCode(this)));
    }

    static Domain getApplicationDomain(DomainRepository domainRepository, ApplicationDescriptor descriptor) throws DomainNotFoundException, IncompatibleDomainException, AmbiguousDomainReferenceException {
        Domain resolvedDomain = DefaultMuleApplication.resolveApplicationDomain(domainRepository, descriptor);
        descriptor.setDomainName(((DomainDescriptor)resolvedDomain.getDescriptor()).getName());
        return resolvedDomain;
    }

    private static Domain resolveApplicationDomain(DomainRepository domainRepository, ApplicationDescriptor descriptor) throws DomainNotFoundException, IncompatibleDomainException, AmbiguousDomainReferenceException {
        boolean shouldUseDefaultDomain;
        String configuredDomainName = descriptor.getDomainName();
        Optional<BundleDescriptor> domainBundleDescriptor = descriptor.getDomainDescriptor();
        boolean bl = shouldUseDefaultDomain = configuredDomainName == null || "default".equals(configuredDomainName);
        if (!shouldUseDefaultDomain && !domainBundleDescriptor.isPresent()) {
            throw new IllegalStateException(String.format("Dependency for domain '%s' was not declared", configuredDomainName));
        }
        if (!domainBundleDescriptor.isPresent()) {
            return domainRepository.getDomain("default");
        }
        if (configuredDomainName != null) {
            Domain foundDomain = domainRepository.getDomain(configuredDomainName);
            if (DefaultDomainManager.isCompatibleBundle(((DomainDescriptor)foundDomain.getDescriptor()).getBundleDescriptor(), domainBundleDescriptor.get())) {
                return foundDomain;
            }
            throw new IncompatibleDomainException(configuredDomainName, foundDomain);
        }
        return domainRepository.getCompatibleDomain(domainBundleDescriptor.get());
    }
}

