/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.type.runtime;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.module.extension.api.loader.java.type.AnnotationValueFetcher;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.TypeWrapper;

public class ClassBasedAnnotationValueFetcher<T extends Annotation>
implements AnnotationValueFetcher<T> {
    private final ClassTypeLoader typeLoader;
    private final LazyValue<T> annotation;

    public ClassBasedAnnotationValueFetcher(Class<T> annotationClass, AnnotatedElement annotatedElement, ClassTypeLoader typeLoader) {
        this.typeLoader = typeLoader;
        this.annotation = new LazyValue<Supplier<Annotation>>(() -> annotatedElement.getAnnotation(annotationClass));
    }

    public ClassBasedAnnotationValueFetcher(T annotation, ClassTypeLoader typeLoader) {
        this.typeLoader = typeLoader;
        this.annotation = new LazyValue<T>(annotation);
    }

    @Override
    public String getStringValue(Function<T, String> function) {
        return function.apply((Annotation)this.annotation.get());
    }

    @Override
    public <E> List<E> getArrayValue(Function<T, E[]> function) {
        return Arrays.asList(function.apply((Annotation)this.annotation.get()));
    }

    @Override
    public List<Type> getClassArrayValue(Function<T, Class[]> function) {
        return Stream.of(function.apply((Annotation)this.annotation.get())).map(e -> new TypeWrapper((Class<?>)e, this.typeLoader)).collect(Collectors.toList());
    }

    public TypeWrapper getClassValue(Function<T, Class> function) {
        return new TypeWrapper(function.apply((Annotation)this.annotation.get()), this.typeLoader);
    }

    @Override
    public <N extends Number> N getNumberValue(Function<T, N> function) {
        return (N)((Number)function.apply((Annotation)this.annotation.get()));
    }

    @Override
    public Boolean getBooleanValue(Function<T, Boolean> function) {
        return function.apply((Annotation)this.annotation.get());
    }

    @Override
    public <E extends Enum> E getEnumValue(Function<T, E> function) {
        return (E)((Enum)function.apply((Annotation)this.annotation.get()));
    }

    @Override
    public <E extends Annotation> AnnotationValueFetcher<E> getInnerAnnotation(Function<T, E> function) {
        return new ClassBasedAnnotationValueFetcher<Annotation>((Annotation)function.apply((Annotation)this.annotation.get()), this.typeLoader);
    }

    @Override
    public <E extends Annotation> List<AnnotationValueFetcher<E>> getInnerAnnotations(Function<T, E[]> function) {
        return Stream.of((Annotation[])function.apply((Annotation)this.annotation.get())).map(e -> new ClassBasedAnnotationValueFetcher<Annotation>((Annotation)e, this.typeLoader)).collect(Collectors.toList());
    }
}

