/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.el;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.el.Binding;
import org.mule.runtime.api.el.ExpressionModule;
import org.mule.runtime.api.el.ModuleNamespace;
import org.mule.runtime.api.metadata.TypedValue;

public class DefaultExpressionModuleBuilder
implements ExpressionModule.Builder {
    private Map<String, TypedValue<?>> bindings;
    private ModuleNamespace namespace;
    private List<MetadataType> declaredTypes;

    public DefaultExpressionModuleBuilder(ModuleNamespace namespace) {
        this.namespace = namespace;
        this.bindings = new HashMap();
        this.declaredTypes = new ArrayList<MetadataType>();
    }

    @Override
    public ExpressionModule.Builder addBinding(String identifier, TypedValue<?> typedValue) {
        this.bindings.put(identifier, typedValue);
        return this;
    }

    @Override
    public ExpressionModule.Builder addType(MetadataType type) {
        this.declaredTypes.add(type);
        return this;
    }

    @Override
    public ExpressionModule build() {
        return new DefaultExpressionModule(this.bindings, this.namespace, this.declaredTypes);
    }

    private static class DefaultExpressionModule
    implements ExpressionModule {
        private Map<String, TypedValue<?>> bindings;
        private ModuleNamespace namespace;
        private List<MetadataType> declaredTypes;

        public DefaultExpressionModule(Map<String, TypedValue<?>> bindings, ModuleNamespace namespace, List<MetadataType> declaredTypes) {
            this.bindings = bindings;
            this.namespace = namespace;
            this.declaredTypes = declaredTypes;
        }

        @Override
        public Collection<Binding> bindings() {
            return this.bindings.entrySet().stream().map(entry -> new Binding((String)entry.getKey(), (TypedValue)entry.getValue())).collect(Collectors.toList());
        }

        @Override
        public Collection<String> identifiers() {
            return this.bindings.keySet();
        }

        @Override
        public Optional<TypedValue> lookup(String identifier) {
            return Optional.ofNullable(this.bindings.get(identifier));
        }

        @Override
        public ModuleNamespace namespace() {
            return this.namespace;
        }

        @Override
        public List<MetadataType> declaredTypes() {
            return this.declaredTypes;
        }
    }
}

