/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.nested.NestableElementModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.builder.ComponentAstBuilder;
import org.mule.runtime.ast.api.model.ExtensionModelHelper;
import org.mule.runtime.ast.internal.DefaultComponentAst;
import org.mule.runtime.ast.internal.builder.ApplicationModelTypeUtils;
import org.mule.runtime.ast.internal.builder.BaseComponentAstBuilder;
import org.mule.runtime.ast.internal.builder.ComponentLocationVisitor;
import org.mule.runtime.ast.internal.builder.ParameterKey;
import org.mule.runtime.ast.internal.builder.PropertiesResolver;
import org.mule.runtime.ast.internal.model.ParameterModelUtils;

public class DefaultComponentAstBuilder
extends BaseComponentAstBuilder<DefaultComponentAstBuilder> {
    private final ExtensionModelHelper extModelHelper;
    private final List<DefaultComponentAstBuilder> hierarchy;
    private final int indexInParent;
    private final ComponentLocationVisitor componentLocationVisitor;

    public DefaultComponentAstBuilder(PropertiesResolver propertiesResolver, ExtensionModelHelper extModelHelper, List<DefaultComponentAstBuilder> hierarchy, int indexInParent, ComponentLocationVisitor componentLocationVisitor, ParameterModelUtils parameterModelUtils) {
        super(propertiesResolver, parameterModelUtils);
        this.extModelHelper = extModelHelper;
        this.hierarchy = hierarchy;
        this.indexInParent = indexInParent;
        this.componentLocationVisitor = componentLocationVisitor;
    }

    @Override
    public ComponentAstBuilder addChildComponent() {
        ArrayList<DefaultComponentAstBuilder> childHierarchy = new ArrayList<DefaultComponentAstBuilder>(this.hierarchy);
        childHierarchy.add(this);
        DefaultComponentAstBuilder componentAstBuilder = new DefaultComponentAstBuilder(this.getPropertiesResolver(), this.extModelHelper, childHierarchy, (int)this.childComponentsStream().count(), this.componentLocationVisitor, this.getParameterModelUtils());
        this.addChildComponent(componentAstBuilder);
        return componentAstBuilder;
    }

    @Override
    public ComponentAstBuilder withIdentifier(ComponentIdentifier identifier) {
        this.extModelHelper.lookupExtensionModelFor(identifier).ifPresent(this::withExtensionModel);
        return super.withIdentifier(identifier);
    }

    @Override
    public ComponentAst get() {
        return this.build();
    }

    @Override
    public ComponentAst build() {
        this.prepareForBuild();
        return this.doBuild();
    }

    @Override
    public void prepareForBuild() {
        Objects.requireNonNull(this.getIdentifier(), "identifier");
        Objects.requireNonNull(this.getMetadata(), "metadata");
        if (!this.getModel(Object.class).isPresent()) {
            ApplicationModelTypeUtils.resolveTypedComponentIdentifier(this, this.getParent(), this.extModelHelper);
        }
        super.prepareForBuild();
        this.childComponentsStream().forEach(DefaultComponentAstBuilder::prepareForBuild);
    }

    private Optional<ComponentAstBuilder> getParent() {
        if (this.hierarchy.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((ComponentAstBuilder)this.hierarchy.get(this.hierarchy.size() - 1));
    }

    private ComponentAst doBuild() {
        Map<ParameterKey, ComponentParameterAst> parameterAsts = this.createParameterAsts();
        List<ComponentAst> builtChildren = this.childComponentsStream().map(DefaultComponentAstBuilder::doBuild).collect(Collectors.toList());
        Set paramNames = parameterAsts.keySet().stream().map(ParameterKey::getParamName).collect(Collectors.toSet());
        Map<String, String> extraParams = this.getRawParameters().entrySet().stream().filter(e -> paramNames.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Supplier<Optional<String>> componentId = this.obtainLocation(parameterAsts);
        return new DefaultComponentAst(builtChildren, parameterAsts, extraParams, this.getPropertiesResolver(), this.getAnnotations(), componentId, this.getExtensionModel(), this.getModel(ComponentModel.class).orElse(null), this.getModel(NestableElementModel.class).orElse(null), this.getModel(ConfigurationModel.class).orElse(null), this.getModel(ConnectionProviderModel.class).orElse(null), this.getModel(ParameterizedModel.class).orElse(null), this.getType(), this.getGenerationInformation().build(), this.getMetadata(), this.getLocation(), this.getIdentifier(), this.getComponentType());
    }

    @Override
    public ComponentLocation getLocation() {
        ComponentLocation location = super.getLocation();
        if (location != null) {
            return location;
        }
        this.obtainLocation(this.createParameterAsts());
        return super.getLocation();
    }

    protected Supplier<Optional<String>> obtainLocation(Map<ParameterKey, ComponentParameterAst> parameterAsts) {
        LazyValue<Supplier<Optional>> componentId = new LazyValue<Supplier<Optional>>(() -> this.resolveComponentId(parameterAsts));
        this.setComponentId(componentId);
        this.componentLocationVisitor.resolveLocation(this, this.hierarchy);
        return componentId;
    }

    public int getIndexInParent() {
        return this.indexInParent;
    }
}

