/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime;

import java.util.Collections;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.security.SecurityContext;
import org.mule.runtime.api.util.collection.SmallMap;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.internal.event.InternalEvent;
import org.mule.runtime.core.privileged.transaction.TransactionConfig;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.operation.InputEventAware;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public class DefaultExecutionContext<M extends ComponentModel>
implements ExecutionContextAdapter<M> {
    private final ExtensionModel extensionModel;
    private final Optional<ConfigurationInstance> configuration;
    private final Map<String, Object> parameters;
    private final Map<String, Object> variables = new SmallMap<String, Object>();
    private final M componentModel;
    private final MuleContext muleContext;
    private CoreEvent event;
    private SecurityContext securityContext;
    private final CursorProviderFactory cursorProviderFactory;
    private final StreamingManager streamingManager;
    private final Optional<TransactionConfig> transactionConfig;
    private final Component component;
    private final RetryPolicyTemplate retryPolicyTemplate;
    private Scheduler currentScheduler;

    public DefaultExecutionContext(ExtensionModel extensionModel, Optional<ConfigurationInstance> configuration, Map<String, Object> parameters, M componentModel, CoreEvent event, CursorProviderFactory cursorProviderFactory, StreamingManager streamingManager, Component component, RetryPolicyTemplate retryPolicyTemplate, Scheduler currentScheduler, Optional<TransactionConfig> transactionConfig, MuleContext muleContext) {
        this.extensionModel = extensionModel;
        this.configuration = configuration;
        this.event = event;
        this.securityContext = event.getSecurityContext();
        this.componentModel = componentModel;
        this.parameters = parameters;
        this.cursorProviderFactory = cursorProviderFactory;
        this.streamingManager = streamingManager;
        this.muleContext = muleContext;
        this.component = component;
        this.retryPolicyTemplate = retryPolicyTemplate;
        this.currentScheduler = currentScheduler;
        this.transactionConfig = transactionConfig;
    }

    @Override
    public Optional<ConfigurationInstance> getConfiguration() {
        return this.configuration;
    }

    @Override
    public boolean hasParameter(String parameterName) {
        return this.parameters.containsKey(parameterName);
    }

    @Override
    public <T> T getParameter(String parameterName) {
        if (this.hasParameter(parameterName)) {
            return (T)this.parameters.get(parameterName);
        }
        throw new NoSuchElementException(parameterName);
    }

    @Override
    public <T> T getParameterOrDefault(String parameterName, T defaultValue) {
        if (this.hasParameter(parameterName)) {
            return (T)this.parameters.get(parameterName);
        }
        return defaultValue;
    }

    @Override
    public Map<String, Object> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    @Override
    public <T> T getVariable(String key) {
        return (T)this.variables.get(key);
    }

    @Override
    public Object setVariable(String key, Object value) {
        return this.variables.put(Objects.requireNonNull(key, "null keys are not allowed"), Objects.requireNonNull(value, "null values are not allowed"));
    }

    @Override
    public <T> T removeVariable(String key) {
        return (T)this.variables.remove(Objects.requireNonNull(key, "null keys are not allowed"));
    }

    @Override
    public CoreEvent getEvent() {
        return this.event;
    }

    @Override
    public void changeEvent(CoreEvent updated) {
        Objects.requireNonNull(this.event);
        this.securityContext = updated.getSecurityContext();
        for (Object parameterValue : this.parameters.values()) {
            if ((parameterValue = MuleExtensionUtils.asEventAware(parameterValue)) == null) continue;
            CoreEvent originalEvent = ((InputEventAware)parameterValue).getOriginalEvent();
            this.addContextToOriginalEvent(originalEvent, updated);
            break;
        }
        this.event = updated;
    }

    @Override
    public void setSecurityContext(SecurityContext securityContext) {
        Objects.requireNonNull(securityContext);
        this.securityContext = securityContext;
    }

    @Override
    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    @Override
    public void setCurrentScheduler(Scheduler currentScheduler) {
        this.currentScheduler = currentScheduler;
    }

    @Override
    public Scheduler getCurrentScheduler() {
        return this.currentScheduler;
    }

    @Override
    public ExtensionModel getExtensionModel() {
        return this.extensionModel;
    }

    @Override
    public M getComponentModel() {
        return this.componentModel;
    }

    @Override
    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    @Override
    public CursorProviderFactory getCursorProviderFactory() {
        return this.cursorProviderFactory;
    }

    @Override
    public Optional<TransactionConfig> getTransactionConfig() {
        return this.transactionConfig;
    }

    @Override
    public StreamingManager getStreamingManager() {
        return this.streamingManager;
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    @Override
    public ComponentLocation getComponentLocation() {
        return this.component.getLocation();
    }

    @Override
    public Optional<RetryPolicyTemplate> getRetryPolicyTemplate() {
        return Optional.ofNullable(this.retryPolicyTemplate);
    }

    private void addContextToOriginalEvent(CoreEvent originalEvent, CoreEvent updatedEvent) {
        if (originalEvent.getContext().getId().equals(this.event.getContext().getId())) {
            ((InternalEvent)originalEvent).setSdkInternalContext(((InternalEvent)updatedEvent).getSdkInternalContext());
        }
    }
}

