/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java;

import com.google.common.base.Enums;
import java.lang.annotation.Annotation;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.ClassValueModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.PathModel;
import org.mule.runtime.api.meta.model.operation.ExecutionType;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.annotation.license.RequiresEnterpriseLicense;
import org.mule.runtime.extension.api.annotation.license.RequiresEntitlement;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Path;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalParameterModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.model.deprecated.ImmutableDeprecationModel;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.route.Chain;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.module.extension.api.loader.java.type.AnnotationValueFetcher;
import org.mule.runtime.module.extension.api.loader.java.type.ComponentElement;
import org.mule.runtime.module.extension.api.loader.java.type.ConnectionProviderElement;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.api.loader.java.type.FunctionContainerElement;
import org.mule.runtime.module.extension.api.loader.java.type.FunctionElement;
import org.mule.runtime.module.extension.api.loader.java.type.MethodElement;
import org.mule.runtime.module.extension.api.loader.java.type.OperationContainerElement;
import org.mule.runtime.module.extension.api.loader.java.type.OperationElement;
import org.mule.runtime.module.extension.api.loader.java.type.SourceElement;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.api.loader.java.type.WithAnnotations;
import org.mule.runtime.module.extension.api.loader.java.type.WithOperationContainers;
import org.mule.runtime.module.extension.api.loader.java.type.WithParameters;
import org.mule.runtime.module.extension.internal.loader.java.property.MediaTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.parser.ConnectionProviderModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.FunctionModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.OperationModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.ParameterGroupModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.ParameterModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.ParameterModelParserDecorator;
import org.mule.runtime.module.extension.internal.loader.parser.SourceModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaConnectionProviderModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaDeclaredParameterGroupModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaDefaultParameterGroupParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaExtensionModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaFunctionModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaOperationModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaSourceModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.MuleExtensionAnnotationParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.ParameterDeclarationContext;
import org.mule.runtime.module.extension.internal.loader.parser.java.info.RequiresEnterpriseLicenseInfo;
import org.mule.runtime.module.extension.internal.loader.parser.java.info.RequiresEntitlementInfo;
import org.mule.sdk.api.annotation.deprecated.Deprecated;
import org.mule.sdk.api.annotation.execution.Execution;
import org.mule.sdk.api.annotation.metadata.MetadataKeyId;
import org.mule.sdk.api.annotation.param.Connection;
import org.mule.sdk.api.annotation.param.Parameter;
import org.mule.sdk.api.annotation.param.ParameterGroup;
import org.mule.sdk.api.annotation.param.display.ClassValue;
import org.mule.sdk.api.annotation.param.display.Summary;
import org.mule.sdk.api.annotation.semantics.file.FilePath;
import org.mule.sdk.api.runtime.process.VoidCompletionCallback;

public final class JavaExtensionModelParserUtils {
    private JavaExtensionModelParserUtils() {
    }

    public static List<ExtensionParameter> getCompletionCallbackParameters(MethodElement method) {
        return method.getParameters().stream().filter(p -> {
            Type type = p.getType();
            return type.isAssignableTo(CompletionCallback.class) || type.isAssignableTo(org.mule.sdk.api.runtime.process.CompletionCallback.class) || type.isAssignableTo(VoidCompletionCallback.class);
        }).collect(Collectors.toList());
    }

    public static boolean isCompletionCallbackParameter(ExtensionParameter extensionParameter) {
        return extensionParameter.getType().isAssignableTo(CompletionCallback.class) || extensionParameter.getType().isAssignableTo(org.mule.sdk.api.runtime.process.CompletionCallback.class);
    }

    public static boolean isAutoPaging(MethodElement operationMethod) {
        Type returnType = operationMethod.getReturnType();
        return returnType.isAssignableTo(PagingProvider.class) || returnType.isAssignableTo(org.mule.sdk.api.runtime.streaming.PagingProvider.class);
    }

    public static boolean isProcessorChain(ExtensionParameter parameter) {
        Type type = parameter.getType();
        return type.isAssignableTo(Chain.class) || type.isAssignableTo(org.mule.sdk.api.runtime.route.Chain.class);
    }

    public static boolean isParameterGroup(ExtensionParameter groupParameter) {
        return groupParameter.isAnnotatedWith(org.mule.runtime.extension.api.annotation.param.ParameterGroup.class) || groupParameter.isAnnotatedWith(ParameterGroup.class);
    }

    public static boolean isParameter(ExtensionParameter parameter) {
        return parameter.isAnnotatedWith(org.mule.runtime.extension.api.annotation.param.Parameter.class) || parameter.isAnnotatedWith(Parameter.class);
    }

    public static Stream<OperationModelParser> getOperationParsers(JavaExtensionModelParser extensionModelParser, ExtensionElement extensionElement, WithOperationContainers operationContainers, ExtensionLoadingContext loadingContext) {
        return operationContainers.getOperationContainers().stream().flatMap(container -> container.getOperations().stream().map(method -> new JavaOperationModelParser(extensionModelParser, extensionElement, (OperationContainerElement)container, (OperationElement)method, loadingContext)));
    }

    public static Stream<SourceModelParser> getSourceParsers(ExtensionElement extensionElement, List<SourceElement> sources, ExtensionLoadingContext loadingContext) {
        return sources.stream().map(source -> new JavaSourceModelParser(extensionElement, (SourceElement)source, loadingContext));
    }

    public static List<ConnectionProviderModelParser> getConnectionProviderModelParsers(JavaExtensionModelParser extensionModelParser, ExtensionElement extensionElement, List<ConnectionProviderElement> connectionProviderElements, ExtensionLoadingContext loadingContext) {
        return connectionProviderElements.stream().map(cpElement -> new JavaConnectionProviderModelParser(extensionModelParser, extensionElement, (ConnectionProviderElement)cpElement, loadingContext)).collect(Collectors.toList());
    }

    public static List<FunctionModelParser> getFunctionModelParsers(ExtensionElement extensionElement, List<FunctionContainerElement> functionContainers, ExtensionLoadingContext loadingContext) {
        return functionContainers.stream().flatMap(container -> container.getFunctions().stream()).map(func -> new JavaFunctionModelParser(extensionElement, (FunctionElement)func, loadingContext)).collect(Collectors.toList());
    }

    public static List<ParameterGroupModelParser> getParameterGroupParsers(List<? extends ExtensionParameter> parameters, ParameterDeclarationContext context) {
        return JavaExtensionModelParserUtils.getParameterGroupParsers(parameters, context, null);
    }

    public static List<ParameterGroupModelParser> getSourceParameterGroupParsers(List<? extends ExtensionParameter> parameters, ParameterDeclarationContext context) {
        return JavaExtensionModelParserUtils.getParameterGroupParsers(parameters, context, p -> new ParameterModelParserDecorator((ParameterModelParser)p){

            @Override
            public ExpressionSupport getExpressionSupport() {
                return ExpressionSupport.NOT_SUPPORTED;
            }
        });
    }

    static List<ParameterGroupModelParser> getParameterGroupParsers(List<? extends ExtensionParameter> parameters, ParameterDeclarationContext context, Function<ParameterModelParser, ParameterModelParser> parameterMutator) {
        JavaExtensionModelParserUtils.checkAnnotationsNotUsedMoreThanOnce(parameters, org.mule.runtime.extension.api.annotation.param.Connection.class, Connection.class, Config.class, org.mule.sdk.api.annotation.param.Config.class, org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId.class, MetadataKeyId.class);
        LinkedList<ParameterGroupModelParser> groups = new LinkedList<ParameterGroupModelParser>();
        LinkedList<ExtensionParameter> defaultGroupParams = new LinkedList<ExtensionParameter>();
        boolean defaultGroupAdded = false;
        for (ExtensionParameter extensionParameter : parameters) {
            if (!extensionParameter.shouldBeAdvertised()) continue;
            if (JavaExtensionModelParserUtils.isParameterGroup(extensionParameter)) {
                groups.add(new JavaDeclaredParameterGroupModelParser(extensionParameter, context, parameterMutator));
                continue;
            }
            defaultGroupParams.add(extensionParameter);
            if (defaultGroupAdded) continue;
            groups.add(new JavaDefaultParameterGroupParser(defaultGroupParams, context, parameterMutator));
            defaultGroupAdded = true;
        }
        return groups;
    }

    private static void checkAnnotationsNotUsedMoreThanOnce(List<? extends ExtensionParameter> parameters, Class<? extends Annotation> ... annotations) {
        for (Class<? extends Annotation> annotation : annotations) {
            int usages = 0;
            for (ExtensionParameter extensionParameter : parameters) {
                if (!extensionParameter.isAnnotatedWith(annotation) || ++usages <= 1) continue;
                throw new IllegalModelDefinitionException(String.format("The defined parameters %s from %s, uses the annotation @%s more than once", parameters.stream().map(p -> p.getName()).collect(Collectors.toList()), parameters.iterator().next().getOwnerDescription(), annotation.getSimpleName()));
            }
        }
    }

    public static Optional<ExtensionParameter> getConfigParameter(WithParameters element) {
        Optional<ExtensionParameter> configParameter = element.getParametersAnnotatedWith(Config.class).stream().findFirst();
        if (!configParameter.isPresent()) {
            configParameter = element.getParametersAnnotatedWith(org.mule.sdk.api.annotation.param.Config.class).stream().findFirst();
        }
        return configParameter;
    }

    public static Optional<ExtensionParameter> getConnectionParameter(WithParameters element) {
        Optional<ExtensionParameter> connectionParameter = element.getParametersAnnotatedWith(org.mule.runtime.extension.api.annotation.param.Connection.class).stream().findFirst();
        if (!connectionParameter.isPresent()) {
            connectionParameter = element.getParametersAnnotatedWith(Connection.class).stream().findFirst();
        }
        return connectionParameter;
    }

    public static Optional<DeprecationModel> getDeprecationModel(ExtensionParameter extensionParameter) {
        return JavaExtensionModelParserUtils.getDeprecationModel(extensionParameter, "Parameter", extensionParameter.getName());
    }

    public static Optional<DeprecationModel> getDeprecationModel(FunctionElement functionElement) {
        return JavaExtensionModelParserUtils.getDeprecationModel(functionElement, "Function", functionElement.getName());
    }

    public static Optional<DeprecationModel> getDeprecationModel(OperationElement operationElement) {
        return JavaExtensionModelParserUtils.getDeprecationModel(operationElement, "Operation", operationElement.getName());
    }

    public static Optional<DeprecationModel> getDeprecationModel(SourceElement sourceElement) {
        return JavaExtensionModelParserUtils.getDeprecationModel(sourceElement, "Source", sourceElement.getName());
    }

    public static Optional<DeprecationModel> getDeprecationModel(ConnectionProviderElement connectionProviderElement) {
        return JavaExtensionModelParserUtils.getDeprecationModel(connectionProviderElement, "Connection provider", connectionProviderElement.getName());
    }

    public static Optional<DeprecationModel> getDeprecationModel(ComponentElement componentElement) {
        return JavaExtensionModelParserUtils.getDeprecationModel(componentElement, "Component", componentElement.getName());
    }

    public static Optional<DeprecationModel> getDeprecationModel(ExtensionElement extensionElement) {
        return JavaExtensionModelParserUtils.getDeprecationModel(extensionElement, "Extension", extensionElement.getName());
    }

    public static Optional<RequiresEnterpriseLicenseInfo> getRequiresEnterpriseLicenseInfo(ExtensionElement extensionElement) {
        return MuleExtensionAnnotationParser.mapReduceSingleAnnotation(extensionElement, RequiresEnterpriseLicense.class, org.mule.sdk.api.annotation.license.RequiresEnterpriseLicense.class, value -> new RequiresEnterpriseLicenseInfo(value.getBooleanValue(RequiresEnterpriseLicense::allowEvaluationLicense)), value -> new RequiresEnterpriseLicenseInfo(value.getBooleanValue(org.mule.sdk.api.annotation.license.RequiresEnterpriseLicense::allowEvaluationLicense)));
    }

    public static Optional<RequiresEntitlementInfo> getRequiresEntitlementInfo(ExtensionElement extensionElement) {
        return MuleExtensionAnnotationParser.mapReduceSingleAnnotation(extensionElement, RequiresEntitlement.class, org.mule.sdk.api.annotation.license.RequiresEntitlement.class, value -> new RequiresEntitlementInfo(value.getStringValue(RequiresEntitlement::name), value.getStringValue(RequiresEntitlement::description)), value -> new RequiresEntitlementInfo(value.getStringValue(org.mule.sdk.api.annotation.license.RequiresEntitlement::name), value.getStringValue(org.mule.sdk.api.annotation.license.RequiresEntitlement::description)));
    }

    public static Optional<DisplayModel> getDisplayModel(WithAnnotations element, String elementType, String elementName) {
        Optional<DisplayModel> displayModel;
        Optional<String> summary = MuleExtensionAnnotationParser.mapReduceSingleAnnotation(element, elementType, elementName, org.mule.runtime.extension.api.annotation.param.display.Summary.class, Summary.class, value -> value.getStringValue(org.mule.runtime.extension.api.annotation.param.display.Summary::value), value -> value.getStringValue(Summary::value));
        Optional<String> displayName = MuleExtensionAnnotationParser.mapReduceSingleAnnotation(element, elementType, elementName, DisplayName.class, org.mule.sdk.api.annotation.param.display.DisplayName.class, value -> value.getStringValue(DisplayName::value), value -> value.getStringValue(org.mule.sdk.api.annotation.param.display.DisplayName::value));
        Optional<String> example = MuleExtensionAnnotationParser.mapReduceSingleAnnotation(element, elementType, elementName, Example.class, org.mule.sdk.api.annotation.param.display.Example.class, value -> value.getStringValue(Example::value), value -> value.getStringValue(org.mule.sdk.api.annotation.param.display.Example::value));
        Function<AnnotationValueFetcher, ClassValueModel> valueFromLegacyAnnotation = classValue -> new ClassValueModel(classValue.getArrayValue(org.mule.runtime.extension.api.annotation.param.display.ClassValue::extendsOrImplements).stream().filter(p -> !StringUtils.isBlank(p)).collect(Collectors.toList()));
        Function<AnnotationValueFetcher, ClassValueModel> valueFromSdkAnnotation = classValue -> new ClassValueModel(classValue.getArrayValue(ClassValue::extendsOrImplements).stream().filter(p -> !StringUtils.isBlank(p)).collect(Collectors.toList()));
        Optional<ClassValueModel> classValueModel = MuleExtensionAnnotationParser.mapReduceSingleAnnotation(element, elementType, elementName, org.mule.runtime.extension.api.annotation.param.display.ClassValue.class, ClassValue.class, valueFromLegacyAnnotation, valueFromSdkAnnotation);
        Function<AnnotationValueFetcher, PathModel> pathModelFromLegacyAnnotation = value -> new PathModel(value.getEnumValue(Path::type), value.getBooleanValue(Path::acceptsUrls), value.getEnumValue(Path::location), (String[])value.getArrayValue(Path::acceptedFileExtensions).stream().toArray(String[]::new));
        Function<AnnotationValueFetcher, PathModel> pathModelFromSdkAnnotation = value -> new PathModel(value.getEnumValue(FilePath::type), value.getBooleanValue(FilePath::acceptsUrls), value.getEnumValue(FilePath::location), (String[])value.getArrayValue(FilePath::acceptedFileExtensions).stream().toArray(String[]::new));
        Optional<PathModel> pathModel = MuleExtensionAnnotationParser.mapReduceSingleAnnotation(element, elementType, elementName, Path.class, FilePath.class, pathModelFromLegacyAnnotation, pathModelFromSdkAnnotation);
        if (summary.isPresent() || displayName.isPresent() || example.isPresent() || classValueModel.isPresent() || pathModel.isPresent()) {
            DisplayModel.DisplayModelBuilder builder = DisplayModel.builder();
            summary.ifPresent(builder::summary);
            displayName.ifPresent(builder::displayName);
            example.ifPresent(builder::example);
            classValueModel.ifPresent(builder::classValue);
            pathModel.ifPresent(builder::path);
            displayModel = Optional.of(builder.build());
        } else {
            displayModel = Optional.empty();
        }
        return displayModel;
    }

    public static Optional<ExecutionType> getExecutionType(OperationElement operationElement) {
        return MuleExtensionAnnotationParser.mapReduceSingleAnnotation(operationElement, "Operation", operationElement.getName(), org.mule.runtime.extension.api.annotation.execution.Execution.class, Execution.class, value -> value.getEnumValue(org.mule.runtime.extension.api.annotation.execution.Execution::value), value -> JavaExtensionModelParserUtils.mapEnumTo(value.getEnumValue(Execution::value), ExecutionType.class));
    }

    private static <T extends Enum<T>> T mapEnumTo(Enum fromEnum, Class<T> toEnumClass) {
        return (T)((Enum)Enums.getIfPresent(toEnumClass, (String)fromEnum.name()).orNull());
    }

    private static Optional<DeprecationModel> getDeprecationModel(WithAnnotations element, String elementType, String elementName) {
        return MuleExtensionAnnotationParser.mapReduceAnnotation(element, org.mule.runtime.extension.api.annotation.deprecated.Deprecated.class, Deprecated.class, value -> JavaExtensionModelParserUtils.buildDeprecationModel(value.getStringValue(org.mule.runtime.extension.api.annotation.deprecated.Deprecated::message), value.getStringValue(org.mule.runtime.extension.api.annotation.deprecated.Deprecated::since), value.getStringValue(org.mule.runtime.extension.api.annotation.deprecated.Deprecated::toRemoveIn)), value -> JavaExtensionModelParserUtils.buildDeprecationModel(value.getStringValue(Deprecated::message), value.getStringValue(Deprecated::since), value.getStringValue(Deprecated::toRemoveIn)), () -> new IllegalParameterModelDefinitionException(String.format("%s '%s' is annotated with '@%s' and '@%s' at the same time", elementType, elementName, org.mule.runtime.extension.api.annotation.deprecated.Deprecated.class.getName(), Deprecated.class.getName())));
    }

    private static DeprecationModel buildDeprecationModel(String message, String since, String toRemoveIn) {
        if (StringUtils.isBlank(toRemoveIn)) {
            toRemoveIn = null;
        }
        return new ImmutableDeprecationModel(message, since, toRemoveIn);
    }

    public static Optional<MediaTypeModelProperty> getMediaTypeModelProperty(WithAnnotations element, String elementType, String elementName) {
        Optional<String> stringValue = MuleExtensionAnnotationParser.mapReduceSingleAnnotation(element, elementType, elementName, MediaType.class, org.mule.sdk.api.annotation.param.MediaType.class, ann -> ann.getStringValue(MediaType::value), ann -> ann.getStringValue(org.mule.sdk.api.annotation.param.MediaType::value));
        Optional<Boolean> booleanValue = MuleExtensionAnnotationParser.mapReduceSingleAnnotation(element, elementType, elementName, MediaType.class, org.mule.sdk.api.annotation.param.MediaType.class, ann -> ann.getBooleanValue(MediaType::strict), ann -> ann.getBooleanValue(org.mule.sdk.api.annotation.param.MediaType::strict));
        return stringValue.flatMap(str -> booleanValue.map(bool -> new MediaTypeModelProperty((String)str, (boolean)bool)));
    }
}

