/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.serialization.json.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.ast.internal.serialization.json.gson.ComponentIdentifierJsonDeserializer;
import org.mule.runtime.ast.internal.serialization.util.DslUtils;

public final class TypedComponentIdentifierJsonDeserializer
implements JsonDeserializer<TypedComponentIdentifier> {
    private final ComponentIdentifierJsonDeserializer componentIdentifierJsonDeserializer = new ComponentIdentifierJsonDeserializer();

    public TypedComponentIdentifier deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        if (jsonElement == null) {
            return null;
        }
        JsonObject locationPartIdentifierJsonObject = jsonElement.getAsJsonObject();
        JsonElement identifier = locationPartIdentifierJsonObject.get("identifier");
        JsonElement componentType = locationPartIdentifierJsonObject.get("type");
        ComponentIdentifier componentIdentifier = identifier != null ? this.componentIdentifierJsonDeserializer.deserialize(identifier, (Type)((Object)ComponentIdentifier.class), jsonDeserializationContext) : null;
        return TypedComponentIdentifier.builder().identifier(componentIdentifier).type(this.getComponentType(componentType, componentIdentifier)).build();
    }

    private TypedComponentIdentifier.ComponentType getComponentType(JsonElement componentType, ComponentIdentifier componentIdentifier) {
        return DslUtils.isSubflow(componentIdentifier) ? TypedComponentIdentifier.ComponentType.SUB_FLOW : this.deserializeComponentType(componentType);
    }

    private TypedComponentIdentifier.ComponentType deserializeComponentType(JsonElement componentType) {
        return componentType != null ? TypedComponentIdentifier.ComponentType.valueOf(componentType.getAsJsonObject().get("name").getAsString()) : null;
    }
}

