/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.type.runtime;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.extension.api.annotation.Configurations;
import org.mule.runtime.module.extension.api.loader.java.type.ConfigurationElement;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.api.loader.java.type.FunctionElement;
import org.mule.runtime.module.extension.api.loader.java.type.OperationElement;
import org.mule.runtime.module.extension.api.loader.java.type.ParameterizableTypeElement;
import org.mule.runtime.module.extension.internal.loader.java.info.ExtensionInfo;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ComponentWrapper;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ConfigurationWrapper;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.FunctionWrapper;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.OperationWrapper;
import org.mule.runtime.module.extension.internal.loader.parser.java.MuleExtensionAnnotationParser;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public class ExtensionTypeWrapper<T>
extends ComponentWrapper
implements ExtensionElement,
ParameterizableTypeElement {
    private final LazyValue<ExtensionInfo> extensionInfo = new LazyValue<Supplier<ExtensionInfo>>(() -> MuleExtensionAnnotationParser.getExtensionInfo(aClass));

    public ExtensionTypeWrapper(Class<T> aClass, ClassTypeLoader typeLoader) {
        super(aClass, typeLoader);
    }

    @Override
    public List<ConfigurationElement> getConfigurations() {
        return MuleExtensionAnnotationParser.mapReduceSingleAnnotation(this, Configurations.class, org.mule.sdk.api.annotation.Configurations.class, value -> value.getClassArrayValue(Configurations::value), value -> value.getClassArrayValue(org.mule.sdk.api.annotation.Configurations::value)).map(types -> types.stream().map(type -> new ConfigurationWrapper((Class)type.getDeclaringClass().get(), this.typeLoader)).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    @Override
    public List<OperationElement> getOperations() {
        return this.getOperationClassStream().flatMap(clazz -> IntrospectionUtils.getApiMethods(clazz).stream()).map(clazz -> new OperationWrapper((Method)clazz, this.typeLoader)).collect(Collectors.toList());
    }

    @Override
    public List<FunctionElement> getFunctions() {
        return this.getExpressionFunctionClassStream().flatMap(clazz -> IntrospectionUtils.getApiMethods(clazz).stream()).map(clazz -> new FunctionWrapper((Method)clazz, this.typeLoader)).collect(Collectors.toList());
    }

    @Override
    public Category getCategory() {
        return this.extensionInfo.get().getCategory();
    }

    @Override
    public String getVendor() {
        return this.extensionInfo.get().getVendor();
    }

    @Override
    public String getName() {
        return this.extensionInfo.get().getName();
    }
}

