/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.embedded.impl;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import net.lingala.zip4j.core.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.application.ApplicationDescriptor;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;
import org.mule.runtime.module.deployment.impl.internal.MuleArtifactResourcesRegistry;
import org.mule.runtime.module.embedded.api.ApplicationConfiguration;
import org.mule.runtime.module.embedded.api.ContainerInfo;
import org.mule.runtime.module.embedded.impl.SerializationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedController {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmbeddedController.class);
    private ApplicationConfiguration applicationConfiguration;
    private ContainerInfo containerInfo;
    private Application application;
    private ArtifactClassLoader containerClassLoader;
    private MuleArtifactResourcesRegistry artifactResourcesRegistry;

    public EmbeddedController(byte[] serializedContainerInfo, byte[] serializedAppConfiguration) throws IOException, ClassNotFoundException {
        this.containerInfo = (ContainerInfo)SerializationUtils.deserialize(serializedContainerInfo);
        this.applicationConfiguration = (ApplicationConfiguration)SerializationUtils.deserialize(serializedAppConfiguration);
    }

    public void start() throws Exception {
        this.setUpEnvironment();
        this.createApplication();
        this.application.init();
        this.application.start();
    }

    private void createApplication() throws Exception {
        for (Map.Entry applicationPropertiesEntry : this.applicationConfiguration.getDeploymentConfiguration().getArtifactProperties().entrySet()) {
            System.setProperty((String)applicationPropertiesEntry.getKey(), (String)applicationPropertiesEntry.getValue());
        }
        System.setProperty("mule.mode.embedded", "true");
        if (this.applicationConfiguration.getDeploymentConfiguration().enableTestDependencies()) {
            System.setProperty("mule.embedded.maven.addTestDependenciesToAppClassPath", "true");
        }
        File applicationLocation = this.applicationConfiguration.getApplicationLocation();
        File appsFolder = new File(MuleFoldersUtil.getAppsFolder().getAbsolutePath());
        File deploymentApplicationLocation = new File(appsFolder, applicationLocation.getName().replace(".jar", ""));
        if (applicationLocation.getName().endsWith(".jar")) {
            new ZipFile(applicationLocation).extractAll(appsFolder.getAbsolutePath());
        } else {
            FileUtils.copyDirectory((File)applicationLocation, (File)deploymentApplicationLocation);
        }
        File containerFolder = new File(this.containerInfo.getContainerBaseFolder().getPath());
        File servicesFolder = new File(containerFolder, "services");
        for (URL url : this.containerInfo.getServices()) {
            File originalFile = FileUtils.toFile((URL)url);
            File destinationFile = new File(servicesFolder, FilenameUtils.getName((String)originalFile.getPath()));
            FileUtils.copyFile((File)originalFile, (File)destinationFile);
        }
        this.artifactResourcesRegistry = new MuleArtifactResourcesRegistry.Builder().build();
        this.containerClassLoader = this.artifactResourcesRegistry.getContainerClassLoader();
        this.executeWithinContainerClassLoader(() -> {
            try {
                try {
                    this.artifactResourcesRegistry.getServiceManager().start();
                    this.artifactResourcesRegistry.getExtensionModelLoaderManager().start();
                }
                catch (MuleException e) {
                    throw new IllegalStateException(e);
                }
                ApplicationDescriptor applicationDescriptor = this.artifactResourcesRegistry.getApplicationDescriptorFactory().create(deploymentApplicationLocation);
                this.artifactResourcesRegistry.getDomainFactory().createArtifact(this.createDefaultDomainDir());
                this.application = this.artifactResourcesRegistry.getApplicationFactory().createAppFrom(applicationDescriptor);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void executeWithinContainerClassLoader(ContainerTask task) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.containerClassLoader.getClassLoader());
            task.run();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public void stop() {
        this.executeWithinContainerClassLoader(() -> {
            block6: {
                try {
                    this.application.stop();
                }
                catch (Exception e) {
                    if (!LOGGER.isDebugEnabled()) break block6;
                    LOGGER.debug("failure stopping application", (Throwable)e);
                }
            }
            try {
                this.application.dispose();
            }
            catch (Exception e) {
                LOGGER.debug("failure disposing application", (Throwable)e);
            }
            try {
                org.mule.runtime.core.api.util.FileUtils.deleteTree((File)new File(this.containerInfo.getContainerBaseFolder().getPath()));
            }
            catch (Exception e) {
                LOGGER.debug("failure deleting container directory " + this.containerInfo.getContainerBaseFolder().getPath(), (Throwable)e);
            }
        });
        this.artifactResourcesRegistry = null;
    }

    private void setUpEnvironment() {
        System.setProperty("mule.home", this.containerInfo.getContainerBaseFolder().getPath());
        MuleFoldersUtil.getDomainsFolder().mkdirs();
        MuleFoldersUtil.getServicesFolder().mkdirs();
    }

    private File createDefaultDomainDir() {
        File containerFolder = new File(this.containerInfo.getContainerBaseFolder().getPath());
        File defaultDomainFolder = new File(new File(containerFolder, "domains"), "default");
        if (!defaultDomainFolder.exists() && !defaultDomainFolder.mkdirs()) {
            throw new RuntimeException("Could not create default domain directory in " + defaultDomainFolder.getAbsolutePath());
        }
        return defaultDomainFolder;
    }

    @FunctionalInterface
    static interface ContainerTask {
        public void run() throws Exception;
    }
}

