/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.embedded.impl;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.lingala.zip4j.core.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;
import org.mule.runtime.module.embedded.api.ArtifactConfiguration;
import org.mule.runtime.module.embedded.api.ContainerInfo;
import org.mule.runtime.module.embedded.impl.SerializationUtils;
import org.mule.runtime.module.launcher.MuleContainer;

public class EmbeddedController {
    private ContainerInfo containerInfo;
    private ArtifactClassLoader containerClassLoader;
    private MuleContainer muleContainer;

    public EmbeddedController(byte[] serializedContainerInfo) throws IOException, ClassNotFoundException {
        this.containerInfo = (ContainerInfo)SerializationUtils.deserialize(serializedContainerInfo);
    }

    public void start() throws Exception {
        this.setUpEnvironment();
    }

    public synchronized void deployApplication(byte[] serializedArtifactConfiguration) throws IOException, ClassNotFoundException {
        ArtifactConfiguration artifactConfiguration = (ArtifactConfiguration)SerializationUtils.deserialize(serializedArtifactConfiguration);
        try {
            if (artifactConfiguration.getDeploymentConfiguration().enableTestDependencies()) {
                System.setProperty("mule.embedded.maven.addTestDependenciesToAppClassPath", "true");
            }
            this.muleContainer.getDeploymentService().deploy(artifactConfiguration.getArtifactLocation().toURI());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            System.setProperty("mule.embedded.maven.addTestDependenciesToAppClassPath", "false");
        }
    }

    public void undeployApplication(byte[] serializedApplicationName) throws IOException, ClassNotFoundException {
        String applicationName = (String)SerializationUtils.deserialize(serializedApplicationName);
        this.muleContainer.getDeploymentService().undeploy(applicationName);
    }

    private void withSystemProperties(Map<String, String> systemProperties, Runnable runnable) {
        HashMap previousPropertyValues = new HashMap();
        systemProperties.entrySet().stream().forEach(entry -> {
            String previousValue = System.getProperty((String)entry.getKey());
            if (previousValue != null) {
                previousPropertyValues.put(entry.getKey(), entry.getValue());
            }
            System.setProperty((String)entry.getKey(), (String)entry.getValue());
        });
        try {
            runnable.run();
        }
        catch (Exception e) {
            previousPropertyValues.entrySet().stream().forEach(entry -> System.setProperty((String)entry.getKey(), (String)entry.getValue()));
        }
    }

    public void executeWithinContainerClassLoader(ContainerTask task) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.containerClassLoader.getClassLoader());
            task.run();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public void stop() {
        this.executeWithinContainerClassLoader(() -> {
            this.muleContainer.stop();
            this.muleContainer.getContainerClassLoader().dispose();
        });
    }

    private void setUpEnvironment() throws IOException {
        System.setProperty("log4j2.disable.jmx", "true");
        System.setProperty("mule.home", this.containerInfo.getContainerBaseFolder().getPath());
        MuleFoldersUtil.getDomainsFolder().mkdirs();
        MuleFoldersUtil.getDomainFolder((String)"default").mkdirs();
        MuleFoldersUtil.getServicesFolder().mkdirs();
        MuleFoldersUtil.getServerPluginsFolder().mkdirs();
        MuleFoldersUtil.getConfFolder().mkdirs();
        MuleFoldersUtil.getAppsFolder().mkdirs();
        System.setProperty("mule.mode.embedded", "true");
        for (URL url : this.containerInfo.getServices()) {
            File originalFile = FileUtils.toFile((URL)url);
            File destinationFile = new File(MuleFoldersUtil.getServicesFolder(), FilenameUtils.getName((String)originalFile.getPath()));
            FileUtils.copyFile((File)originalFile, (File)destinationFile);
        }
        this.containerInfo.getServerPlugins().stream().forEach(serverPluginUrl -> {
            File originalFile = FileUtils.toFile((URL)serverPluginUrl);
            File destinationFile = new File(MuleFoldersUtil.getServerPluginsFolder(), FilenameUtils.getName((String)originalFile.getPath()).replace(".zip", ""));
            try {
                ZipFile zipFile = new ZipFile(originalFile);
                zipFile.extractAll(destinationFile.getAbsolutePath());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        this.muleContainer = new MuleContainer(new String[0]);
        this.containerClassLoader = this.muleContainer.getContainerClassLoader();
        this.executeWithinContainerClassLoader(() -> {
            try {
                this.muleContainer.start(false);
            }
            catch (MuleException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    @FunctionalInterface
    static interface ContainerTask {
        public void run() throws Exception;
    }
}

