/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.embedded.impl;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;
import net.lingala.zip4j.ZipFile;
import org.apache.commons.io.FilenameUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.embedded.api.ArtifactConfiguration;
import org.mule.runtime.module.embedded.api.ContainerInfo;
import org.mule.runtime.module.embedded.impl.PathUtils;
import org.mule.runtime.module.embedded.impl.util.FileUtils;
import org.mule.runtime.module.embedded.impl.util.ZipUtils;
import org.mule.runtime.module.launcher.DefaultMuleContainer;

public class CommonsEmbeddedController {
    private final ContainerInfo containerInfo;
    private ArtifactClassLoader containerClassLoader;
    private DefaultMuleContainer muleContainer;

    public CommonsEmbeddedController(ContainerInfo containerInfo) {
        this.containerInfo = containerInfo;
    }

    public void start() throws Exception {
        this.setUpEnvironment();
    }

    public synchronized void deployApplication(ArtifactConfiguration artifactConfiguration) {
        this.deployArtifactTemplateMethod(artifactConfiguration, deploymentProperties -> this.getMuleContainer().getDeploymentService().deploy(artifactConfiguration.getArtifactLocation().toURI(), deploymentProperties));
    }

    public void undeployApplication(String applicationName) {
        this.getMuleContainer().getDeploymentService().undeploy(applicationName);
    }

    public synchronized void deployDomain(ArtifactConfiguration artifactConfiguration) {
        this.deployArtifactTemplateMethod(artifactConfiguration, deploymentProperties -> this.getMuleContainer().getDeploymentService().deployDomain(artifactConfiguration.getArtifactLocation().toURI(), deploymentProperties));
    }

    public void undeployDomain(String domainName) {
        this.getMuleContainer().getDeploymentService().undeployDomain(domainName);
    }

    private void deployArtifactTemplateMethod(ArtifactConfiguration artifactConfiguration, DeploymentTask deploymentTask) {
        String forceParseConfigXmlsOnDeploymentOriginalValue = System.getProperty("mule.deployment.forceParseConfigXmls");
        System.setProperty("mule.deployment.forceParseConfigXmls", "true");
        try {
            this.getMuleContainer().getDeploymentService().getLock().lock();
            Properties deploymentProperties = new Properties();
            deploymentProperties.put("mule.application.deployment.lazyInit", String.valueOf(artifactConfiguration.getDeploymentConfiguration().lazyInitializationEnabled()));
            deploymentProperties.put("mule.application.deployment.lazyInit.enableXmlValidations", String.valueOf(artifactConfiguration.getDeploymentConfiguration().xmlValidationsEnabled()));
            deploymentProperties.put("mule.application.deployment.lazyConnections", String.valueOf(artifactConfiguration.getDeploymentConfiguration().lazyConnectionsEnabled()));
            deploymentProperties.put("mule.application.deployment.addToolingObjectsToRegistry", String.valueOf(!artifactConfiguration.getDeploymentConfiguration().doNotAddToolingObjectsToRegistry()));
            deploymentProperties.put("mule.application.deployment.addArtifactAstToRegistry", String.valueOf(artifactConfiguration.getDeploymentConfiguration().addArtifactAstToRegistry()));
            deploymentTask.deploy(deploymentProperties);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (this.getMuleContainer().getDeploymentService().getLock().isHeldByCurrentThread()) {
                this.getMuleContainer().getDeploymentService().getLock().unlock();
            }
            if (forceParseConfigXmlsOnDeploymentOriginalValue == null) {
                System.clearProperty("mule.deployment.forceParseConfigXmls");
            } else {
                System.setProperty("mule.deployment.forceParseConfigXmls", forceParseConfigXmlsOnDeploymentOriginalValue);
            }
        }
    }

    public void stop() {
        if (this.muleContainer == null) {
            return;
        }
        this.executeWithinContainerClassLoader(() -> {
            this.muleContainer.stop();
            this.muleContainer.getContainerClassLoader().dispose();
        });
    }

    private void executeWithinContainerClassLoader(ContainerTask task) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.containerClassLoader.getClass().getClassLoader());
            task.run();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private void setUpEnvironment() throws IOException, URISyntaxException, InitialisationException {
        System.setProperty("log4j2.disable.jmx", "true");
        System.setProperty("mule.home", PathUtils.getPath(this.containerInfo.getContainerBaseFolder()));
        MuleFoldersUtil.getDomainsFolder().mkdirs();
        MuleFoldersUtil.getDomainFolder((String)"default").mkdirs();
        MuleFoldersUtil.getServicesFolder().mkdirs();
        MuleFoldersUtil.getServerPluginsFolder().mkdirs();
        MuleFoldersUtil.getConfFolder().mkdirs();
        MuleFoldersUtil.getAppsFolder().mkdirs();
        for (URL url : this.containerInfo.getServices()) {
            File destinationFile;
            File originalFile = org.apache.commons.io.FileUtils.toFile((URL)url);
            if (originalFile.isDirectory()) {
                destinationFile = new File(MuleFoldersUtil.getServicesFolder(), originalFile.getName());
                FileUtils.copyFolder(originalFile.toPath(), destinationFile.toPath());
                continue;
            }
            destinationFile = new File(MuleFoldersUtil.getServicesFolder(), FilenameUtils.getName((String)originalFile.getPath()).replaceAll("-mule-service\\.jar", ""));
            destinationFile.mkdirs();
            ZipUtils.unzip(originalFile, destinationFile);
        }
        this.containerInfo.getServerPlugins().stream().forEach(serverPluginUrl -> {
            File originalFile = org.apache.commons.io.FileUtils.toFile((URL)serverPluginUrl);
            if (originalFile.isDirectory()) {
                File destinationFile = new File(MuleFoldersUtil.getServerPluginsFolder(), originalFile.getName());
                try {
                    FileUtils.copyFolder(originalFile.toPath(), destinationFile.toPath());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            File destinationFile = new File(MuleFoldersUtil.getServerPluginsFolder(), FilenameUtils.getName((String)originalFile.getPath()).replace(".zip", ""));
            try (ZipFile zipFile = new ZipFile(originalFile);){
                zipFile.extractAll(destinationFile.getAbsolutePath());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        this.muleContainer = new DefaultMuleContainer();
        this.containerClassLoader = this.muleContainer.getContainerClassLoader();
        this.executeWithinContainerClassLoader(() -> {
            try {
                this.muleContainer.start(false);
            }
            catch (MuleException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    protected DefaultMuleContainer getMuleContainer() {
        return this.muleContainer;
    }

    @FunctionalInterface
    static interface DeploymentTask {
        public void deploy(Properties var1) throws IOException;
    }

    private static interface ContainerTask {
        public void run() throws Exception;
    }
}

