/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.embedded.impl;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.embedded.api.ArtifactConfiguration;
import org.mule.runtime.module.embedded.api.ContainerInfo;
import org.mule.runtime.module.embedded.api.DeploymentConfiguration;
import org.mule.runtime.module.embedded.api.controller.EmbeddedController;
import org.mule.runtime.module.embedded.impl.DefaultEmbeddedController;
import org.mule.runtime.module.launcher.DefaultMuleContainer;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="Embedded API")
@Story(value="Embedded")
public class EmbeddedControllerDeploymentPropertiesTestCase
extends AbstractMuleTestCase {
    private DeploymentService deploymentService;
    private EmbeddedController embeddedController;

    @Before
    public void setUp() throws IOException {
        this.deploymentService = (DeploymentService)Mockito.mock(DeploymentService.class);
        Mockito.when((Object)this.deploymentService.getLock()).thenReturn((Object)new ReentrantLock());
        ContainerInfo containerInfo = new ContainerInfo("4.1.1", MuleFoldersUtil.getMuleHomeFolder().toURI().toURL(), Collections.emptyList(), Collections.emptyList());
        this.embeddedController = new DefaultEmbeddedController(containerInfo){

            public void start() throws Exception {
            }

            public void stop() {
            }

            protected DefaultMuleContainer getMuleContainer() {
                DefaultMuleContainer container = (DefaultMuleContainer)Mockito.mock(DefaultMuleContainer.class);
                Mockito.when((Object)container.getDeploymentService()).thenReturn((Object)EmbeddedControllerDeploymentPropertiesTestCase.this.deploymentService);
                return container;
            }
        };
    }

    @Test
    public void lazyInitializationFalseDeploymentConfigurationForwardedToDeploymentProperties() throws IOException {
        ArgumentCaptor deploymentPropertiesCaptor = ArgumentCaptor.forClass(Properties.class);
        this.deployWithProperties(b -> b.lazyInitialization(false), (ArgumentCaptor<Properties>)deploymentPropertiesCaptor);
        MatcherAssert.assertThat((Object)((Properties)deploymentPropertiesCaptor.getValue()).get("mule.application.deployment.lazyInit"), (Matcher)Matchers.is((Object)"false"));
    }

    @Test
    public void lazyInitializationTrueDeploymentConfigurationForwardedToDeploymentProperties() throws IOException {
        ArgumentCaptor deploymentPropertiesCaptor = ArgumentCaptor.forClass(Properties.class);
        this.deployWithProperties(b -> b.lazyInitialization(true), (ArgumentCaptor<Properties>)deploymentPropertiesCaptor);
        MatcherAssert.assertThat((Object)((Properties)deploymentPropertiesCaptor.getValue()).get("mule.application.deployment.lazyInit"), (Matcher)Matchers.is((Object)"true"));
    }

    @Test
    public void lazyConnectionsEnabledFalseDeploymentConfigurationForwardedToDeploymentProperties() throws IOException {
        ArgumentCaptor deploymentPropertiesCaptor = ArgumentCaptor.forClass(Properties.class);
        this.deployWithProperties(b -> b.lazyConnectionsEnabled(false), (ArgumentCaptor<Properties>)deploymentPropertiesCaptor);
        MatcherAssert.assertThat((Object)((Properties)deploymentPropertiesCaptor.getValue()).get("mule.application.deployment.lazyConnections"), (Matcher)Matchers.is((Object)"false"));
    }

    @Test
    public void lazyConnectionsEnabledTrueDeploymentConfigurationForwardedToDeploymentProperties() throws IOException {
        ArgumentCaptor deploymentPropertiesCaptor = ArgumentCaptor.forClass(Properties.class);
        this.deployWithProperties(b -> b.lazyConnectionsEnabled(true), (ArgumentCaptor<Properties>)deploymentPropertiesCaptor);
        MatcherAssert.assertThat((Object)((Properties)deploymentPropertiesCaptor.getValue()).get("mule.application.deployment.lazyConnections"), (Matcher)Matchers.is((Object)"true"));
    }

    @Test
    public void xmlValidationsFalseDeploymentConfigurationForwardedToDeploymentProperties() throws IOException {
        ArgumentCaptor deploymentPropertiesCaptor = ArgumentCaptor.forClass(Properties.class);
        this.deployWithProperties(b -> b.xmlValidations(false), (ArgumentCaptor<Properties>)deploymentPropertiesCaptor);
        MatcherAssert.assertThat((Object)((Properties)deploymentPropertiesCaptor.getValue()).get("mule.application.deployment.lazyInit.enableXmlValidations"), (Matcher)Matchers.is((Object)"false"));
    }

    @Test
    public void xmlValidationsTrueDeploymentConfigurationForwardedToDeploymentProperties() throws IOException {
        ArgumentCaptor deploymentPropertiesCaptor = ArgumentCaptor.forClass(Properties.class);
        this.deployWithProperties(b -> b.xmlValidations(true), (ArgumentCaptor<Properties>)deploymentPropertiesCaptor);
        MatcherAssert.assertThat((Object)((Properties)deploymentPropertiesCaptor.getValue()).get("mule.application.deployment.lazyInit.enableXmlValidations"), (Matcher)Matchers.is((Object)"true"));
    }

    @Test
    public void toolingObjectsNotToRegistryFalseDeploymentConfigurationForwardedToDeploymentProperties() throws IOException {
        ArgumentCaptor deploymentPropertiesCaptor = ArgumentCaptor.forClass(Properties.class);
        this.deployWithProperties(b -> b.doNotAddToolingObjectsToRegistry(false), (ArgumentCaptor<Properties>)deploymentPropertiesCaptor);
        MatcherAssert.assertThat((Object)((Properties)deploymentPropertiesCaptor.getValue()).get("mule.application.deployment.addToolingObjectsToRegistry"), (Matcher)Matchers.is((Object)"true"));
    }

    @Test
    public void toolingObjectsNotToRegistryTrueDeploymentConfigurationForwardedToDeploymentProperties() throws IOException {
        ArgumentCaptor deploymentPropertiesCaptor = ArgumentCaptor.forClass(Properties.class);
        this.deployWithProperties(b -> b.doNotAddToolingObjectsToRegistry(true), (ArgumentCaptor<Properties>)deploymentPropertiesCaptor);
        MatcherAssert.assertThat((Object)((Properties)deploymentPropertiesCaptor.getValue()).get("mule.application.deployment.addToolingObjectsToRegistry"), (Matcher)Matchers.is((Object)"false"));
    }

    @Test
    public void artifactAstFalseDeploymentConfigurationForwardedToDeploymentProperties() throws IOException {
        ArgumentCaptor deploymentPropertiesCaptor = ArgumentCaptor.forClass(Properties.class);
        this.deployWithProperties(b -> b.addArtifactAstToRegistry(false), (ArgumentCaptor<Properties>)deploymentPropertiesCaptor);
        MatcherAssert.assertThat((Object)((Properties)deploymentPropertiesCaptor.getValue()).get("mule.application.deployment.addArtifactAstToRegistry"), (Matcher)Matchers.is((Object)"false"));
    }

    @Test
    public void artifactAstTrueDeploymentConfigurationForwardedToDeploymentProperties() throws IOException {
        ArgumentCaptor deploymentPropertiesCaptor = ArgumentCaptor.forClass(Properties.class);
        this.deployWithProperties(b -> b.addArtifactAstToRegistry(true), (ArgumentCaptor<Properties>)deploymentPropertiesCaptor);
        MatcherAssert.assertThat((Object)((Properties)deploymentPropertiesCaptor.getValue()).get("mule.application.deployment.addArtifactAstToRegistry"), (Matcher)Matchers.is((Object)"true"));
    }

    @Test
    public void defaultDeploymentProperties() throws IOException {
        ArgumentCaptor deploymentPropertiesCaptor = ArgumentCaptor.forClass(Properties.class);
        this.deployWithProperties(b -> {}, (ArgumentCaptor<Properties>)deploymentPropertiesCaptor);
        MatcherAssert.assertThat((Object)((Properties)deploymentPropertiesCaptor.getValue()).get("mule.application.deployment.lazyInit"), (Matcher)Matchers.is((Object)"false"));
        MatcherAssert.assertThat((Object)((Properties)deploymentPropertiesCaptor.getValue()).get("mule.application.deployment.lazyConnections"), (Matcher)Matchers.is((Object)"false"));
        MatcherAssert.assertThat((Object)((Properties)deploymentPropertiesCaptor.getValue()).get("mule.application.deployment.lazyInit.enableXmlValidations"), (Matcher)Matchers.is((Object)"false"));
        MatcherAssert.assertThat((Object)((Properties)deploymentPropertiesCaptor.getValue()).get("mule.application.deployment.addToolingObjectsToRegistry"), (Matcher)Matchers.is((Object)"true"));
        MatcherAssert.assertThat((Object)((Properties)deploymentPropertiesCaptor.getValue()).get("mule.application.deployment.addArtifactAstToRegistry"), (Matcher)Matchers.is((Object)"false"));
    }

    protected void deployWithProperties(Consumer<DeploymentConfiguration.DeploymentConfigurationBuilder> deploymentConfigBuilderConfigurer, ArgumentCaptor<Properties> deploymentPropertiesCaptor) throws IOException {
        DeploymentConfiguration.DeploymentConfigurationBuilder deploymentConfigBuilder = DeploymentConfiguration.builder();
        deploymentConfigBuilderConfigurer.accept(deploymentConfigBuilder);
        this.embeddedController.deployApplication(ArtifactConfiguration.builder().artifactLocation(new File("")).deploymentConfiguration(deploymentConfigBuilder.build()).build());
        ((DeploymentService)Mockito.verify((Object)this.deploymentService)).deploy((URI)ArgumentMatchers.any(URI.class), (Properties)deploymentPropertiesCaptor.capture());
    }
}

