/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.embedded.impl;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Issues;
import io.qameta.allure.Story;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.lang3.SystemUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.module.embedded.impl.PathUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="Embedded API")
@Story(value="Embedded")
@Issues(value={@Issue(value="W-11193698"), @Issue(value="MULE-14428")})
public class PathUtilsTestCase
extends AbstractMuleTestCase {
    private static final URL URL_WITHOUT_SPACES = PathUtilsTestCase.getUrlWithoutSpaces();
    private static final URL URL_WITH_SPACES = PathUtilsTestCase.getUrlWithSpaces();
    private static final String EXPECTED_PATH_WITH_SPACES = PathUtilsTestCase.getExpectedPathWithSpaces();
    private static final String EXPECTED_PATH_WITHOUT_SPACES = PathUtilsTestCase.getExpectedPathWithoutSpaces();

    @Test
    public void pathFromURLWithSpaces() throws URISyntaxException {
        Assert.assertThat((Object)PathUtils.getPath((URL)URL_WITH_SPACES), (Matcher)Matchers.is((Object)EXPECTED_PATH_WITH_SPACES));
    }

    @Test
    public void pathFromURLWithoutSpaces() throws URISyntaxException {
        Assert.assertThat((Object)PathUtils.getPath((URL)URL_WITHOUT_SPACES), (Matcher)Matchers.is((Object)EXPECTED_PATH_WITHOUT_SPACES));
    }

    private static String getExpectedPathWithSpaces() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return "C:\\Hello World";
        }
        return "/Hello World";
    }

    private static String getExpectedPathWithoutSpaces() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return "C:\\Hello\\World";
        }
        return "/Hello/World";
    }

    private static URL getUrlWithoutSpaces() {
        try {
            if (SystemUtils.IS_OS_WINDOWS) {
                return new URL("file:/C:/Hello/World");
            }
            return new URL("file:/Hello/World");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private static URL getUrlWithSpaces() {
        try {
            if (SystemUtils.IS_OS_WINDOWS) {
                return new URL("file:///C:/Hello%20World");
            }
            return new URL("file:///Hello%20World");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

