/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.embedded.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;
import net.lingala.zip4j.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.embedded.api.ArtifactConfiguration;
import org.mule.runtime.module.embedded.api.ContainerInfo;
import org.mule.runtime.module.embedded.impl.PathUtils;
import org.mule.runtime.module.launcher.DefaultMuleContainer;

@Deprecated
public class EmbeddedController {
    private final ContainerInfo containerInfo;
    private ArtifactClassLoader containerClassLoader;
    private DefaultMuleContainer muleContainer;

    public EmbeddedController(byte[] serializedContainerInfo) throws IOException, ClassNotFoundException {
        this.containerInfo = (ContainerInfo)this.deserialize(serializedContainerInfo);
    }

    public void start() throws Exception {
        this.setUpEnvironment();
    }

    public synchronized void deployApplication(byte[] serializedArtifactConfiguration) throws IOException, ClassNotFoundException {
        ArtifactConfiguration artifactConfiguration = (ArtifactConfiguration)this.deserialize(serializedArtifactConfiguration);
        this.deployArtifactTemplateMethod(artifactConfiguration, deploymentProperties -> this.getMuleContainer().getDeploymentService().deploy(artifactConfiguration.getArtifactLocation().toURI(), deploymentProperties));
    }

    public void undeployApplication(byte[] serializedApplicationName) throws IOException, ClassNotFoundException {
        String applicationName = (String)this.deserialize(serializedApplicationName);
        this.getMuleContainer().getDeploymentService().undeploy(applicationName);
    }

    public synchronized void deployDomain(byte[] serializedArtifactConfiguration) throws IOException, ClassNotFoundException {
        ArtifactConfiguration artifactConfiguration = (ArtifactConfiguration)this.deserialize(serializedArtifactConfiguration);
        this.deployArtifactTemplateMethod(artifactConfiguration, deploymentProperties -> this.getMuleContainer().getDeploymentService().deployDomain(artifactConfiguration.getArtifactLocation().toURI(), deploymentProperties));
    }

    public void undeployDomain(byte[] serializedApplicationName) throws IOException, ClassNotFoundException {
        String applicationName = (String)this.deserialize(serializedApplicationName);
        this.getMuleContainer().getDeploymentService().undeployDomain(applicationName);
    }

    private void deployArtifactTemplateMethod(ArtifactConfiguration artifactConfiguration, DeploymentTask deploymentTask) {
        String forceParseConfigXmlsOnDeploymentOriginalValue = System.getProperty("mule.deployment.forceParseConfigXmls");
        System.setProperty("mule.deployment.forceParseConfigXmls", "true");
        try {
            this.getMuleContainer().getDeploymentService().getLock().lock();
            Properties deploymentProperties = new Properties();
            deploymentProperties.put("mule.application.deployment.lazyInit", String.valueOf(artifactConfiguration.getDeploymentConfiguration().lazyInitializationEnabled()));
            deploymentProperties.put("mule.application.deployment.lazyInit.enableXmlValidations", String.valueOf(artifactConfiguration.getDeploymentConfiguration().xmlValidationsEnabled()));
            deploymentProperties.put("mule.application.deployment.lazyConnections", String.valueOf(artifactConfiguration.getDeploymentConfiguration().lazyConnectionsEnabled()));
            deploymentProperties.put("mule.application.deployment.addToolingObjectsToRegistry", String.valueOf(!artifactConfiguration.getDeploymentConfiguration().doNotAddToolingObjectsToRegistry()));
            deploymentProperties.put("mule.application.deployment.addArtifactAstToRegistry", String.valueOf(artifactConfiguration.getDeploymentConfiguration().addArtifactAstToRegistry()));
            deploymentTask.deploy(deploymentProperties);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (this.getMuleContainer().getDeploymentService().getLock().isHeldByCurrentThread()) {
                this.getMuleContainer().getDeploymentService().getLock().unlock();
            }
            if (forceParseConfigXmlsOnDeploymentOriginalValue == null) {
                System.clearProperty("mule.deployment.forceParseConfigXmls");
            } else {
                System.setProperty("mule.deployment.forceParseConfigXmls", forceParseConfigXmlsOnDeploymentOriginalValue);
            }
        }
    }

    public void executeWithinContainerClassLoader(ContainerTask task) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.containerClassLoader.getClassLoader());
            task.run();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public void stop() {
        this.executeWithinContainerClassLoader(() -> {
            this.muleContainer.stop();
            this.muleContainer.getContainerClassLoader().dispose();
        });
    }

    private void setUpEnvironment() throws IOException, URISyntaxException, InitialisationException {
        System.setProperty("log4j2.disable.jmx", "true");
        System.setProperty("mule.home", PathUtils.getPath(this.containerInfo.getContainerBaseFolder()));
        MuleFoldersUtil.getDomainsFolder().mkdirs();
        MuleFoldersUtil.getDomainFolder((String)"default").mkdirs();
        MuleFoldersUtil.getServicesFolder().mkdirs();
        MuleFoldersUtil.getServerPluginsFolder().mkdirs();
        MuleFoldersUtil.getConfFolder().mkdirs();
        MuleFoldersUtil.getAppsFolder().mkdirs();
        System.setProperty("mule.mode.embedded", "true");
        for (URL url : this.containerInfo.getServices()) {
            File originalFile = FileUtils.toFile((URL)url);
            File destinationFile = new File(MuleFoldersUtil.getServicesFolder(), FilenameUtils.getName((String)originalFile.getPath()).replaceAll("-mule-service\\.jar", ""));
            destinationFile.mkdirs();
            org.mule.runtime.core.api.util.FileUtils.unzip((File)originalFile, (File)destinationFile, (boolean)false);
        }
        this.containerInfo.getServerPlugins().stream().forEach(serverPluginUrl -> {
            File originalFile = FileUtils.toFile((URL)serverPluginUrl);
            File destinationFile = new File(MuleFoldersUtil.getServerPluginsFolder(), FilenameUtils.getName((String)originalFile.getPath()).replace(".zip", ""));
            try (ZipFile zipFile = new ZipFile(originalFile);){
                zipFile.extractAll(destinationFile.getAbsolutePath());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        this.muleContainer = new DefaultMuleContainer();
        this.containerClassLoader = this.muleContainer.getContainerClassLoader();
        this.executeWithinContainerClassLoader(() -> {
            try {
                this.muleContainer.start(false);
            }
            catch (MuleException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    protected DefaultMuleContainer getMuleContainer() {
        return this.muleContainer;
    }

    private <T> T deserialize(byte[] object) throws IOException, ClassNotFoundException {
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(object);){
            Object object2;
            try (ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);){
                object2 = objectInputStream.readObject();
            }
            return (T)object2;
        }
    }

    @FunctionalInterface
    static interface DeploymentTask {
        public void deploy(Properties var1) throws IOException;
    }

    @FunctionalInterface
    static interface ContainerTask {
        public void run() throws Exception;
    }
}

