/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.embedded;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.function.Consumer;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.model.ZipParameters;
import org.apache.commons.io.FileUtils;
import org.junit.rules.TemporaryFolder;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.api.model.RemoteRepository;
import org.mule.maven.client.test.MavenTestHelper;
import org.mule.runtime.module.embedded.api.ContainerConfiguration;
import org.mule.runtime.module.embedded.api.EmbeddedContainer;
import org.mule.runtime.module.embedded.internal.classloading.FilteringClassLoader;
import org.mule.runtime.module.embedded.internal.classloading.JdkOnlyClassLoaderFactory;

public class EmbeddedTestHelper {
    private final TemporaryFolder temporaryFolder;
    private final boolean enterprise;
    private final boolean forceUpdateSnapshots;
    private boolean ignoreArtifactDescriptorRepositories = false;
    private File containerFolder;
    private EmbeddedContainer container;

    public EmbeddedTestHelper(boolean enterprise, boolean forceUpdateSnapshots, boolean ignoreArtifactDescriptorRepositories) {
        try {
            this.temporaryFolder = new TemporaryFolder();
            this.temporaryFolder.create();
            this.enterprise = enterprise;
            this.forceUpdateSnapshots = forceUpdateSnapshots;
            this.ignoreArtifactDescriptorRepositories = ignoreArtifactDescriptorRepositories;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void recreateContainerFolder() {
        try {
            this.containerFolder = this.temporaryFolder.newFolder();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test(Runnable runnable) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            FilteringClassLoader jdkOnlyClassLoader = JdkOnlyClassLoaderFactory.create((ClassLoader)EmbeddedTestHelper.class.getClassLoader());
            Thread.currentThread().setContextClassLoader((ClassLoader)jdkOnlyClassLoader);
            runnable.run();
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public void testWithDefaultSettings(Consumer<EmbeddedContainer.EmbeddedContainerBuilder> embeddedContainerConfigurer, Consumer<EmbeddedContainer> test) {
        this.testWithEmbeddedNotStarted(embeddedContainerConfigurer, embeddedContainer -> {
            try {
                embeddedContainer.start();
                test.accept(this.container);
            }
            finally {
                if (embeddedContainer != null) {
                    try {
                        embeddedContainer.stop();
                        FileUtils.deleteDirectory((File)this.containerFolder);
                    }
                    catch (Throwable throwable) {}
                }
            }
        });
    }

    public void testWithEmbeddedNotStarted(Consumer<EmbeddedContainer.EmbeddedContainerBuilder> embeddedContainerConfigurer, Consumer<EmbeddedContainer> test) {
        this.test(() -> {
            EmbeddedContainer.EmbeddedContainerBuilder embeddedContainerBuilder;
            try {
                this.recreateContainerFolder();
                MavenConfiguration.MavenConfigurationBuilder mavenConfigurationBuilder = this.enterprise ? MavenTestHelper.createDefaultEnterpriseMavenConfigurationBuilder((boolean)this.forceUpdateSnapshots) : MavenTestHelper.createDefaultCommunityMavenConfigurationBuilder((boolean)this.forceUpdateSnapshots);
                mavenConfigurationBuilder.ignoreArtifactDescriptorRepositories(this.ignoreArtifactDescriptorRepositories);
                embeddedContainerBuilder = EmbeddedContainer.builder().muleVersion(System.getProperty("mule.version")).containerConfiguration(ContainerConfiguration.builder().containerFolder(this.containerFolder).build()).mavenConfiguration(mavenConfigurationBuilder.remoteRepository(RemoteRepository.newRemoteRepositoryBuilder().id("local.repo").url(MavenTestHelper.getLocalRepositoryFolder().toURI().toURL()).build()).build());
                embeddedContainerConfigurer.accept(embeddedContainerBuilder);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.container = null;
            this.container = embeddedContainerBuilder.build();
            test.accept(this.container);
        });
    }

    public File getContainerFolder() {
        return this.containerFolder;
    }

    public void dispose() {
        this.temporaryFolder.delete();
    }

    public File getPackagedApplication(File applicationFolder) throws Exception {
        File[] files;
        File compressedFile = this.temporaryFolder.newFile(applicationFolder.getName());
        ZipFile zipFile = new ZipFile(compressedFile.getAbsolutePath() + ".jar");
        for (File file : files = applicationFolder.listFiles()) {
            if (file.isDirectory()) {
                zipFile.addFolder(file, new ZipParameters());
                continue;
            }
            zipFile.addFile(file, new ZipParameters());
        }
        return zipFile.getFile();
    }

    public File getFolderForApplication(String applicationFolderName) {
        return FileUtils.toFile((URL)this.getClass().getClassLoader().getResource(Paths.get("artifacts", "apps", applicationFolderName).toString()));
    }

    public File getFolderForDomain(String domainFolderName) {
        return FileUtils.toFile((URL)this.getClass().getClassLoader().getResource(Paths.get("artifacts", "domains", domainFolderName).toString()));
    }

    public EmbeddedContainer getContainer() {
        return this.container;
    }
}

