/*
 * Decompiled with CFR 0.152.
 */
package org.mule.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.OptimizedRequestContext;
import org.mule.VoidResult;
import org.mule.api.AnnotatedObject;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.component.Component;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.MuleContextAware;
import org.mule.api.context.notification.ServerNotificationHandler;
import org.mule.api.interceptor.Interceptor;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Lifecycle;
import org.mule.api.lifecycle.LifecycleCallback;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorChain;
import org.mule.api.service.Service;
import org.mule.component.ComponentException;
import org.mule.component.ComponentLifecycleManager;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.construct.SimpleService;
import org.mule.context.notification.ComponentMessageNotification;
import org.mule.context.notification.OptimisedNotificationHandler;
import org.mule.management.stats.ComponentStatistics;
import org.mule.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.transformer.TransformerTemplate;
import org.mule.transport.NullPayload;
import org.mule.util.ClassUtils;

public abstract class AbstractComponent
implements Component,
MuleContextAware,
Lifecycle,
AnnotatedObject {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected FlowConstruct flowConstruct;
    protected ComponentStatistics statistics = null;
    protected ServerNotificationHandler notificationHandler;
    protected List<Interceptor> interceptors = new ArrayList<Interceptor>();
    protected MessageProcessorChain interceptorChain;
    protected MuleContext muleContext;
    protected ComponentLifecycleManager lifecycleManager;
    private final Map<QName, Object> annotations = new ConcurrentHashMap<QName, Object>();

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public List<Interceptor> getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(List<Interceptor> interceptors) {
        this.interceptors = interceptors;
    }

    public AbstractComponent() {
        this.statistics = new ComponentStatistics();
        this.lifecycleManager = new ComponentLifecycleManager(this.getName(), this);
    }

    private MuleEvent invokeInternal(MuleEvent event) throws MuleException {
        OptimizedRequestContext.unsafeSetEvent(event);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)String.format("Invoking %s component for service %s", this.getClass().getName(), this.flowConstruct.getName()));
        }
        if (!this.lifecycleManager.getState().isStarted() || this.lifecycleManager.getState().isStopping()) {
            throw new LifecycleException(CoreMessages.isStopped(this.flowConstruct.getName()), (Object)this);
        }
        try {
            this.fireComponentNotification(event.getMessage(), 1401);
            long startTime = 0L;
            if (this.statistics.isEnabled()) {
                startTime = System.currentTimeMillis();
            }
            Object result = this.doInvoke(event);
            if (this.statistics.isEnabled()) {
                this.statistics.addExecutionTime(System.currentTimeMillis() - startTime);
            }
            MuleEvent resultEvent = this.createResultEvent(event, result);
            resultEvent.setStopFurtherProcessing(event.isStopFurtherProcessing());
            this.fireComponentNotification(resultEvent.getMessage(), 1402);
            return resultEvent;
        }
        catch (MuleException me) {
            throw me;
        }
        catch (Exception e) {
            throw new ComponentException(CoreMessages.failedToInvoke(this.toString()), event, this, e);
        }
    }

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        if (this.interceptorChain == null) {
            return this.invokeInternal(event);
        }
        return this.interceptorChain.process(event);
    }

    protected MuleEvent createResultEvent(MuleEvent event, Object result) throws MuleException {
        if (result instanceof MuleMessage) {
            return new DefaultMuleEvent((MuleMessage)result, event);
        }
        if (result instanceof VoidResult) {
            return event;
        }
        if (result != null) {
            event.getMessage().applyTransformers(event, Collections.singletonList(new TransformerTemplate(new TransformerTemplate.OverwitePayloadCallback(result))));
            return event;
        }
        DefaultMuleMessage emptyMessage = new DefaultMuleMessage(NullPayload.getInstance(), this.muleContext);
        emptyMessage.propagateRootId(event.getMessage());
        return new DefaultMuleEvent(emptyMessage, event);
    }

    protected abstract Object doInvoke(MuleEvent var1) throws Exception;

    public String toString() {
        return String.format("%s{%s}", ClassUtils.getSimpleName(this.getClass()), this.getName());
    }

    public void release() {
    }

    @Override
    public ComponentStatistics getStatistics() {
        return this.statistics;
    }

    @Override
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }

    public FlowConstruct getFlowConstruct() {
        return this.flowConstruct;
    }

    @Override
    public final void initialise() throws InitialisationException {
        if (this.flowConstruct == null) {
            throw new InitialisationException(MessageFactory.createStaticMessage("Component has not been initialized properly, no flow constuct."), (Initialisable)this);
        }
        this.lifecycleManager.fireInitialisePhase(new LifecycleCallback<Component>(){

            @Override
            public void onTransition(String phaseName, Component object) throws MuleException {
                DefaultMessageProcessorChainBuilder chainBuilder = new DefaultMessageProcessorChainBuilder(AbstractComponent.this.flowConstruct);
                chainBuilder.setName("Component interceptor processor chain for :" + AbstractComponent.this.getName());
                for (Interceptor interceptor : AbstractComponent.this.interceptors) {
                    chainBuilder.chain(interceptor);
                }
                chainBuilder.chain(new MessageProcessor(){

                    @Override
                    public MuleEvent process(MuleEvent event) throws MuleException {
                        return AbstractComponent.this.invokeInternal(event);
                    }
                });
                AbstractComponent.this.interceptorChain = chainBuilder.build();
                if (AbstractComponent.this.interceptorChain instanceof MuleContextAware) {
                    ((MuleContextAware)((Object)AbstractComponent.this.interceptorChain)).setMuleContext(AbstractComponent.this.muleContext);
                }
                if (AbstractComponent.this.interceptorChain instanceof Initialisable) {
                    ((Initialisable)((Object)AbstractComponent.this.interceptorChain)).initialise();
                }
                AbstractComponent.this.doInitialise();
            }
        });
    }

    protected void doInitialise() throws InitialisationException {
    }

    @Override
    public void dispose() {
        this.lifecycleManager.fireDisposePhase(new LifecycleCallback<Component>(){

            @Override
            public void onTransition(String phaseName, Component object) throws MuleException {
                AbstractComponent.this.doDispose();
            }
        });
    }

    protected void doDispose() {
    }

    @Override
    public void stop() throws MuleException {
        try {
            this.lifecycleManager.fireStopPhase(new LifecycleCallback<Component>(){

                @Override
                public void onTransition(String phaseName, Component object) throws MuleException {
                    AbstractComponent.this.doStop();
                }
            });
        }
        catch (MuleException e) {
            e.printStackTrace();
            throw e;
        }
    }

    protected void doStart() throws MuleException {
    }

    @Override
    public void start() throws MuleException {
        this.lifecycleManager.fireStartPhase(new LifecycleCallback<Component>(){

            @Override
            public void onTransition(String phaseName, Component object) throws MuleException {
                AbstractComponent.this.notificationHandler = new OptimisedNotificationHandler(AbstractComponent.this.muleContext.getNotificationManager(), ComponentMessageNotification.class);
                AbstractComponent.this.doStart();
            }
        });
    }

    protected void doStop() throws MuleException {
    }

    protected void fireComponentNotification(MuleMessage message, int action) {
        if (this.notificationHandler != null && this.notificationHandler.isNotificationEnabled(ComponentMessageNotification.class)) {
            this.notificationHandler.fireNotification(new ComponentMessageNotification(message, this, this.flowConstruct, action));
        }
    }

    protected String getName() {
        StringBuilder sb = new StringBuilder();
        if (this.flowConstruct != null) {
            sb.append(this.flowConstruct.getName());
            sb.append(".");
        }
        sb.append("component");
        if (!(this.flowConstruct instanceof Service) && !(this.flowConstruct instanceof SimpleService)) {
            sb.append(".");
            sb.append(System.identityHashCode(this));
        }
        return sb.toString();
    }

    @Override
    public final Object getAnnotation(QName name) {
        return this.annotations.get(name);
    }

    @Override
    public final Map<QName, Object> getAnnotations() {
        return Collections.unmodifiableMap(this.annotations);
    }

    @Override
    public final synchronized void setAnnotations(Map<QName, Object> newAnnotations) {
        this.annotations.clear();
        this.annotations.putAll(newAnnotations);
    }
}

