/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.util.Comparator;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.config.i18n.CoreMessages;
import org.mule.routing.AbstractAggregator;
import org.mule.routing.correlation.CorrelationSequenceComparator;
import org.mule.routing.correlation.EventCorrelatorCallback;
import org.mule.routing.correlation.ResequenceMessagesCorrelatorCallback;

public class Resequencer
extends AbstractAggregator {
    protected Comparator eventComparator;

    public Resequencer() {
        this.setEventComparator(new CorrelationSequenceComparator());
    }

    @Override
    public void initialise() throws InitialisationException {
        if (this.eventComparator == null) {
            throw new InitialisationException(CoreMessages.objectIsNull("eventComparator"), (Initialisable)this);
        }
        super.initialise();
    }

    public Comparator getEventComparator() {
        return this.eventComparator;
    }

    public void setEventComparator(Comparator eventComparator) {
        this.eventComparator = eventComparator;
    }

    @Override
    protected EventCorrelatorCallback getCorrelatorCallback(MuleContext muleContext) {
        return new ResequenceMessagesCorrelatorCallback(this.getEventComparator(), muleContext, this.persistentStores, this.storePrefix);
    }

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        MuleEvent result = this.eventCorrelator.process(event);
        if (!this.isEventValid(result)) {
            return result;
        }
        MuleEvent last = null;
        for (MuleEvent muleEvent : (MuleEvent[])result.getMessage().getPayload()) {
            last = this.processNext(muleEvent);
        }
        return last;
    }
}

