/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.correlation;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessageCollection;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.execution.ExecutionCallback;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.MessageInfoMapping;
import org.mule.api.routing.RoutingException;
import org.mule.api.service.Service;
import org.mule.api.store.ListableObjectStore;
import org.mule.api.store.ObjectAlreadyExistsException;
import org.mule.api.store.ObjectDoesNotExistException;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.api.store.ObjectStoreManager;
import org.mule.config.i18n.CoreMessages;
import org.mule.context.notification.RoutingNotification;
import org.mule.execution.ErrorHandlingExecutionTemplate;
import org.mule.routing.EventGroup;
import org.mule.routing.EventProcessingThread;
import org.mule.routing.correlation.CorrelationTimeoutException;
import org.mule.routing.correlation.EventCorrelatorCallback;
import org.mule.util.StringMessageUtils;
import org.mule.util.concurrent.ThreadNameHelper;
import org.mule.util.monitor.Expirable;
import org.mule.util.monitor.ExpiryMonitor;
import org.mule.util.store.DeserializationPostInitialisable;

public class EventCorrelator
implements Startable,
Stoppable,
Disposable {
    protected final transient Log logger = LogFactory.getLog(EventCorrelator.class);
    public static final String NO_CORRELATION_ID = "no-id";
    public static final int MAX_PROCESSED_GROUPS = 50000;
    private static final long ONE_DAY_IN_MILLI = 86400000L;
    protected long groupTimeToLive = 86400000L;
    protected ListableObjectStore<EventGroup> eventGroups;
    protected final Object groupsLock = new Object();
    protected ObjectStore<Long> processedGroups = null;
    private long timeout = -1L;
    private boolean failOnTimeout = true;
    private MessageInfoMapping messageInfoMapping;
    private MuleContext muleContext;
    private EventCorrelatorCallback callback;
    private MessageProcessor timeoutMessageProcessor;
    private ListableObjectStore<Long> expiredAndDispatchedGroups = null;
    private ExpiringGroupMonitoringThread expiringGroupMonitoringThread;
    private final String name;
    private final boolean persistentStores;
    private final String storePrefix;

    public EventCorrelator(EventCorrelatorCallback callback, MessageProcessor timeoutMessageProcessor, MessageInfoMapping messageInfoMapping, MuleContext muleContext, String flowConstructName, boolean persistentStores, String storePrefix) {
        if (callback == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("EventCorrelatorCallback").getMessage());
        }
        if (messageInfoMapping == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("MessageInfoMapping").getMessage());
        }
        if (muleContext == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("MuleContext").getMessage());
        }
        this.callback = callback;
        this.messageInfoMapping = messageInfoMapping;
        this.muleContext = muleContext;
        this.timeoutMessageProcessor = timeoutMessageProcessor;
        this.persistentStores = persistentStores;
        this.storePrefix = storePrefix;
        this.name = String.format("%s%s.event.correlator", ThreadNameHelper.getPrefix(muleContext), flowConstructName);
        ObjectStoreManager objectStoreManager = (ObjectStoreManager)muleContext.getRegistry().get("_muleObjectStoreManager");
        this.expiredAndDispatchedGroups = (ListableObjectStore)objectStoreManager.getObjectStore(storePrefix + ".expiredAndDispatchedGroups", persistentStores);
        this.processedGroups = (ListableObjectStore)objectStoreManager.getObjectStore(storePrefix + ".processedGroups", persistentStores, 50000, -1, 1000);
        this.eventGroups = (ListableObjectStore)objectStoreManager.getObjectStore(storePrefix + ".eventGroups", persistentStores);
    }

    public void forceGroupExpiry(String groupId) throws MessagingException {
        try {
            if (this.eventGroups.retrieve((Serializable)((Object)groupId)) != null) {
                this.handleGroupExpiry(this.getEventGroup((Serializable)((Object)groupId)));
            } else {
                this.addProcessedGroup(groupId);
            }
        }
        catch (ObjectStoreException e) {
            throw new MessagingException(null, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MuleEvent process(MuleEvent event) throws RoutingException {
        EventGroup group;
        String groupId = this.messageInfoMapping.getCorrelationId(event.getMessage());
        if (this.logger.isTraceEnabled()) {
            try {
                this.logger.trace((Object)String.format("Received async reply message for correlationID: %s%n%s%n%s", groupId, StringMessageUtils.truncate(StringMessageUtils.toString(event.getMessage().getPayload()), 200, false), StringMessageUtils.headersToString(event.getMessage())));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (groupId == null || groupId.equals("-1")) {
            throw new RoutingException(CoreMessages.noCorrelationId(), event, this.timeoutMessageProcessor);
        }
        try {
            if (this.isGroupAlreadyProcessed(groupId)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("An event was received for an event group that has already been processed, this is probably because the async-reply timed out. Correlation Id is: " + groupId + ". Dropping event"));
                }
                this.muleContext.fireNotification(new RoutingNotification(event.getMessage(), event.getMessageSourceURI().toString(), 1304));
                return null;
            }
        }
        catch (ObjectStoreException e) {
            throw new RoutingException(event, this.timeoutMessageProcessor, (Throwable)e);
        }
        try {
            group = this.getEventGroup((Serializable)((Object)groupId));
        }
        catch (ObjectStoreException e) {
            throw new RoutingException(event, this.timeoutMessageProcessor, (Throwable)e);
        }
        if (group == null) {
            try {
                group = this.addEventGroup(this.callback.createEventGroup(event, groupId));
            }
            catch (ObjectStoreException e) {
                throw new RoutingException(event, this.timeoutMessageProcessor, (Throwable)e);
            }
        }
        Object object = this.groupsLock;
        synchronized (object) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Adding event to aggregator group: " + groupId));
            }
            try {
                group.addEvent(event);
            }
            catch (ObjectStoreException e) {
                throw new RoutingException(event, this.timeoutMessageProcessor, (Throwable)e);
            }
            if (this.callback.shouldAggregateEvents(group)) {
                MuleEvent returnEvent = this.callback.aggregateEvents(group);
                returnEvent.getMessage().setCorrelationId(groupId);
                String rootId = group.getCommonRootId();
                if (rootId != null) {
                    returnEvent.getMessage().setMessageRootId(rootId);
                }
                try {
                    this.removeEventGroup(group);
                    group.clear();
                }
                catch (ObjectStoreException e) {
                    throw new RoutingException(event, this.timeoutMessageProcessor, (Throwable)e);
                }
                return returnEvent;
            }
            return null;
        }
    }

    protected EventGroup getEventGroup(Serializable groupId) throws ObjectStoreException {
        try {
            EventGroup eventGroup = (EventGroup)this.eventGroups.retrieve(groupId);
            if (!eventGroup.isInitialised()) {
                try {
                    DeserializationPostInitialisable.Implementation.init(eventGroup, this.muleContext);
                }
                catch (Exception e) {
                    throw new ObjectStoreException(e);
                }
            }
            return eventGroup;
        }
        catch (ObjectDoesNotExistException e) {
            return null;
        }
    }

    protected EventGroup addEventGroup(EventGroup group) throws ObjectStoreException {
        try {
            this.eventGroups.store((Serializable)group.getGroupId(), group);
            return group;
        }
        catch (ObjectAlreadyExistsException e) {
            return this.getEventGroup((Serializable)((Object)((String)group.getGroupId())));
        }
    }

    protected void removeEventGroup(EventGroup group) throws ObjectStoreException {
        Object groupId = group.getGroupId();
        this.eventGroups.remove((Serializable)groupId);
        this.addProcessedGroup(groupId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addProcessedGroup(Object id) throws ObjectStoreException {
        Object object = this.groupsLock;
        synchronized (object) {
            this.processedGroups.store((Serializable)id, System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isGroupAlreadyProcessed(Object id) throws ObjectStoreException {
        Object object = this.groupsLock;
        synchronized (object) {
            return this.processedGroups.contains((Serializable)id);
        }
    }

    public boolean isFailOnTimeout() {
        return this.failOnTimeout;
    }

    public void setFailOnTimeout(boolean failOnTimeout) {
        this.failOnTimeout = failOnTimeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    protected void handleGroupExpiry(EventGroup group) throws MessagingException {
        try {
            this.removeEventGroup(group);
        }
        catch (ObjectStoreException e) {
            throw new MessagingException(group.getMessageCollectionEvent(), (Throwable)e);
        }
        if (this.isFailOnTimeout()) {
            MuleMessageCollection messageCollection;
            try {
                messageCollection = group.toMessageCollection();
            }
            catch (ObjectStoreException e) {
                throw new MessagingException(group.getMessageCollectionEvent(), (Throwable)e);
            }
            this.muleContext.fireNotification(new RoutingNotification(messageCollection, null, 1303));
            MuleEvent groupCollectionEvent = group.getMessageCollectionEvent();
            try {
                group.clear();
            }
            catch (ObjectStoreException e) {
                this.logger.warn((Object)("Failed to clear group with id " + group.getGroupId() + " since underlying ObjectStore threw Exception:" + e.getMessage()));
            }
            throw new CorrelationTimeoutException(CoreMessages.correlationTimedOut(group.getGroupId()), groupCollectionEvent);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)MessageFormat.format("Aggregator expired, but ''failOnTimeOut'' is false. Forwarding {0} events out of {1} total for group ID: {2}", group.size(), group.expectedSize(), group.getGroupId()));
        }
        try {
            if (group.getCreated() + this.groupTimeToLive >= System.currentTimeMillis()) {
                MuleEvent newEvent = this.callback.aggregateEvents(group);
                group.clear();
                newEvent.getMessage().setCorrelationId(group.getGroupId().toString());
                if (!this.expiredAndDispatchedGroups.contains((Serializable)group.getGroupId())) {
                    if (this.timeoutMessageProcessor != null) {
                        this.timeoutMessageProcessor.process(newEvent);
                    } else {
                        FlowConstruct service = group.toArray(false)[0].getFlowConstruct();
                        if (!(service instanceof Service)) {
                            throw new UnsupportedOperationException("EventAggregator is only supported with Service");
                        }
                        ((Service)service).dispatchEvent(newEvent);
                    }
                    this.expiredAndDispatchedGroups.store((Serializable)group.getGroupId(), group.getCreated());
                } else {
                    this.logger.warn((Object)MessageFormat.format("Discarding group {0}", group.getGroupId()));
                }
            }
        }
        catch (MessagingException me) {
            throw me;
        }
        catch (Exception e) {
            throw new MessagingException(group.getMessageCollectionEvent(), (Throwable)e);
        }
    }

    @Override
    public void start() throws MuleException {
        this.logger.info((Object)("Starting event correlator: " + this.name));
        if (this.timeout != 0L) {
            this.expiringGroupMonitoringThread = new ExpiringGroupMonitoringThread();
            this.expiringGroupMonitoringThread.start();
        }
    }

    @Override
    public void stop() throws MuleException {
        this.logger.info((Object)("Stopping event correlator: " + this.name));
        if (this.expiringGroupMonitoringThread != null) {
            this.expiringGroupMonitoringThread.stopProcessing();
        }
    }

    @Override
    public void dispose() {
        this.disposeIfDisposable(this.expiredAndDispatchedGroups);
        this.disposeIfDisposable(this.processedGroups);
        this.disposeIfDisposable(this.eventGroups);
        this.disposeIfDisposable(this.expiringGroupMonitoringThread);
    }

    private void disposeIfDisposable(Object o) {
        if (o != null && o instanceof Disposable) {
            ((Disposable)o).dispose();
        }
    }

    private final class ExpiringGroupMonitoringThread
    extends EventProcessingThread
    implements Expirable,
    Disposable {
        private ExpiryMonitor expiryMonitor;
        public static final long DELAY_TIME = 10L;

        public ExpiringGroupMonitoringThread() {
            super(EventCorrelator.this.name, 10L);
            this.expiryMonitor = new ExpiryMonitor(EventCorrelator.this.name, 60000, EventCorrelator.this.muleContext, true);
            this.expiryMonitor.addExpirable(1800000L, TimeUnit.MILLISECONDS, this);
        }

        @Override
        public void expired() {
            try {
                for (Serializable o : EventCorrelator.this.expiredAndDispatchedGroups.allKeys()) {
                    Long time = (Long)EventCorrelator.this.expiredAndDispatchedGroups.retrieve(o);
                    if (time + EventCorrelator.this.groupTimeToLive >= System.currentTimeMillis()) continue;
                    EventCorrelator.this.expiredAndDispatchedGroups.remove(o);
                    this.logger.warn((Object)MessageFormat.format("Discarding group {0}", o));
                }
            }
            catch (ObjectStoreException e) {
                this.logger.warn((Object)("Expiration of objects failed due to ObjectStoreException " + e + "."));
            }
        }

        @Override
        public void doRun() {
            EventGroup group;
            if (!EventCorrelator.this.muleContext.isPrimaryPollingInstance()) {
                return;
            }
            ArrayList<EventGroup> expired = new ArrayList<EventGroup>(1);
            try {
                for (Serializable o : EventCorrelator.this.eventGroups.allKeys()) {
                    group = EventCorrelator.this.getEventGroup(o);
                    if (group.getCreated() + EventCorrelator.this.getTimeout() >= System.currentTimeMillis()) continue;
                    expired.add(group);
                }
            }
            catch (ObjectStoreException e) {
                this.logger.warn((Object)("expiry failed dues to ObjectStoreException " + e));
            }
            if (expired.size() > 0) {
                Iterator<Serializable> i$ = expired.iterator();
                while (i$.hasNext()) {
                    EventGroup anExpired;
                    group = anExpired = (EventGroup)i$.next();
                    ErrorHandlingExecutionTemplate executionTemplate = ErrorHandlingExecutionTemplate.createErrorHandlingExecutionTemplate(EventCorrelator.this.muleContext, group.getMessageCollectionEvent().getFlowConstruct().getExceptionListener());
                    try {
                        executionTemplate.execute(new ExecutionCallback<MuleEvent>(){

                            @Override
                            public MuleEvent process() throws Exception {
                                EventCorrelator.this.handleGroupExpiry(group);
                                return null;
                            }
                        });
                    }
                    catch (MessagingException e) {
                    }
                    catch (Exception e) {
                        EventCorrelator.this.muleContext.getExceptionListener().handleException(e);
                    }
                }
            }
        }

        @Override
        public void dispose() {
            if (this.expiryMonitor != null) {
                this.expiryMonitor.dispose();
            }
        }
    }
}

