/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.mule.MessageExchangePattern;
import org.mule.VoidMuleEvent;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.WorkManager;
import org.mule.api.context.WorkManagerSource;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationHandler;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleCallback;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.lifecycle.LifecycleState;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.registry.ServiceException;
import org.mule.api.registry.ServiceType;
import org.mule.api.retry.RetryCallback;
import org.mule.api.retry.RetryContext;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionException;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.Connectable;
import org.mule.api.transport.Connector;
import org.mule.api.transport.ConnectorException;
import org.mule.api.transport.DispatchException;
import org.mule.api.transport.MessageDispatcher;
import org.mule.api.transport.MessageDispatcherFactory;
import org.mule.api.transport.MessageReceiver;
import org.mule.api.transport.MessageRequester;
import org.mule.api.transport.MessageRequesterFactory;
import org.mule.api.transport.MuleMessageFactory;
import org.mule.api.transport.ReplyToHandler;
import org.mule.api.transport.SessionHandler;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.context.notification.ConnectionNotification;
import org.mule.context.notification.EndpointMessageNotification;
import org.mule.context.notification.OptimisedNotificationHandler;
import org.mule.endpoint.outbound.OutboundNotificationMessageProcessor;
import org.mule.model.streaming.DelegatingInputStream;
import org.mule.processor.AbstractRedeliveryPolicy;
import org.mule.processor.IdempotentRedeliveryPolicy;
import org.mule.processor.LaxAsyncInterceptingMessageProcessor;
import org.mule.processor.chain.SimpleMessageProcessorChainBuilder;
import org.mule.routing.filters.WildcardFilter;
import org.mule.session.SerializeAndEncodeSessionHandler;
import org.mule.transaction.TransactionCoordination;
import org.mule.transformer.TransformerUtils;
import org.mule.transport.ConfigurableKeyedObjectPool;
import org.mule.transport.ConfigurableKeyedObjectPoolFactory;
import org.mule.transport.ConnectException;
import org.mule.transport.ConnectorLifecycleManager;
import org.mule.transport.DefaultConfigurableKeyedObjectPoolFactory;
import org.mule.transport.DefaultReplyToHandler;
import org.mule.transport.KeyedPoolMessageDispatcherFactoryAdapter;
import org.mule.transport.KeyedPoolMessageRequesterFactoryAdapter;
import org.mule.transport.service.TransportServiceDescriptor;
import org.mule.transport.service.TransportServiceException;
import org.mule.util.BeanUtils;
import org.mule.util.ClassUtils;
import org.mule.util.CollectionUtils;
import org.mule.util.ObjectNameHelper;
import org.mule.util.ObjectUtils;
import org.mule.util.StringUtils;
import org.mule.util.concurrent.NamedThreadFactory;
import org.mule.util.concurrent.ThreadNameHelper;

public abstract class AbstractConnector
implements Connector,
WorkListener {
    public static final int DEFAULT_NUM_CONCURRENT_TX_RECEIVERS = 4;
    private static final long SCHEDULER_FORCED_SHUTDOWN_TIMEOUT = 5000L;
    public static final String PROPERTY_POLLING_FREQUENCY = "pollingFrequency";
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected volatile String name;
    protected volatile MessageDispatcherFactory dispatcherFactory;
    protected volatile MessageRequesterFactory requesterFactory;
    protected MuleMessageFactory muleMessageFactory;
    protected volatile ConfigurableKeyedObjectPool dispatchers;
    protected volatile ConfigurableKeyedObjectPoolFactory dispatcherPoolFactory;
    protected final GenericKeyedObjectPool requesters = new GenericKeyedObjectPool();
    protected final Map<Object, MessageReceiver> receivers = new ConcurrentHashMap<Object, MessageReceiver>();
    private volatile ThreadingProfile dispatcherThreadingProfile;
    private volatile ThreadingProfile requesterThreadingProfile;
    private volatile ThreadingProfile receiverThreadingProfile;
    protected volatile boolean createMultipleTransactedReceivers = true;
    protected volatile int numberOfConcurrentTransactedReceivers = 4;
    private RetryPolicyTemplate retryPolicyTemplate;
    private boolean dynamicNotification = false;
    private ServerNotificationHandler cachedNotificationHandler;
    private final List<String> supportedProtocols;
    private final AtomicReference<WorkManager> receiverWorkManager = new AtomicReference();
    private final AtomicReference<WorkManager> dispatcherWorkManager = new AtomicReference();
    private final AtomicReference<WorkManager> requesterWorkManager = new AtomicReference();
    private ScheduledExecutorService scheduler;
    protected volatile TransportServiceDescriptor serviceDescriptor;
    protected volatile Properties serviceOverrides;
    protected volatile SessionHandler sessionHandler = new SerializeAndEncodeSessionHandler();
    protected MuleContext muleContext;
    protected ConnectorLifecycleManager lifecycleManager;
    private AtomicBoolean connected = new AtomicBoolean(false);
    private AtomicBoolean connecting = new AtomicBoolean(false);
    protected boolean startOnConnect = false;
    protected boolean initialStateStopped = false;
    private boolean validateConnections = true;

    public AbstractConnector(MuleContext context) {
        this.muleContext = context;
        this.lifecycleManager = new ConnectorLifecycleManager(this);
        this.setDynamicNotification(false);
        this.updateCachedNotificationHandler();
        this.supportedProtocols = new ArrayList<String>();
        this.supportedProtocols.add(this.getProtocol().toLowerCase());
        this.requesters.setTestOnBorrow(false);
        this.requesters.setTestOnReturn(true);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        if (newName == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("Connector name").toString());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Set Connector name to: " + newName));
        }
        this.name = newName;
    }

    ConnectorLifecycleManager getLifecycleManager() {
        return this.lifecycleManager;
    }

    @Override
    public LifecycleState getLifecycleState() {
        return this.lifecycleManager.getState();
    }

    @Override
    public final synchronized void initialise() throws InitialisationException {
        try {
            this.lifecycleManager.fireInitialisePhase(new LifecycleCallback<Connector>(){

                @Override
                public void onTransition(String phaseName, Connector object) throws MuleException {
                    if (AbstractConnector.this.retryPolicyTemplate == null) {
                        AbstractConnector.this.retryPolicyTemplate = (RetryPolicyTemplate)AbstractConnector.this.muleContext.getRegistry().lookupObject("_defaultRetryPolicyTemplate");
                    }
                    if (AbstractConnector.this.dispatcherPoolFactory == null) {
                        AbstractConnector.this.dispatcherPoolFactory = new DefaultConfigurableKeyedObjectPoolFactory();
                    }
                    AbstractConnector.this.dispatchers = AbstractConnector.this.dispatcherPoolFactory.createObjectPool();
                    if (AbstractConnector.this.dispatcherFactory != null) {
                        AbstractConnector.this.dispatchers.setFactory(AbstractConnector.this.getWrappedDispatcherFactory(AbstractConnector.this.dispatcherFactory));
                    }
                    AbstractConnector.this.initFromServiceDescriptor();
                    AbstractConnector.this.configureDispatcherPool();
                    AbstractConnector.this.setMaxRequestersActive(AbstractConnector.this.getRequesterThreadingProfile().getMaxThreadsActive());
                    try {
                        AbstractConnector.this.initWorkManagers();
                    }
                    catch (MuleException e) {
                        throw new LifecycleException(e, (Object)this);
                    }
                    AbstractConnector.this.doInitialise();
                }
            });
        }
        catch (InitialisationException e) {
            throw e;
        }
        catch (LifecycleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        catch (MuleException e) {
            e.printStackTrace();
        }
    }

    @Override
    public final synchronized void start() throws MuleException {
        if (this.isInitialStateStopped()) {
            this.logger.info((Object)"Connector not started because 'initialStateStopped' is true");
            return;
        }
        if (!this.isConnected()) {
            try {
                this.startOnConnect = true;
                this.connect();
            }
            catch (MuleException me) {
                throw me;
            }
            catch (Exception e) {
                throw new ConnectException(e, (Connectable)this);
            }
        } else {
            this.startAfterConnect();
        }
    }

    protected synchronized void startAfterConnect() throws MuleException {
        this.startOnConnect = false;
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Starting: " + this));
        }
        this.lifecycleManager.fireStartPhase(new LifecycleCallback<Connector>(){

            @Override
            public void onTransition(String phaseName, Connector object) throws MuleException {
                AbstractConnector.this.initWorkManagers();
                AbstractConnector.this.scheduler = AbstractConnector.this.createScheduler();
                AbstractConnector.this.doStart();
                if (AbstractConnector.this.receivers != null) {
                    for (MessageReceiver receiver : AbstractConnector.this.receivers.values()) {
                        ArrayList<MuleException> errors = new ArrayList<MuleException>();
                        try {
                            if (AbstractConnector.this.logger.isDebugEnabled()) {
                                AbstractConnector.this.logger.debug((Object)("Starting receiver on endpoint: " + receiver.getEndpoint().getEndpointURI()));
                            }
                            if (receiver.getFlowConstruct().getLifecycleState().isStarted()) {
                                receiver.start();
                            }
                        }
                        catch (MuleException e) {
                            AbstractConnector.this.logger.error((Object)e);
                            errors.add(e);
                        }
                        if (errors.isEmpty()) continue;
                        throw (MuleException)errors.get(0);
                    }
                }
            }
        });
    }

    @Override
    public final synchronized void stop() throws MuleException {
        this.lifecycleManager.fireStopPhase(new LifecycleCallback<Connector>(){

            @Override
            public void onTransition(String phaseName, Connector object) throws MuleException {
                AbstractConnector.this.shutdownScheduler();
                AbstractConnector.this.doStop();
                if (AbstractConnector.this.receivers != null) {
                    for (MessageReceiver receiver : AbstractConnector.this.receivers.values()) {
                        if (AbstractConnector.this.logger.isDebugEnabled()) {
                            AbstractConnector.this.logger.debug((Object)("Stopping receiver on endpoint: " + receiver.getEndpoint().getEndpointURI()));
                        }
                        receiver.stop();
                    }
                }
                AbstractConnector.this.disposeWorkManagers();
                AbstractConnector.this.clearDispatchers();
                AbstractConnector.this.clearRequesters();
                AbstractConnector.this.scheduler = null;
            }
        });
    }

    @Override
    public final synchronized void dispose() {
        try {
            if (this.isStarted()) {
                this.stop();
            }
            if (this.isConnected()) {
                this.disconnect();
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        try {
            this.lifecycleManager.fireDisposePhase(new LifecycleCallback<Connector>(){

                @Override
                public void onTransition(String phaseName, Connector object) throws MuleException {
                    AbstractConnector.this.doDispose();
                    AbstractConnector.this.disposeReceivers();
                }
            });
        }
        catch (MuleException e) {
            this.logger.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public final boolean isStarted() {
        return this.lifecycleManager.getState().isStarted();
    }

    public final boolean isStarting() {
        return this.lifecycleManager.getState().isStarting();
    }

    public boolean isInitialised() {
        return this.lifecycleManager.getState().isInitialised();
    }

    public boolean isStopped() {
        return this.lifecycleManager.getState().isStopped();
    }

    public boolean isStopping() {
        return this.lifecycleManager.getState().isStopping();
    }

    protected void configureDispatcherPool() {
        int maxDispatchersActive = this.getDispatcherThreadingProfile().getMaxThreadsActive();
        if (4 == this.getDispatcherThreadingProfile().getPoolExhaustedAction()) {
            ++maxDispatchersActive;
        }
        this.setMaxDispatchersActive(maxDispatchersActive);
    }

    @Override
    public MuleMessageFactory createMuleMessageFactory() throws CreateException {
        try {
            return this.serviceDescriptor.createMuleMessageFactory();
        }
        catch (TransportServiceException tse) {
            throw new CreateException(CoreMessages.failedToCreate("MuleMessageFactory"), tse, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdownScheduler() {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
            try {
                if (!this.scheduler.awaitTermination(this.muleContext.getConfiguration().getShutdownTimeout(), TimeUnit.MILLISECONDS)) {
                    List<Runnable> outstanding = this.scheduler.shutdownNow();
                    if (!this.scheduler.awaitTermination(5000L, TimeUnit.MILLISECONDS)) {
                        this.logger.warn((Object)MessageFormat.format("Pool {0} did not terminate in time; {1} work items were cancelled.", this.name, outstanding.isEmpty() ? "No" : Integer.toString(outstanding.size())));
                    } else if (!outstanding.isEmpty()) {
                        this.logger.warn((Object)MessageFormat.format("Pool {0} terminated; {1} work items were cancelled.", this.name, Integer.toString(outstanding.size())));
                    }
                }
            }
            catch (InterruptedException ie) {
                this.scheduler.shutdownNow();
                Thread.currentThread().interrupt();
            }
            finally {
                this.scheduler = null;
            }
        }
    }

    protected void initWorkManagers() throws MuleException {
        WorkManager newWorkManager;
        String threadPrefix;
        if (this.receiverWorkManager.get() == null) {
            threadPrefix = ThreadNameHelper.receiver(this.muleContext, this.getName());
            newWorkManager = this.getReceiverThreadingProfile().createWorkManager(threadPrefix, this.muleContext.getConfiguration().getShutdownTimeout());
            if (this.receiverWorkManager.compareAndSet(null, newWorkManager)) {
                newWorkManager.start();
            }
        }
        if (this.dispatcherWorkManager.get() == null) {
            String threadPrefix2;
            WorkManager newWorkManager2;
            ThreadingProfile dispatcherThreadingProfile = this.getDispatcherThreadingProfile();
            if (dispatcherThreadingProfile.getMuleContext() == null) {
                dispatcherThreadingProfile.setMuleContext(this.muleContext);
            }
            if (this.dispatcherWorkManager.compareAndSet(null, newWorkManager2 = dispatcherThreadingProfile.createWorkManager(threadPrefix2 = ThreadNameHelper.dispatcher(this.muleContext, this.getName()), this.muleContext.getConfiguration().getShutdownTimeout()))) {
                newWorkManager2.start();
            }
        }
        if (this.requesterWorkManager.get() == null) {
            threadPrefix = ThreadNameHelper.requester(this.muleContext, this.getName());
            newWorkManager = this.getRequesterThreadingProfile().createWorkManager(threadPrefix, this.muleContext.getConfiguration().getShutdownTimeout());
            if (this.requesterWorkManager.compareAndSet(null, newWorkManager)) {
                newWorkManager.start();
            }
        }
    }

    protected void disposeWorkManagers() {
        this.logger.debug((Object)"Disposing dispatcher work manager");
        WorkManager workManager = this.dispatcherWorkManager.get();
        if (workManager != null) {
            workManager.dispose();
        }
        this.dispatcherWorkManager.set(null);
        this.logger.debug((Object)"Disposing requester work manager");
        workManager = this.requesterWorkManager.get();
        if (workManager != null) {
            workManager.dispose();
        }
        this.requesterWorkManager.set(null);
        this.logger.debug((Object)"Disposing receiver work manager");
        workManager = this.receiverWorkManager.get();
        if (workManager != null) {
            workManager.dispose();
        }
        this.receiverWorkManager.set(null);
    }

    protected void disposeReceivers() {
        if (this.receivers != null) {
            this.logger.debug((Object)"Disposing Receivers");
            for (MessageReceiver receiver : this.receivers.values()) {
                try {
                    this.destroyReceiver(receiver, receiver.getEndpoint());
                }
                catch (Throwable e) {
                    this.logger.error((Object)("Failed to destroy receiver: " + receiver), e);
                }
            }
            this.receivers.clear();
            this.logger.debug((Object)"Receivers Disposed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearDispatchers() {
        if (this.dispatchers != null) {
            this.logger.debug((Object)"Clearing Dispatcher pool");
            ConfigurableKeyedObjectPool configurableKeyedObjectPool = this.dispatchers;
            synchronized (configurableKeyedObjectPool) {
                this.dispatchers.clear();
            }
            this.logger.debug((Object)"Dispatcher pool cleared");
        }
    }

    protected void clearRequesters() {
        if (this.requesters != null) {
            this.logger.debug((Object)"Clearing Requester pool");
            this.requesters.clear();
            this.logger.debug((Object)"Requester pool cleared");
        }
    }

    @Override
    public boolean isDisposed() {
        return this.lifecycleManager.getState().isDisposed();
    }

    @Override
    public MessageDispatcherFactory getDispatcherFactory() {
        return this.dispatcherFactory;
    }

    @Override
    public void setDispatcherFactory(MessageDispatcherFactory dispatcherFactory) {
        KeyedPoolableObjectFactory poolFactory = this.getWrappedDispatcherFactory(dispatcherFactory);
        if (this.dispatchers != null) {
            this.dispatchers.setFactory(poolFactory);
        }
        this.dispatcherFactory = dispatcherFactory;
    }

    private KeyedPoolableObjectFactory getWrappedDispatcherFactory(MessageDispatcherFactory dispatcherFactory) {
        Object poolFactory = dispatcherFactory instanceof KeyedPoolableObjectFactory ? (KeyedPoolableObjectFactory)dispatcherFactory : new KeyedPoolMessageDispatcherFactoryAdapter(dispatcherFactory);
        return poolFactory;
    }

    @Override
    public MessageRequesterFactory getRequesterFactory() {
        return this.requesterFactory;
    }

    @Override
    public void setRequesterFactory(MessageRequesterFactory requesterFactory) {
        Object poolFactory = requesterFactory instanceof KeyedPoolableObjectFactory ? (KeyedPoolableObjectFactory)requesterFactory : new KeyedPoolMessageRequesterFactoryAdapter(requesterFactory);
        this.requesters.setFactory(poolFactory);
        this.requesterFactory = requesterFactory;
    }

    public MuleMessageFactory getMuleMessageFactory() throws CreateException {
        if (this.muleMessageFactory == null) {
            this.muleMessageFactory = this.createMuleMessageFactory();
        }
        return this.muleMessageFactory;
    }

    public boolean isInitialStateStopped() {
        return this.initialStateStopped;
    }

    public void setInitialStateStopped(boolean initialStateStopped) {
        this.initialStateStopped = initialStateStopped;
    }

    public int getMaxDispatchersActive() {
        this.checkDispatchersInitialised();
        return this.dispatchers.getMaxActive();
    }

    private void checkDispatchersInitialised() {
        if (this.dispatchers == null) {
            throw new IllegalStateException("Dispatchers pool was not initialised");
        }
    }

    public int getMaxTotalDispatchers() {
        this.checkDispatchersInitialised();
        return this.dispatchers.getMaxTotal();
    }

    public void setMaxDispatchersActive(int maxActive) {
        this.checkDispatchersInitialised();
        this.dispatchers.setMaxActive(maxActive);
        this.dispatchers.setMaxIdle(maxActive);
        this.dispatchers.setMaxTotal(20 * maxActive);
    }

    protected MessageDispatcher borrowDispatcher(OutboundEndpoint endpoint) throws MuleException {
        if (!this.isStarted()) {
            throw new LifecycleException(CoreMessages.lifecycleErrorCannotUseConnector(this.getName(), this.lifecycleManager.getCurrentPhase()), (Object)this);
        }
        if (endpoint == null) {
            throw new IllegalArgumentException("Endpoint must not be null");
        }
        if (!this.supportsProtocol(endpoint.getConnector().getProtocol())) {
            throw new IllegalArgumentException(CoreMessages.connectorSchemeIncompatibleWithEndpointScheme(this.getProtocol(), endpoint.getEndpointURI().toString()).getMessage());
        }
        MessageDispatcher dispatcher = null;
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Borrowing a dispatcher for endpoint: " + endpoint.getEndpointURI()));
            }
            dispatcher = (MessageDispatcher)this.dispatchers.borrowObject(endpoint);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Borrowed a dispatcher for endpoint: " + endpoint.getEndpointURI() + " = " + dispatcher.toString()));
            }
            MessageDispatcher messageDispatcher = dispatcher;
            return messageDispatcher;
        }
        catch (Exception ex) {
            throw new ConnectorException(CoreMessages.connectorCausedError(), this, ex);
        }
        finally {
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Borrowed dispatcher: " + ObjectUtils.toString((Object)dispatcher, (String)"null")));
                }
            }
            catch (Exception ex) {
                throw new ConnectorException(CoreMessages.connectorCausedError(), this, ex);
            }
        }
    }

    protected void returnDispatcher(OutboundEndpoint endpoint, MessageDispatcher dispatcher) {
        if (endpoint != null && dispatcher != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Returning dispatcher for endpoint: " + endpoint.getEndpointURI() + " = " + dispatcher.toString()));
            }
            try {
                this.dispatchers.returnObject(endpoint, dispatcher);
            }
            catch (Exception e) {
                this.logger.error((Object)("Failed to dispose dispatcher for endpoint: " + endpoint + ". This will cause a memory leak. Please report to"), (Throwable)e);
            }
        }
    }

    public int getMaxRequestersActive() {
        return this.requesters.getMaxActive();
    }

    public void setMaxRequestersActive(int maxActive) {
        this.requesters.setMaxActive(maxActive);
        this.requesters.setMaxIdle(maxActive);
        this.requesters.setMaxTotal(20 * maxActive);
    }

    private MessageRequester getRequester(InboundEndpoint endpoint) throws MuleException {
        if (!this.isStarted()) {
            throw new LifecycleException(CoreMessages.lifecycleErrorCannotUseConnector(this.getName(), this.lifecycleManager.getCurrentPhase()), (Object)this);
        }
        if (endpoint == null) {
            throw new IllegalArgumentException("Endpoint must not be null");
        }
        if (!this.supportsProtocol(endpoint.getConnector().getProtocol())) {
            throw new IllegalArgumentException(CoreMessages.connectorSchemeIncompatibleWithEndpointScheme(this.getProtocol(), endpoint.getEndpointURI().toString()).getMessage());
        }
        MessageRequester requester = null;
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Borrowing a requester for endpoint: " + endpoint.getEndpointURI()));
            }
            requester = (MessageRequester)this.requesters.borrowObject((Object)endpoint);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Borrowed a requester for endpoint: " + endpoint.getEndpointURI() + " = " + requester.toString()));
            }
            MessageRequester messageRequester = requester;
            return messageRequester;
        }
        catch (Exception ex) {
            throw new ConnectorException(CoreMessages.connectorCausedError(), this, ex);
        }
        finally {
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Borrowed requester: " + ObjectUtils.toString((Object)requester, (String)"null")));
                }
            }
            catch (Exception ex) {
                throw new ConnectorException(CoreMessages.connectorCausedError(), this, ex);
            }
        }
    }

    private void returnRequester(InboundEndpoint endpoint, MessageRequester requester) {
        if (endpoint != null && requester != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Returning requester for endpoint: " + endpoint.getEndpointURI() + " = " + requester.toString()));
            }
            try {
                this.requesters.returnObject((Object)endpoint, (Object)requester);
            }
            catch (Exception e) {
                this.logger.error((Object)("Failed to dispose requester for endpoint: " + endpoint + ". This will cause a memory leak. Please report to"), (Throwable)e);
            }
        }
    }

    @Override
    public void registerListener(InboundEndpoint endpoint, MessageProcessor messageProcessorChain, FlowConstruct flowConstruct) throws Exception {
        if (endpoint == null) {
            throw new IllegalArgumentException("The endpoint cannot be null when registering a listener");
        }
        if (messageProcessorChain == null) {
            throw new IllegalArgumentException("The messageProcessorChain cannot be null when registering a listener");
        }
        EndpointURI endpointUri = endpoint.getEndpointURI();
        if (endpointUri == null) {
            throw new ConnectorException(CoreMessages.endpointIsNullForListener(), this);
        }
        this.logger.info((Object)("Registering listener: " + flowConstruct.getName() + " on endpointUri: " + endpointUri.toString()));
        if (this.getReceiver(flowConstruct, endpoint) != null) {
            throw new ConnectorException(CoreMessages.listenerAlreadyRegistered(endpointUri), this);
        }
        MessageReceiver receiver = this.createReceiver(flowConstruct, endpoint);
        receiver.setListener(messageProcessorChain);
        Object receiverKey = this.getReceiverKey(flowConstruct, endpoint);
        receiver.setReceiverKey(receiverKey.toString());
        receiver.initialise();
        this.receivers.put(receiverKey, receiver);
        if (this.isConnected()) {
            receiver.connect();
        }
        if (this.isStarted()) {
            receiver.start();
        }
    }

    protected Object getReceiverKey(FlowConstruct flowConstruct, InboundEndpoint endpoint) {
        return StringUtils.defaultIfEmpty((String)endpoint.getEndpointURI().getFilterAddress(), (String)endpoint.getEndpointURI().getAddress());
    }

    @Override
    public final void unregisterListener(InboundEndpoint endpoint, FlowConstruct flowConstruct) throws Exception {
        MessageReceiver receiver;
        if (endpoint == null) {
            throw new IllegalArgumentException("The endpoint must not be null when you unregister a listener");
        }
        EndpointURI endpointUri = endpoint.getEndpointURI();
        if (endpointUri == null) {
            throw new IllegalArgumentException("The endpointUri must not be null when you unregister a listener");
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Removing listener on endpointUri: " + endpointUri));
        }
        if (this.receivers != null && !this.receivers.isEmpty() && (receiver = this.receivers.remove(this.getReceiverKey(flowConstruct, endpoint))) != null) {
            this.destroyReceiver(receiver, endpoint);
            this.doUnregisterListener(flowConstruct, endpoint, receiver);
        }
    }

    protected void doUnregisterListener(FlowConstruct flowConstruct, InboundEndpoint endpoint, MessageReceiver receiver) {
    }

    public ThreadingProfile getDispatcherThreadingProfile() {
        if (this.dispatcherThreadingProfile == null && this.muleContext != null) {
            this.dispatcherThreadingProfile = this.muleContext.getDefaultMessageDispatcherThreadingProfile();
        }
        return this.dispatcherThreadingProfile;
    }

    public void setDispatcherThreadingProfile(ThreadingProfile dispatcherThreadingProfile) {
        this.dispatcherThreadingProfile = dispatcherThreadingProfile;
    }

    public ThreadingProfile getRequesterThreadingProfile() {
        if (this.requesterThreadingProfile == null && this.muleContext != null) {
            this.requesterThreadingProfile = this.muleContext.getDefaultMessageRequesterThreadingProfile();
        }
        return this.requesterThreadingProfile;
    }

    public void setRequesterThreadingProfile(ThreadingProfile requesterThreadingProfile) {
        this.requesterThreadingProfile = requesterThreadingProfile;
    }

    public ThreadingProfile getReceiverThreadingProfile() {
        if (this.receiverThreadingProfile == null && this.muleContext != null) {
            this.receiverThreadingProfile = this.muleContext.getDefaultMessageReceiverThreadingProfile();
        }
        return this.receiverThreadingProfile;
    }

    public void setReceiverThreadingProfile(ThreadingProfile receiverThreadingProfile) {
        this.receiverThreadingProfile = receiverThreadingProfile;
    }

    public void destroyReceiver(MessageReceiver receiver, ImmutableEndpoint endpoint) throws Exception {
        receiver.dispose();
    }

    protected abstract void doInitialise() throws InitialisationException;

    protected abstract void doDispose();

    protected abstract void doStart() throws MuleException;

    protected abstract void doStop() throws MuleException;

    public List<Transformer> getDefaultInboundTransformers(ImmutableEndpoint endpoint) {
        if (this.serviceDescriptor == null) {
            throw new RuntimeException("serviceDescriptor not initialized");
        }
        return TransformerUtils.getDefaultInboundTransformers(this.serviceDescriptor, endpoint);
    }

    public List<Transformer> getDefaultResponseTransformers(ImmutableEndpoint endpoint) {
        if (this.serviceDescriptor == null) {
            throw new RuntimeException("serviceDescriptor not initialized");
        }
        return TransformerUtils.getDefaultResponseTransformers(this.serviceDescriptor, endpoint);
    }

    public List<Transformer> getDefaultOutboundTransformers(ImmutableEndpoint endpoint) {
        if (this.serviceDescriptor == null) {
            throw new RuntimeException("serviceDescriptor not initialized");
        }
        return TransformerUtils.getDefaultOutboundTransformers(this.serviceDescriptor, endpoint);
    }

    public ReplyToHandler getReplyToHandler(ImmutableEndpoint endpoint) {
        return new DefaultReplyToHandler(endpoint.getMuleContext());
    }

    @Override
    public String getCanonicalURI(EndpointURI uri) {
        return uri.toString();
    }

    public void fireNotification(ServerNotification notification) {
        this.cachedNotificationHandler.fireNotification(notification);
    }

    @Override
    public boolean isResponseEnabled() {
        return false;
    }

    public MessageReceiver getReceiver(FlowConstruct flowConstruct, InboundEndpoint endpoint) {
        if (this.receivers != null) {
            Object key = this.getReceiverKey(flowConstruct, endpoint);
            if (key != null) {
                return this.receivers.get(key);
            }
            throw new RuntimeException("getReceiverKey() returned a null key");
        }
        throw new RuntimeException("Connector has not been initialized.");
    }

    public Map<Object, MessageReceiver> getReceivers() {
        return Collections.unmodifiableMap(this.receivers);
    }

    public MessageReceiver lookupReceiver(String key) {
        if (key != null) {
            return this.receivers.get(key);
        }
        throw new IllegalArgumentException("Receiver key must not be null");
    }

    public MessageReceiver[] getReceivers(String wildcardExpression) {
        WildcardFilter filter = new WildcardFilter(wildcardExpression);
        filter.setCaseSensitive(false);
        ArrayList<MessageReceiver> found = new ArrayList<MessageReceiver>();
        for (Map.Entry<Object, MessageReceiver> e : this.receivers.entrySet()) {
            if (!filter.accept(e.getKey())) continue;
            found.add(e.getValue());
        }
        return CollectionUtils.toArrayOfComponentType(found, MessageReceiver.class);
    }

    @Override
    public void connect() throws Exception {
        if (this.lifecycleManager.getState().isDisposed()) {
            throw new LifecycleException(CoreMessages.lifecycleErrorCannotUseConnector(this.getName(), this.lifecycleManager.getCurrentPhase()), (Object)this);
        }
        if (this.isConnected()) {
            return;
        }
        RetryCallback callback = new RetryCallback(){

            @Override
            public void doWork(RetryContext context) throws Exception {
                Connectable failed;
                if (AbstractConnector.this.validateConnections && context.getLastFailure() instanceof ConnectException && !(failed = ((ConnectException)context.getLastFailure()).getFailed()).validateConnection(context).isOk()) {
                    throw new ConnectException(MessageFactory.createStaticMessage("Still unable to connect to resource " + failed.getClass().getName()), context.getLastFailure(), failed);
                }
                AbstractConnector.this.doConnect();
                if (AbstractConnector.this.receivers != null) {
                    for (MessageReceiver receiver : AbstractConnector.this.receivers.values()) {
                        ArrayList<MuleException> errors = new ArrayList<MuleException>();
                        try {
                            if (AbstractConnector.this.logger.isDebugEnabled()) {
                                AbstractConnector.this.logger.debug((Object)("Connecting receiver on endpoint: " + receiver.getEndpoint().getEndpointURI()));
                            }
                            receiver.connect();
                            if (AbstractConnector.this.isStarted()) {
                                receiver.start();
                            }
                        }
                        catch (MuleException e) {
                            AbstractConnector.this.logger.error((Object)e);
                            errors.add(e);
                        }
                        if (errors.isEmpty()) continue;
                        throw (MuleException)errors.get(0);
                    }
                }
                AbstractConnector.this.setConnected(true);
                AbstractConnector.this.setConnecting(false);
                AbstractConnector.this.logger.info((Object)("Connected: " + this.getWorkDescription()));
                if (AbstractConnector.this.startOnConnect && !AbstractConnector.this.isStarted() && !AbstractConnector.this.isStarting()) {
                    AbstractConnector.this.startAfterConnect();
                }
            }

            @Override
            public String getWorkDescription() {
                return AbstractConnector.this.getConnectionDescription();
            }
        };
        if (this.connecting.compareAndSet(false, true)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Connecting: " + this));
            }
            this.retryPolicyTemplate.execute(callback, this.muleContext.getWorkManager());
        }
    }

    @Override
    public RetryContext validateConnection(RetryContext retryContext) {
        retryContext.setOk();
        return retryContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() throws Exception {
        if (this.isStarted()) {
            this.startOnConnect = true;
            this.stop();
        }
        if (this.receivers != null) {
            for (MessageReceiver receiver : this.receivers.values()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Disconnecting receiver on endpoint: " + receiver.getEndpoint().getEndpointURI()));
                }
                try {
                    receiver.disconnect();
                }
                catch (Exception e) {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        try {
            if (this.isStarted() && !this.isStopping()) {
                this.stop();
            }
            this.doDisconnect();
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Disconnected: " + this.getConnectionDescription()));
            }
            this.fireNotification(new ConnectionNotification(this, this.getConnectEventId(), 703));
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage());
        }
        finally {
            this.connected.set(false);
        }
    }

    @Override
    public String getConnectionDescription() {
        return this.toString();
    }

    @Override
    public final boolean isConnected() {
        return this.connected.get();
    }

    public final void setConnected(boolean flag) {
        this.connected.set(flag);
    }

    public final void setConnecting(boolean flag) {
        this.connecting.set(flag);
    }

    public final boolean isConnecting() {
        return this.connecting.get();
    }

    protected abstract void doConnect() throws Exception;

    protected abstract void doDisconnect() throws Exception;

    protected String getConnectEventId() {
        return this.getName();
    }

    public boolean isCreateMultipleTransactedReceivers() {
        return this.createMultipleTransactedReceivers;
    }

    public void setCreateMultipleTransactedReceivers(boolean createMultipleTransactedReceivers) {
        this.createMultipleTransactedReceivers = createMultipleTransactedReceivers;
    }

    public int getNumberOfConcurrentTransactedReceivers() {
        return this.numberOfConcurrentTransactedReceivers;
    }

    public void setNumberOfConcurrentTransactedReceivers(int count) {
        this.numberOfConcurrentTransactedReceivers = count;
    }

    public void setDynamicNotification(boolean dynamic) {
        this.dynamicNotification = dynamic;
    }

    protected void updateCachedNotificationHandler() {
        if (null != this.muleContext) {
            this.cachedNotificationHandler = this.dynamicNotification ? this.muleContext.getNotificationManager() : new OptimisedNotificationHandler(this.muleContext.getNotificationManager(), EndpointMessageNotification.class);
        }
    }

    public boolean isEnableMessageEvents() {
        return this.cachedNotificationHandler.isNotificationEnabled(EndpointMessageNotification.class);
    }

    public void registerSupportedProtocol(String protocol) {
        if ((protocol = protocol.toLowerCase()).startsWith(this.getProtocol().toLowerCase())) {
            this.registerSupportedProtocolWithoutPrefix(protocol);
        } else {
            this.supportedProtocols.add(this.getProtocol().toLowerCase() + ":" + protocol);
        }
    }

    public void registerSupportedMetaProtocol(String protocol) {
        this.supportedProtocols.add(protocol.toLowerCase() + ":" + this.getProtocol().toLowerCase());
    }

    protected void registerSupportedProtocolWithoutPrefix(String protocol) {
        this.supportedProtocols.add(protocol.toLowerCase());
    }

    public void unregisterSupportedProtocol(String protocol) {
        if ((protocol = protocol.toLowerCase()).startsWith(this.getProtocol().toLowerCase())) {
            this.supportedProtocols.remove(protocol);
        } else {
            this.supportedProtocols.remove(this.getProtocol().toLowerCase() + ":" + protocol);
        }
    }

    @Override
    public boolean supportsProtocol(String protocol) {
        return this.supportedProtocols.contains(protocol.toLowerCase());
    }

    public List getSupportedProtocols() {
        return Collections.unmodifiableList(this.supportedProtocols);
    }

    public void setSupportedProtocols(List supportedProtocols) {
        for (String s : supportedProtocols) {
            this.registerSupportedProtocol(s);
        }
    }

    protected WorkManager getReceiverWorkManager() throws MuleException {
        return this.receiverWorkManager.get();
    }

    protected WorkManager getDispatcherWorkManager() throws MuleException {
        return this.dispatcherWorkManager.get();
    }

    protected WorkManager getRequesterWorkManager() throws MuleException {
        return this.requesterWorkManager.get();
    }

    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    protected ScheduledExecutorService createScheduler() {
        NamedThreadFactory threadFactory = new NamedThreadFactory(this.getName() + ".scheduler");
        ScheduledThreadPoolExecutor newExecutor = new ScheduledThreadPoolExecutor(4, threadFactory);
        newExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        newExecutor.setKeepAliveTime(this.getReceiverThreadingProfile().getThreadTTL(), TimeUnit.MILLISECONDS);
        newExecutor.allowCoreThreadTimeOut(true);
        return newExecutor;
    }

    @Override
    public SessionHandler getSessionHandler() {
        return this.sessionHandler;
    }

    @Override
    public AbstractRedeliveryPolicy createDefaultRedeliveryPolicy(int maxRedelivery) {
        IdempotentRedeliveryPolicy idempotentRedeliveryPolicy = new IdempotentRedeliveryPolicy();
        idempotentRedeliveryPolicy.setUseSecureHash(true);
        idempotentRedeliveryPolicy.setMaxRedeliveryCount(maxRedelivery);
        return idempotentRedeliveryPolicy;
    }

    public final <T> T getTransactionalResource(ImmutableEndpoint endpoint) throws MuleException {
        Transaction currentTx = TransactionCoordination.getInstance().getTransaction();
        if (currentTx != null) {
            if (currentTx.hasResource(this.getOperationResourceFactory())) {
                return (T)currentTx.getResource(this.getOperationResourceFactory());
            }
            T connectionResource = this.createOperationResource(endpoint);
            if (currentTx.supports(this.getOperationResourceFactory(), connectionResource)) {
                currentTx.bindResource(this.getOperationResourceFactory(), connectionResource);
            } else if (endpoint.getTransactionConfig().isTransacted()) {
                throw new TransactionException(CoreMessages.createStaticMessage("Endpoint is transactional but transaction does not support it"));
            }
            return connectionResource;
        }
        return this.createOperationResource(endpoint);
    }

    protected <T> T createOperationResource(ImmutableEndpoint endpoint) throws MuleException {
        throw new MuleRuntimeException(CoreMessages.createStaticMessage("Operation not supported by dispatcher"));
    }

    protected <T> T getOperationResourceFactory() {
        throw new MuleRuntimeException(CoreMessages.createStaticMessage("Operation not supported by dispatcher"));
    }

    public void setSessionHandler(SessionHandler sessionHandler) {
        this.sessionHandler = sessionHandler;
    }

    public void workAccepted(WorkEvent event) {
        this.handleWorkException(event, "workAccepted");
    }

    public void workRejected(WorkEvent event) {
        this.handleWorkException(event, "workRejected");
    }

    public void workStarted(WorkEvent event) {
        this.handleWorkException(event, "workStarted");
    }

    public void workCompleted(WorkEvent event) {
        this.handleWorkException(event, "workCompleted");
    }

    protected void handleWorkException(WorkEvent event, String type) {
        if (event == null) {
            return;
        }
        Throwable e = event.getException();
        if (e == null) {
            return;
        }
        if (e.getCause() != null) {
            e = e.getCause();
        }
        this.logger.error((Object)("Work caused exception on '" + type + "'. Work being executed was: " + event.getWork().toString()));
        if (e instanceof MessagingException) {
            MuleEvent failedEvent = ((MessagingException)e).getEvent();
            failedEvent.getFlowConstruct().getExceptionListener().handleException((MessagingException)e, failedEvent);
        } else if (e instanceof Exception) {
            this.muleContext.getExceptionListener().handleException((Exception)e);
        } else {
            this.muleContext.getExceptionListener().handleException(new MuleRuntimeException(CoreMessages.connectorCausedError(this.getName()), e));
        }
    }

    protected void setupDispatchReturn(final OutboundEndpoint endpoint, final MessageDispatcher dispatcher, MuleMessage result) {
        if (result != null && result.getPayload() instanceof InputStream) {
            DelegatingInputStream is = new DelegatingInputStream((InputStream)result.getPayload()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        AbstractConnector.this.returnDispatcher(endpoint, dispatcher);
                    }
                }
            };
            result.setPayload(is);
        } else {
            this.returnDispatcher(endpoint, dispatcher);
        }
    }

    @Override
    public MuleMessage request(String uri, long timeout) throws Exception {
        return this.request(this.getMuleContext().getEndpointFactory().getInboundEndpoint(uri), timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MuleMessage request(InboundEndpoint endpoint, long timeout) throws Exception {
        MessageRequester requester = null;
        MuleMessage result = null;
        try {
            requester = this.getRequester(endpoint);
            MuleMessage muleMessage = result = requester.request(timeout);
            this.setupRequestReturn(endpoint, requester, result);
            return muleMessage;
        }
        catch (Throwable throwable) {
            this.setupRequestReturn(endpoint, requester, result);
            throw throwable;
        }
    }

    protected void setupRequestReturn(final InboundEndpoint endpoint, final MessageRequester requester, MuleMessage result) {
        if (result != null && result.getPayload() instanceof InputStream) {
            DelegatingInputStream is = new DelegatingInputStream((InputStream)result.getPayload()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        AbstractConnector.this.returnRequester(endpoint, requester);
                    }
                }
            };
            result.setPayload(is);
        } else {
            this.returnRequester(endpoint, requester);
        }
    }

    public void initialiseFromUrl(EndpointURI endpointUri) throws InitialisationException {
        String host;
        if (!this.supportsProtocol(endpointUri.getFullScheme())) {
            throw new InitialisationException(CoreMessages.schemeNotCompatibleWithConnector(endpointUri.getFullScheme(), this.getClass()), (Initialisable)this);
        }
        Properties props = new Properties();
        props.putAll((Map<?, ?>)endpointUri.getParams());
        if (endpointUri.getUserInfo() != null) {
            props.setProperty("username", endpointUri.getUser());
            String passwd = endpointUri.getPassword();
            if (passwd != null) {
                props.setProperty("password", passwd);
            }
        }
        if ((host = endpointUri.getHost()) != null) {
            props.setProperty("hostname", host);
            props.setProperty("host", host);
        }
        if (endpointUri.getPort() > -1) {
            props.setProperty("port", String.valueOf(endpointUri.getPort()));
        }
        BeanUtils.populateWithoutFail(this, props, true);
        this.setName(new ObjectNameHelper(this.muleContext).getConnectorName(this));
    }

    protected synchronized void initFromServiceDescriptor() throws InitialisationException {
        try {
            MessageRequesterFactory rf;
            MessageDispatcherFactory df;
            this.serviceDescriptor = (TransportServiceDescriptor)this.muleContext.getRegistry().lookupServiceDescriptor(ServiceType.TRANSPORT, this.getProtocol().toLowerCase(), this.serviceOverrides);
            if (this.serviceDescriptor == null) {
                throw new ServiceException(CoreMessages.noServiceTransportDescriptor(this.getProtocol()));
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Loading DispatcherFactory for connector: " + this.getName() + " (" + this.getClass().getName() + ")"));
            }
            if ((df = this.serviceDescriptor.createDispatcherFactory()) != null) {
                this.setDispatcherFactory(df);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Transport '" + this.getProtocol() + "' will not support outbound endpoints: "));
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Loading RequesterFactory for connector: " + this.getName() + " (" + this.getClass().getName() + ")"));
            }
            if ((rf = this.serviceDescriptor.createRequesterFactory()) != null) {
                this.setRequesterFactory(rf);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Transport '" + this.getProtocol() + "' will not support requests: "));
            }
            this.sessionHandler = this.serviceDescriptor.createSessionHandler();
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    protected TransportServiceDescriptor getServiceDescriptor() {
        if (this.serviceDescriptor == null) {
            throw new IllegalStateException("This connector has not yet been initialised: " + this.name);
        }
        return this.serviceDescriptor;
    }

    protected MessageReceiver createReceiver(FlowConstruct flowConstruct, InboundEndpoint endpoint) throws Exception {
        return this.getServiceDescriptor().createMessageReceiver(this, flowConstruct, endpoint);
    }

    public Map getServiceOverrides() {
        return this.serviceOverrides;
    }

    public void setServiceOverrides(Map serviceOverrides) {
        this.serviceOverrides = new Properties();
        this.serviceOverrides.putAll((Map<?, ?>)serviceOverrides);
    }

    @Override
    public OutputStream getOutputStream(OutboundEndpoint endpoint, MuleEvent event) throws MuleException {
        throw new UnsupportedOperationException(CoreMessages.streamingNotSupported(this.getProtocol()).toString());
    }

    @Override
    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(120);
        String nl = System.getProperty("line.separator");
        sb.append(ClassUtils.getSimpleName(this.getClass()));
        sb.append(nl);
        sb.append("{");
        sb.append(nl);
        sb.append("  name=").append(this.name);
        sb.append(nl);
        sb.append("  lifecycle=").append(this.lifecycleManager == null ? "<not in lifecycle>" : this.lifecycleManager.getCurrentPhase());
        sb.append(nl);
        sb.append("  this=").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(nl);
        sb.append("  numberOfConcurrentTransactedReceivers=").append(this.numberOfConcurrentTransactedReceivers);
        sb.append(nl);
        sb.append("  createMultipleTransactedReceivers=").append(this.createMultipleTransactedReceivers);
        sb.append(nl);
        sb.append("  connected=").append(this.connected);
        sb.append(nl);
        sb.append("  supportedProtocols=").append(this.supportedProtocols);
        sb.append(nl);
        sb.append("  serviceOverrides=");
        if (this.serviceOverrides != null) {
            for (Map.Entry<Object, Object> entry : this.serviceOverrides.entrySet()) {
                sb.append(nl);
                sb.append("    ").append(String.format("%s=%s", entry.getKey(), entry.getValue()));
            }
        } else {
            sb.append("<none>");
        }
        sb.append(nl);
        sb.append('}');
        sb.append(nl);
        return sb.toString();
    }

    @Override
    public RetryPolicyTemplate getRetryPolicyTemplate() {
        return this.retryPolicyTemplate;
    }

    public void setRetryPolicyTemplate(RetryPolicyTemplate retryPolicyTemplate) {
        this.retryPolicyTemplate = retryPolicyTemplate;
    }

    public boolean isValidateConnections() {
        return this.validateConnections;
    }

    public void setValidateConnections(boolean validateConnections) {
        this.validateConnections = validateConnections;
    }

    public void setDispatcherPoolWhenExhaustedAction(byte whenExhaustedAction) {
        this.checkDispatchersInitialised();
        this.dispatchers.setWhenExhaustedAction(whenExhaustedAction);
    }

    public void setDispatcherPoolMaxWait(int maxWait) {
        this.checkDispatchersInitialised();
        this.dispatchers.setMaxWait(maxWait);
    }

    public void setDispatcherPoolFactory(ConfigurableKeyedObjectPoolFactory dispatcherPoolFactory) {
        this.dispatcherPoolFactory = dispatcherPoolFactory;
    }

    public ConfigurableKeyedObjectPoolFactory getDispatcherPoolFactory() {
        return this.dispatcherPoolFactory;
    }

    public void setRequesterPoolWhenExhaustedAction(byte whenExhaustedAction) {
        this.requesters.setWhenExhaustedAction(whenExhaustedAction);
    }

    public void setRequesterPoolMaxWait(int maxWait) {
        this.requesters.setMaxWait((long)maxWait);
    }

    public MessageProcessor createDispatcherMessageProcessor(OutboundEndpoint endpoint) throws MuleException {
        if (endpoint.getExchangePattern().hasResponse() || !this.getDispatcherThreadingProfile().isDoThreading()) {
            return new DispatcherMessageProcessor(endpoint);
        }
        SimpleMessageProcessorChainBuilder builder = new SimpleMessageProcessorChainBuilder();
        builder.setName("dispatcher processor chain for '" + endpoint.getAddress() + "'");
        LaxAsyncInterceptingMessageProcessor async = new LaxAsyncInterceptingMessageProcessor(new WorkManagerSource(){

            @Override
            public WorkManager getWorkManager() throws MuleException {
                return AbstractConnector.this.getDispatcherWorkManager();
            }
        });
        builder.chain(async);
        builder.chain(new DispatcherMessageProcessor(endpoint));
        return builder.build();
    }

    @Override
    public MessageExchangePattern getDefaultExchangePattern() {
        try {
            return this.serviceDescriptor.getDefaultExchangePattern();
        }
        catch (TransportServiceException tse) {
            throw new MuleRuntimeException(tse);
        }
    }

    @Override
    public List<MessageExchangePattern> getInboundExchangePatterns() {
        try {
            return this.serviceDescriptor.getInboundExchangePatterns();
        }
        catch (TransportServiceException tse) {
            throw new MuleRuntimeException(tse);
        }
    }

    @Override
    public List<MessageExchangePattern> getOutboundExchangePatterns() {
        try {
            return this.serviceDescriptor.getOutboundExchangePatterns();
        }
        catch (TransportServiceException tse) {
            throw new MuleRuntimeException(tse);
        }
    }

    class DispatcherMessageProcessor
    implements MessageProcessor {
        private OutboundNotificationMessageProcessor notificationMessageProcessor;
        private OutboundEndpoint endpoint;

        public DispatcherMessageProcessor(OutboundEndpoint endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public MuleEvent process(MuleEvent event) throws MuleException {
            MessageDispatcher dispatcher = null;
            try {
                dispatcher = AbstractConnector.this.borrowDispatcher(this.endpoint);
                boolean fireNotification = event.isNotificationsEnabled();
                EndpointMessageNotification beginNotification = null;
                if (fireNotification) {
                    if (this.notificationMessageProcessor == null) {
                        this.notificationMessageProcessor = new OutboundNotificationMessageProcessor(this.endpoint);
                    }
                    beginNotification = this.notificationMessageProcessor.createBeginNotification(event);
                }
                MuleEvent result = dispatcher.process(event);
                if (fireNotification) {
                    this.notificationMessageProcessor.dispatchNotification(beginNotification);
                    this.notificationMessageProcessor.process(result != null && !VoidMuleEvent.getInstance().equals(result) ? result : event);
                }
                MuleEvent muleEvent = result;
                return muleEvent;
            }
            catch (DispatchException dex) {
                throw dex;
            }
            catch (MuleException ex) {
                throw new DispatchException(event, this.endpoint, (Throwable)ex);
            }
            finally {
                AbstractConnector.this.returnDispatcher(this.endpoint, dispatcher);
            }
        }

        public String toString() {
            return ObjectUtils.toString(this);
        }
    }
}

