/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.collection;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleMessageCollection;
import org.mule.config.i18n.CoreMessages;
import org.mule.routing.MessageSequence;
import org.mule.routing.outbound.ArrayMessageSequence;
import org.mule.routing.outbound.CollectionMessageSequence;
import org.mule.routing.outbound.IteratorMessageSequence;
import org.mule.util.collection.SplittingStrategy;

public class EventToMessageSequenceSplittingStrategy
implements SplittingStrategy<MuleEvent, MessageSequence<?>> {
    @Override
    public MessageSequence<?> split(MuleEvent event) {
        MuleMessage msg = event.getMessage();
        if (msg instanceof MuleMessageCollection) {
            return new ArrayMessageSequence(((MuleMessageCollection)msg).getMessagesAsArray());
        }
        Object payload = msg.getPayload();
        if (payload instanceof MessageSequence) {
            return (MessageSequence)payload;
        }
        if (payload instanceof Iterator) {
            return new IteratorMessageSequence((Iterator)payload);
        }
        if (payload instanceof Collection) {
            return new CollectionMessageSequence(new LinkedList((Collection)payload));
        }
        if (payload instanceof Iterable) {
            return new IteratorMessageSequence(((Iterable)payload).iterator());
        }
        if (payload instanceof Object[]) {
            return new ArrayMessageSequence((Object[])payload);
        }
        throw new IllegalArgumentException(CoreMessages.objectNotOfCorrectType(payload.getClass(), new Class[]{Iterable.class, Iterator.class, MessageSequence.class, Collection.class}).getMessage());
    }
}

