/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.store;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import org.mule.api.store.ObjectAlreadyExistsException;
import org.mule.api.store.ObjectDoesNotExistException;
import org.mule.api.store.ObjectStoreException;
import org.mule.api.store.PartitionableExpirableObjectStore;
import org.mule.util.store.AbstractPartitionedObjectStore;

public class PartitionedInMemoryObjectStore<T extends Serializable>
extends AbstractPartitionedObjectStore<T>
implements PartitionableExpirableObjectStore<T> {
    private ConcurrentMap<String, ConcurrentMap<Serializable, T>> partitions = new ConcurrentHashMap<String, ConcurrentMap<Serializable, T>>();
    private ConcurrentMap<String, ConcurrentSkipListMap<Long, Serializable>> expiryInfoPartition = new ConcurrentHashMap<String, ConcurrentSkipListMap<Long, Serializable>>();

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public boolean contains(Serializable key, String partitionName) throws ObjectStoreException {
        if (this.partitions.containsKey(partitionName)) {
            return ((ConcurrentMap)this.partitions.get(partitionName)).containsKey(key);
        }
        return false;
    }

    @Override
    public void store(Serializable key, T value, String partitionName) throws ObjectStoreException {
        Serializable oldValue = (Serializable)this.getPartition(partitionName).putIfAbsent(key, value);
        if (oldValue != null) {
            throw new ObjectAlreadyExistsException();
        }
        this.getExpirtyInfoPartition(partitionName).put(System.nanoTime(), key);
    }

    @Override
    public T retrieve(Serializable key, String partitionName) throws ObjectStoreException {
        Serializable value = (Serializable)this.getPartition(partitionName).get(key);
        if (value == null) {
            throw new ObjectDoesNotExistException();
        }
        return (T)value;
    }

    @Override
    public T remove(Serializable key, String partitionName) throws ObjectStoreException {
        Serializable removedValue = (Serializable)this.getPartition(partitionName).remove(key);
        if (removedValue == null) {
            throw new ObjectDoesNotExistException();
        }
        Iterator<Map.Entry<Long, Serializable>> localIterator = this.getExpirtyInfoPartition(partitionName).entrySet().iterator();
        Long timestamp = null;
        while (localIterator.hasNext()) {
            Map.Entry<Long, Serializable> localEntry = localIterator.next();
            if (!key.equals(localEntry.getValue())) continue;
            timestamp = localEntry.getKey();
            break;
        }
        this.getExpirtyInfoPartition(partitionName).remove(timestamp);
        return (T)removedValue;
    }

    @Override
    public List<Serializable> allKeys(String partitionName) throws ObjectStoreException {
        return new ArrayList<Serializable>(this.getPartition(partitionName).keySet());
    }

    @Override
    public void clear(String partitionName) throws ObjectStoreException {
        this.getPartition(partitionName).clear();
    }

    @Override
    public List<String> allPartitions() throws ObjectStoreException {
        return new ArrayList<String>(this.partitions.keySet());
    }

    private ConcurrentMap<Serializable, T> getPartition(String partitionName) {
        ConcurrentMap previous;
        ConcurrentMap partition = (ConcurrentHashMap)this.partitions.get(partitionName);
        if (partition == null && (previous = (ConcurrentMap)this.partitions.putIfAbsent(partitionName, partition = new ConcurrentHashMap())) != null) {
            partition = previous;
        }
        return partition;
    }

    private ConcurrentSkipListMap<Long, Serializable> getExpirtyInfoPartition(String partitionName) {
        ConcurrentSkipListMap previous;
        ConcurrentSkipListMap partition = (ConcurrentSkipListMap)this.expiryInfoPartition.get(partitionName);
        if (partition == null && (previous = this.expiryInfoPartition.putIfAbsent(partitionName, partition = new ConcurrentSkipListMap())) != null) {
            partition = previous;
        }
        return partition;
    }

    @Override
    public void open(String partitionName) throws ObjectStoreException {
    }

    @Override
    public void close(String partitionName) throws ObjectStoreException {
    }

    @Override
    public void expire(int entryTTL, int maxEntries) throws ObjectStoreException {
        this.expire(entryTTL, maxEntries, "DEFAULT_PARTITION");
    }

    @Override
    public void expire(int entryTTL, int maxEntries, String partitionName) throws ObjectStoreException {
        Long oldestKey;
        long oldestKeyValue;
        Map.Entry<Long, Serializable> oldestEntry;
        long now = System.nanoTime();
        int expiredEntries = 0;
        ConcurrentSkipListMap<Long, Serializable> store = this.getExpirtyInfoPartition(partitionName);
        ConcurrentMap<Serializable, T> partition = this.getPartition(partitionName);
        this.trimToMaxSize(store, maxEntries, partition);
        if (entryTTL == 0) {
            return;
        }
        while ((oldestEntry = store.firstEntry()) != null && TimeUnit.NANOSECONDS.toMillis(now - (oldestKeyValue = (oldestKey = oldestEntry.getKey()).longValue())) >= (long)entryTTL) {
            partition.remove(oldestEntry.getValue());
            store.remove(oldestKey);
            ++expiredEntries;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Expired " + expiredEntries + " old entries"));
        }
    }

    private void trimToMaxSize(ConcurrentSkipListMap<Long, Serializable> store, int maxEntries, ConcurrentMap<Serializable, T> partition) {
        if (maxEntries == 0) {
            return;
        }
        int currentSize = store.size();
        int excess = currentSize - maxEntries;
        if (excess > 0) {
            while (currentSize > maxEntries) {
                Map.Entry<Long, Serializable> toRemove = store.pollFirstEntry();
                partition.remove(toRemove.getValue());
                --currentSize;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Expired " + excess + " excess entries"));
            }
        }
    }

    @Override
    public void disposePartition(String partitionName) throws ObjectStoreException {
        this.partitions.remove(partitionName);
        this.expiryInfoPartition.remove(partitionName);
    }
}

