/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.transaction;

import java.util.Properties;
import javax.transaction.TransactionManager;
import org.hibernate.HibernateException;
import org.hibernate.transaction.TransactionManagerLookup;
import org.hibernate.util.ReflectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransactionManagerLookupFactory {
    private static final Logger log = LoggerFactory.getLogger(TransactionManagerLookupFactory.class);

    private TransactionManagerLookupFactory() {
    }

    public static TransactionManager getTransactionManager(Properties props) throws HibernateException {
        log.info("obtaining TransactionManager");
        return TransactionManagerLookupFactory.getTransactionManagerLookup(props).getTransactionManager(props);
    }

    public static TransactionManagerLookup getTransactionManagerLookup(Properties props) throws HibernateException {
        String tmLookupClass = props.getProperty("hibernate.transaction.manager_lookup_class");
        if (tmLookupClass == null) {
            log.info("No TransactionManagerLookup configured (in JTA environment, use of read-write or transactional second-level cache is not recommended)");
            return null;
        }
        log.info("instantiating TransactionManagerLookup: " + tmLookupClass);
        try {
            TransactionManagerLookup lookup = (TransactionManagerLookup)ReflectHelper.classForName(tmLookupClass).newInstance();
            log.info("instantiated TransactionManagerLookup");
            return lookup;
        }
        catch (Exception e) {
            log.error("Could not instantiate TransactionManagerLookup", (Throwable)e);
            throw new HibernateException("Could not instantiate TransactionManagerLookup '" + tmLookupClass + "'");
        }
    }
}

