/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.interceptors;

import java.util.Collection;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.ws.addressing.MAPAggregator;
import org.apache.cxf.ws.addressing.policy.MetadataConstants;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.policy.EndpointPolicy;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.cxf.ws.policy.builder.primitive.PrimitiveAssertion;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.model.AlgorithmSuite;
import org.apache.cxf.ws.security.policy.model.Trust10;
import org.apache.cxf.ws.security.policy.model.Trust13;
import org.apache.cxf.ws.security.tokenstore.MemoryTokenStore;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.tokenstore.TokenStore;
import org.apache.cxf.ws.security.trust.STSUtils;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.conversation.ConversationConstants;
import org.apache.ws.security.conversation.ConversationException;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.message.token.SecurityContextToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NegotiationUtils {
    private NegotiationUtils() {
    }

    static Trust10 getTrust10(AssertionInfoMap aim) {
        Collection ais = (Collection)aim.get((Object)"Trust10");
        if (ais == null || ais.isEmpty()) {
            ais = (Collection)aim.get((Object)SP11Constants.TRUST_10);
        }
        if (ais == null || ais.isEmpty()) {
            return null;
        }
        return (Trust10)((AssertionInfo)ais.iterator().next()).getAssertion();
    }

    static Trust13 getTrust13(AssertionInfoMap aim) {
        Collection ais = (Collection)aim.get((Object)SP12Constants.TRUST_13);
        if (ais == null || ais.isEmpty()) {
            return null;
        }
        return (Trust13)((AssertionInfo)ais.iterator().next()).getAssertion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TokenStore getTokenStore(Message message) {
        EndpointInfo info;
        EndpointInfo endpointInfo = info = ((Endpoint)message.getExchange().get(Endpoint.class)).getEndpointInfo();
        synchronized (endpointInfo) {
            TokenStore tokenStore = (TokenStore)message.getContextualProperty(TokenStore.class.getName());
            if (tokenStore == null) {
                tokenStore = (TokenStore)info.getProperty(TokenStore.class.getName());
            }
            if (tokenStore == null) {
                tokenStore = new MemoryTokenStore();
                info.setProperty(TokenStore.class.getName(), (Object)tokenStore);
            }
            return tokenStore;
        }
    }

    static Assertion getAddressingPolicy(AssertionInfoMap aim, boolean optional) {
        Collection lst = (Collection)aim.get((Object)MetadataConstants.USING_ADDRESSING_2004_QNAME);
        Assertion assertion = null;
        if (null != lst && !lst.isEmpty()) {
            assertion = ((AssertionInfo)lst.iterator().next()).getAssertion();
        }
        if (assertion == null && null != (lst = (Collection)aim.get((Object)MetadataConstants.USING_ADDRESSING_2005_QNAME)) && !lst.isEmpty()) {
            assertion = ((AssertionInfo)lst.iterator().next()).getAssertion();
        }
        if (assertion == null && null != (lst = (Collection)aim.get((Object)MetadataConstants.USING_ADDRESSING_2006_QNAME)) && !lst.isEmpty()) {
            assertion = ((AssertionInfo)lst.iterator().next()).getAssertion();
        }
        if (assertion == null) {
            return new PrimitiveAssertion(MetadataConstants.USING_ADDRESSING_2006_QNAME, optional);
        }
        if (optional) {
            return new PrimitiveAssertion(assertion.getName(), optional);
        }
        return assertion;
    }

    static AlgorithmSuite getAlgorithmSuite(AssertionInfoMap aim) {
        org.apache.cxf.ws.security.policy.model.Binding transport = null;
        Collection ais = (Collection)aim.get((Object)SP12Constants.TRANSPORT_BINDING);
        if (ais != null) {
            for (AssertionInfo ai : ais) {
                transport = (org.apache.cxf.ws.security.policy.model.Binding)ai.getAssertion();
            }
        } else {
            ais = (Collection)aim.get((Object)SP12Constants.ASYMMETRIC_BINDING);
            if (ais != null) {
                for (AssertionInfo ai : ais) {
                    transport = (org.apache.cxf.ws.security.policy.model.Binding)ai.getAssertion();
                }
            } else {
                ais = (Collection)aim.get((Object)SP12Constants.SYMMETRIC_BINDING);
                if (ais != null) {
                    for (AssertionInfo ai : ais) {
                        transport = (org.apache.cxf.ws.security.policy.model.Binding)ai.getAssertion();
                    }
                }
            }
        }
        if (transport != null) {
            return transport.getAlgorithmSuite();
        }
        return null;
    }

    static int getWSCVersion(String tokenTypeValue) throws ConversationException {
        if (tokenTypeValue == null) {
            return 1;
        }
        if (tokenTypeValue.startsWith("http://schemas.xmlsoap.org/ws/2005/02/sc")) {
            return ConversationConstants.getWSTVersion((String)"http://schemas.xmlsoap.org/ws/2005/02/sc");
        }
        if (tokenTypeValue.startsWith("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512")) {
            return ConversationConstants.getWSTVersion((String)"http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512");
        }
        throw new ConversationException("unsupportedSecConvVersion");
    }

    static void recalcEffectivePolicy(SoapMessage message, String namespace, Policy policy, Invoker invoker, boolean secConv) {
        Exchange ex = message.getExchange();
        Bus bus = ex.getBus();
        PolicyEngine pe = (PolicyEngine)bus.getExtension(PolicyEngine.class);
        if (null == pe) {
            return;
        }
        Destination destination = ex.getDestination();
        try {
            Endpoint endpoint = message.getExchange().getEndpoint();
            TokenStore store = (TokenStore)message.getContextualProperty(TokenStore.class.getName());
            if (store == null) {
                store = new MemoryTokenStore();
                endpoint.getEndpointInfo().setProperty(TokenStore.class.getName(), (Object)store);
            }
            endpoint = secConv ? STSUtils.createSCEndpoint(bus, namespace, endpoint.getEndpointInfo().getTransportId(), destination.getAddress().getAddress().getValue(), message.getVersion().getBindingId(), policy) : STSUtils.createSTSEndpoint(bus, namespace, endpoint.getEndpointInfo().getTransportId(), destination.getAddress().getAddress().getValue(), message.getVersion().getBindingId(), policy, null);
            endpoint.getEndpointInfo().setProperty(TokenStore.class.getName(), (Object)store);
            message.getExchange().put((Object)TokenStore.class.getName(), (Object)store);
            EndpointPolicy ep = pe.getServerEndpointPolicy(endpoint.getEndpointInfo(), destination);
            List interceptors = ep.getInterceptors();
            for (Interceptor i : interceptors) {
                message.getInterceptorChain().add(i);
            }
            Collection assertions = ep.getVocabulary();
            if (null != assertions) {
                message.put(AssertionInfoMap.class, (Object)new AssertionInfoMap(assertions));
            }
            endpoint.getService().setInvoker(invoker);
            ex.put(Endpoint.class, (Object)endpoint);
            ex.put(Service.class, (Object)endpoint.getService());
            ex.put(Binding.class, (Object)endpoint.getBinding());
            ex.remove(BindingOperationInfo.class);
            message.put(MAPAggregator.ACTION_VERIFIED, (Object)Boolean.TRUE);
        }
        catch (Exception exc) {
            throw new Fault((Throwable)exc);
        }
    }

    static boolean parseSCTResult(SoapMessage message) {
        List results = CastUtils.cast((List)((List)message.get((Object)"RECV_RESULTS")));
        if (results == null) {
            return false;
        }
        for (WSHandlerResult rResult : results) {
            List wsSecEngineResults = rResult.getResults();
            for (WSSecurityEngineResult wser : wsSecEngineResults) {
                Integer actInt = (Integer)wser.get((Object)"action");
                if (actInt != 1024) continue;
                SecurityContextToken tok = (SecurityContextToken)wser.get((Object)"security-context-token");
                message.getExchange().put((Object)"ws-security.token.id", (Object)tok.getIdentifier());
                byte[] secret = (byte[])wser.get((Object)"secret");
                if (secret != null) {
                    SecurityToken token = new SecurityToken(tok.getIdentifier());
                    token.setToken(tok.getElement());
                    token.setSecret(secret);
                    token.setTokenType(tok.getTokenType());
                    message.getExchange().put((Object)"ws-security.token", (Object)token);
                }
                return true;
            }
        }
        return false;
    }

    static CallbackHandler getCallbackHandler(Object o, Class<?> clazz) {
        CallbackHandler handler = null;
        if (o instanceof CallbackHandler) {
            handler = (CallbackHandler)o;
        } else if (o instanceof String) {
            try {
                handler = (CallbackHandler)ClassLoaderUtils.loadClass((String)((String)o), clazz).newInstance();
            }
            catch (Exception e) {
                handler = null;
            }
        }
        return handler;
    }
}

