/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.metadata;

import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.common.DefaultResult;
import org.mule.common.FailureType;
import org.mule.common.Result;
import org.mule.common.metadata.DefaultDefinedMapMetaDataModel;
import org.mule.common.metadata.DefaultListMetaDataModel;
import org.mule.common.metadata.DefaultMetaData;
import org.mule.common.metadata.DefaultPojoMetaDataModel;
import org.mule.common.metadata.DefaultSimpleMetaDataModel;
import org.mule.common.metadata.DefaultUnknownMetaDataModel;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.datatype.DataType;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.database.DbConfig;
import org.mule.module.db.internal.domain.param.InputQueryParam;
import org.mule.module.db.internal.domain.query.Query;
import org.mule.module.db.internal.domain.transaction.TransactionalAction;
import org.mule.module.db.internal.metadata.QueryMetadataProvider;
import org.mule.module.db.internal.resolver.database.DbConfigResolver;

public abstract class AbstractQueryMetadataProvider
implements QueryMetadataProvider {
    protected final Query query;
    protected final DbConfigResolver dbConfigResolver;
    private Map<Integer, MetaDataModel> dbToMetaDataType;

    public AbstractQueryMetadataProvider(DbConfigResolver dbConfigResolver, Query query) {
        this.dbConfigResolver = dbConfigResolver;
        this.query = query;
    }

    protected abstract Result<MetaData> getStaticOutputMetadata();

    protected abstract Result<MetaData> getDynamicOutputMetadata(PreparedStatement var1);

    protected Result<MetaData> getDynamicInputMetadata(PreparedStatement statement, Query query) {
        List<InputQueryParam> inputParams = query.getQueryTemplate().getInputParams();
        if (inputParams.size() == 0) {
            return null;
        }
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (InputQueryParam inputParam : inputParams) {
            String field = this.getReferencedField(inputParam);
            if (field == null) {
                return null;
            }
            fieldNames.add(field);
        }
        try {
            return this.getInputMetadataUsingStatementMetadata(statement, fieldNames);
        }
        catch (SQLException e) {
            return this.getStaticInputMetadata(fieldNames);
        }
    }

    private Result<MetaData> getStaticInputMetadata(List<String> fieldNames) {
        HashMap<String, MetaDataModel> recordModels = new HashMap<String, MetaDataModel>();
        for (String fieldName : fieldNames) {
            recordModels.put(fieldName, this.getDataTypeMetadataModel(12));
        }
        DefaultDefinedMapMetaDataModel recordModel = new DefaultDefinedMapMetaDataModel(recordModels);
        DefaultMetaData defaultMetaData = new DefaultMetaData((MetaDataModel)recordModel);
        return new DefaultResult((Object)defaultMetaData);
    }

    private Result<MetaData> getInputMetadataUsingStatementMetadata(PreparedStatement statement, List<String> fieldNames) throws SQLException {
        ParameterMetaData parameterMetaData = statement.getParameterMetaData();
        HashMap<String, MetaDataModel> recordModels = new HashMap<String, MetaDataModel>();
        int i = 1;
        for (String fieldName : fieldNames) {
            int dataType = parameterMetaData.getParameterType(i++);
            recordModels.put(fieldName, this.getDataTypeMetadataModel(dataType));
        }
        DefaultDefinedMapMetaDataModel recordModel = new DefaultDefinedMapMetaDataModel(recordModels);
        DefaultMetaData defaultMetaData = new DefaultMetaData((MetaDataModel)recordModel);
        return new DefaultResult((Object)defaultMetaData);
    }

    private String getReferencedField(InputQueryParam inputParam) {
        if (inputParam.getValue() == null || !(inputParam.getValue() instanceof String)) {
            return null;
        }
        String value = (String)inputParam.getValue();
        if (value.startsWith("#[") && value.endsWith("]") && ((value = value.substring(2, value.length() - 1)).startsWith("payload.") ? this.isValidIdentifier(value = value.substring(8)) : (value.startsWith("payload['") && value.endsWith("']") || value.startsWith("payload[\"") && value.endsWith("\"]")) && this.isValidIdentifier(value = value.substring(9, value.length() - 2)))) {
            return value;
        }
        return null;
    }

    private boolean isValidIdentifier(String value) {
        for (char c : value.toCharArray()) {
            if (Character.isJavaIdentifierPart(c)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MetaDataModel getDataTypeMetadataModel(int columnTypeName) {
        MetaDataModel metaDataModel;
        if (this.dbToMetaDataType == null) {
            AbstractQueryMetadataProvider abstractQueryMetadataProvider = this;
            synchronized (abstractQueryMetadataProvider) {
                if (this.dbToMetaDataType == null) {
                    this.initializeDbToMetaDataType();
                }
            }
        }
        if ((metaDataModel = this.dbToMetaDataType.get(columnTypeName)) != null) {
            return metaDataModel;
        }
        return new DefaultUnknownMetaDataModel();
    }

    private void initializeDbToMetaDataType() {
        this.dbToMetaDataType = new HashMap<Integer, MetaDataModel>();
        this.dbToMetaDataType.put(-7, (MetaDataModel)new DefaultSimpleMetaDataModel(DataType.BOOLEAN));
        this.dbToMetaDataType.put(-6, (MetaDataModel)new DefaultSimpleMetaDataModel(DataType.BYTE));
        this.dbToMetaDataType.put(5, (MetaDataModel)new DefaultSimpleMetaDataModel(DataType.SHORT));
        this.dbToMetaDataType.put(4, (MetaDataModel)new DefaultSimpleMetaDataModel(DataType.INTEGER));
        this.dbToMetaDataType.put(-5, (MetaDataModel)new DefaultSimpleMetaDataModel(DataType.LONG));
        this.dbToMetaDataType.put(6, (MetaDataModel)new DefaultSimpleMetaDataModel(DataType.FLOAT));
        this.dbToMetaDataType.put(7, (MetaDataModel)new DefaultSimpleMetaDataModel(DataType.FLOAT));
        this.dbToMetaDataType.put(8, (MetaDataModel)new DefaultSimpleMetaDataModel(DataType.DOUBLE));
        this.dbToMetaDataType.put(2, (MetaDataModel)new DefaultSimpleMetaDataModel(DataType.DECIMAL));
        this.dbToMetaDataType.put(3, (MetaDataModel)new DefaultSimpleMetaDataModel(DataType.DECIMAL));
        this.dbToMetaDataType.put(1, (MetaDataModel)new DefaultSimpleMetaDataModel(DataType.STRING));
        this.dbToMetaDataType.put(12, (MetaDataModel)new DefaultSimpleMetaDataModel(DataType.STRING));
        this.dbToMetaDataType.put(-16, (MetaDataModel)new DefaultSimpleMetaDataModel(DataType.STRING));
        DefaultSimpleMetaDataModel dateMetaDataModel = new DefaultSimpleMetaDataModel(DataType.DATE);
        dateMetaDataModel.setImplementationClass(Date.class.getName());
        this.dbToMetaDataType.put(91, (MetaDataModel)dateMetaDataModel);
        DefaultSimpleMetaDataModel timeMetaDataModel = new DefaultSimpleMetaDataModel(DataType.DATE_TIME);
        timeMetaDataModel.setImplementationClass(Time.class.getName());
        this.dbToMetaDataType.put(92, (MetaDataModel)timeMetaDataModel);
        DefaultSimpleMetaDataModel timestampMetaDataModel = new DefaultSimpleMetaDataModel(DataType.DATE_TIME);
        timeMetaDataModel.setImplementationClass(Timestamp.class.getName());
        this.dbToMetaDataType.put(93, (MetaDataModel)timestampMetaDataModel);
        DefaultListMetaDataModel binaryMetaDataModel = new DefaultListMetaDataModel((MetaDataModel)new DefaultSimpleMetaDataModel(DataType.BYTE), true);
        this.dbToMetaDataType.put(-2, (MetaDataModel)binaryMetaDataModel);
        DefaultListMetaDataModel varBinaryMetaDataModel = new DefaultListMetaDataModel((MetaDataModel)new DefaultSimpleMetaDataModel(DataType.BYTE), true);
        this.dbToMetaDataType.put(-3, (MetaDataModel)varBinaryMetaDataModel);
        DefaultListMetaDataModel longVarBinaryMetaDataModel = new DefaultListMetaDataModel((MetaDataModel)new DefaultSimpleMetaDataModel(DataType.BYTE), true);
        this.dbToMetaDataType.put(-4, (MetaDataModel)longVarBinaryMetaDataModel);
        this.dbToMetaDataType.put(0, (MetaDataModel)new DefaultUnknownMetaDataModel());
        this.dbToMetaDataType.put(1111, (MetaDataModel)new DefaultUnknownMetaDataModel());
        this.dbToMetaDataType.put(2000, (MetaDataModel)new DefaultPojoMetaDataModel(Object.class));
        this.dbToMetaDataType.put(2001, (MetaDataModel)new DefaultUnknownMetaDataModel());
        this.dbToMetaDataType.put(2002, (MetaDataModel)new DefaultPojoMetaDataModel(Struct.class));
        this.dbToMetaDataType.put(2003, (MetaDataModel)new DefaultListMetaDataModel((MetaDataModel)new DefaultUnknownMetaDataModel(), true));
        this.dbToMetaDataType.put(2004, (MetaDataModel)new DefaultPojoMetaDataModel(Blob.class));
        this.dbToMetaDataType.put(2005, (MetaDataModel)new DefaultPojoMetaDataModel(Clob.class));
        this.dbToMetaDataType.put(2006, (MetaDataModel)new DefaultPojoMetaDataModel(Ref.class));
        this.dbToMetaDataType.put(70, (MetaDataModel)new DefaultPojoMetaDataModel(URL.class));
        this.dbToMetaDataType.put(16, (MetaDataModel)new DefaultSimpleMetaDataModel(DataType.BOOLEAN));
        this.dbToMetaDataType.put(-8, (MetaDataModel)new DefaultPojoMetaDataModel(RowId.class));
        this.dbToMetaDataType.put(-15, (MetaDataModel)new DefaultSimpleMetaDataModel(DataType.STRING));
        this.dbToMetaDataType.put(-9, (MetaDataModel)new DefaultSimpleMetaDataModel(DataType.STRING));
        this.dbToMetaDataType.put(-16, (MetaDataModel)new DefaultSimpleMetaDataModel(DataType.STRING));
        this.dbToMetaDataType.put(2011, (MetaDataModel)new DefaultSimpleMetaDataModel(DataType.STRING));
        this.dbToMetaDataType.put(2009, (MetaDataModel)new DefaultPojoMetaDataModel(SQLXML.class));
    }

    @Override
    public Result<MetaData> getInputMetaData() {
        if (this.query.isDynamic()) {
            return new DefaultResult(null, Result.Status.FAILURE, "Cannot obtain metadata from a dynamic SQL");
        }
        return this.getMetaDataResult(this.query, new InputMetadataResolver());
    }

    @Override
    public Result<MetaData> getOutputMetaData(MetaData metaData) {
        if (this.query.isDynamic()) {
            Result<MetaData> staticMetadata = this.getStaticOutputMetadata();
            if (staticMetadata != null) {
                return staticMetadata;
            }
            return new DefaultResult(null, Result.Status.FAILURE, "Cannot obtain metadata from a dynamic SQL");
        }
        return this.getMetaDataResult(this.query, new OutputMetadataResolver());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result<MetaData> getMetaDataResult(Query query, MetadataResolver metadataResolver) {
        DbConnection connection = null;
        DbConfig dbConfig = this.dbConfigResolver.resolve(null);
        try {
            PreparedStatement preparedStatement;
            try {
                connection = dbConfig.getConnectionFactory().createConnection(TransactionalAction.NOT_SUPPORTED);
            }
            catch (SQLException e) {
                DefaultResult defaultResult = new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.CONNECTION_FAILURE, (Throwable)e);
                dbConfig.getConnectionFactory().releaseConnection(connection);
                return defaultResult;
            }
            try {
                preparedStatement = connection.prepareStatement(query.getQueryTemplate().getSqlText());
            }
            catch (SQLException e) {
                DefaultResult defaultResult = new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.INVALID_CONFIGURATION, (Throwable)e);
                dbConfig.getConnectionFactory().releaseConnection(connection);
                return defaultResult;
            }
            Result<MetaData> result = metadataResolver.resolveMetaData(preparedStatement, query);
            return result;
        }
        finally {
            dbConfig.getConnectionFactory().releaseConnection(connection);
        }
    }

    private class InputMetadataResolver
    implements MetadataResolver {
        private InputMetadataResolver() {
        }

        @Override
        public Result<MetaData> resolveMetaData(PreparedStatement statement, Query query) {
            return AbstractQueryMetadataProvider.this.getDynamicInputMetadata(statement, query);
        }
    }

    private class OutputMetadataResolver
    implements MetadataResolver {
        private OutputMetadataResolver() {
        }

        @Override
        public Result<MetaData> resolveMetaData(PreparedStatement statement, Query query) {
            return AbstractQueryMetadataProvider.this.getDynamicOutputMetadata(statement);
        }
    }

    private static interface MetadataResolver {
        public Result<MetaData> resolveMetaData(PreparedStatement var1, Query var2);
    }
}

