/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import org.eel.kitchen.jsonschema.keyword.AbstractTypeKeywordValidator;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.util.NodeType;
import org.eel.kitchen.jsonschema.validator.JsonValidator;
import org.eel.kitchen.jsonschema.validator.ValidationContext;

public final class DisallowKeywordValidator
extends AbstractTypeKeywordValidator {
    public DisallowKeywordValidator(JsonNode schema) {
        super("disallow", schema);
    }

    @Override
    public void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        NodeType type = NodeType.getNodeType(instance);
        if (this.typeSet.contains((Object)type)) {
            Message.Builder msg = this.newMsg().addInfo("found", type).addInfo("disallowed", this.typeSet).setMessage("instance type is not allowed");
            report.addMessage(msg.build());
            return;
        }
        if (this.schemas.isEmpty()) {
            return;
        }
        for (JsonNode schema : this.schemas) {
            JsonValidator validator = context.newValidator(schema);
            ValidationReport schemaReport = report.copy();
            validator.validate(context, schemaReport, instance);
            if (schemaReport.hasFatalError()) {
                report.mergeWith(schemaReport);
                return;
            }
            if (!schemaReport.isSuccess()) continue;
            Message.Builder msg = this.newMsg().setMessage("instance is valid against a disallowed schema");
            report.addMessage(msg.build());
            return;
        }
    }
}

