/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.ref;

import com.fasterxml.jackson.databind.JsonNode;
import org.eel.kitchen.jsonschema.main.JsonSchemaException;
import org.eel.kitchen.jsonschema.ref.IdFragment;
import org.eel.kitchen.jsonschema.ref.JsonPointer;

public abstract class JsonFragment
implements Comparable<JsonFragment> {
    private static final JsonFragment EMPTY = new JsonFragment(""){

        @Override
        public JsonNode resolve(JsonNode node) {
            return node;
        }
    };
    protected final String asString;

    protected JsonFragment(String input) {
        this.asString = input;
    }

    public static JsonFragment fromFragment(String fragment) {
        if (fragment.isEmpty()) {
            return EMPTY;
        }
        try {
            return new JsonPointer(fragment);
        }
        catch (JsonSchemaException ignored) {
            return new IdFragment(fragment);
        }
    }

    public abstract JsonNode resolve(JsonNode var1);

    public final boolean isEmpty() {
        return this == EMPTY;
    }

    @Override
    public final int compareTo(JsonFragment other) {
        return this.asString.compareTo(other.asString);
    }

    public final int hashCode() {
        return this.asString.hashCode();
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JsonFragment)) {
            return false;
        }
        JsonFragment other = (JsonFragment)obj;
        return this.asString.equals(other.asString);
    }

    public final String toString() {
        return this.asString;
    }
}

