/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.util;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;

public final class JsonLoader {
    private static final ObjectMapper mapper = new ObjectMapper().enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
    private static final Class<JsonLoader> myself = JsonLoader.class;

    private JsonLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonNode fromResource(String resource) throws IOException {
        JsonNode ret;
        InputStream in = myself.getResourceAsStream(resource);
        if (in == null) {
            throw new IOException("resource " + resource + " not found");
        }
        try {
            ret = mapper.readTree(in);
        }
        finally {
            in.close();
        }
        return ret;
    }

    public static JsonNode fromURL(URL url) throws IOException {
        return mapper.readTree(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonNode fromPath(String path) throws IOException {
        JsonNode ret;
        FileInputStream in = new FileInputStream(path);
        try {
            ret = mapper.readTree((InputStream)in);
        }
        finally {
            in.close();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonNode fromFile(File file) throws IOException {
        JsonNode ret;
        FileInputStream in = new FileInputStream(file);
        try {
            ret = mapper.readTree((InputStream)in);
        }
        finally {
            in.close();
        }
        return ret;
    }

    public static JsonNode fromReader(Reader reader) throws IOException {
        return mapper.readTree(reader);
    }

    public static JsonNode fromString(String json) throws IOException {
        return JsonLoader.fromReader(new StringReader(json));
    }
}

